/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.DecoratedExecutionResult;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.core.GraphQLMBean;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.schema.GraphQLFieldDefinition;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLHttpServlet
extends HttpServlet
implements Servlet,
GraphQLMBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphQLHttpServlet.class);

    protected abstract GraphQLConfiguration getConfiguration();

    public void addListener(GraphQLServletListener servletListener) {
        this.getConfiguration().add(servletListener);
    }

    public void removeListener(GraphQLServletListener servletListener) {
        this.getConfiguration().remove(servletListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.getConfiguration().getInvocationInputFactory().getSchemaProvider().getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.getConfiguration().getInvocationInputFactory().getSchemaProvider().getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            GraphQLRequest graphQLRequest = GraphQLRequest.createQueryOnlyRequest((String)query);
            GraphQLSingleInvocationInput invocationInput = this.getConfiguration().getInvocationInputFactory().create(graphQLRequest);
            DecoratedExecutionResult result = this.getConfiguration().getGraphQLInvoker().query((GraphQLInvocationInput)invocationInput).getResult();
            return this.getConfiguration().getObjectMapper().serializeResultAsJson((ExecutionResult)result);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doRequest(req, resp);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.getConfiguration().getHttpRequestHandler().handle(request, response);
        }
        catch (Exception t) {
            log.error("Error executing GraphQL request!", (Throwable)t);
        }
    }
}

