/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guicejunit4.core;

import com.google.inject.Injector;
import com.google.inject.internal.Preconditions;
import com.googlecode.guicejunit4.core.InjectWith;
import com.googlecode.guicejunit4.core.InterceptWith;
import com.googlecode.guicejunit4.core.TestContext;
import com.googlecode.guicejunit4.core.TestInterceptor;
import com.googlecode.guicejunit4.core.inner.Annotations;
import com.googlecode.guicejunit4.core.inner.Instances;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class GuiceJunit4ClassRunner
extends BlockJUnit4ClassRunner {
    private Injector injector;
    private Collection<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
    private Object testInstance;

    public GuiceJunit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.retrieveInjector(clazz);
        this.retrieveInterceptors(clazz);
    }

    private void retrieveInjector(Class<?> clazz) {
        InjectWith injectWith = Annotations.findInherited(clazz, InjectWith.class);
        Preconditions.checkNotNull((Object)injectWith, (Object)("Annotation " + InjectWith.class.getSimpleName() + " needed to present on " + clazz + " or it's super class or interfaces."));
        this.injector = Instances.create(injectWith.value()).get();
    }

    private void retrieveInterceptors(Class<?> clazz) {
        Class<? extends TestInterceptor>[] interceptorTypes;
        InterceptWith testInterceptors = Annotations.findInherited(clazz, InterceptWith.class);
        if (testInterceptors == null) {
            return;
        }
        for (Class<? extends TestInterceptor> type : interceptorTypes = testInterceptors.value()) {
            this.interceptors.add(Instances.create(type));
        }
    }

    protected Object createTest() throws Exception {
        Object instance = super.createTest();
        this.injector.injectMembers(instance);
        this.testInstance = instance;
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
        TestContext testContext = new TestContext(this.injector, this.testInstance, this.getTestClass().getJavaClass(), method.getMethod());
        for (TestInterceptor interceptor : this.interceptors) {
            try {
                interceptor.before(testContext);
            }
            catch (Exception e) {
                eachNotifier.addFailure((Throwable)e);
            }
        }
        try {
            super.runChild(method, notifier);
        }
        finally {
            for (TestInterceptor interceptor : this.interceptors) {
                try {
                    interceptor.after(testContext);
                }
                catch (Exception e) {
                    eachNotifier.addFailure((Throwable)e);
                }
            }
        }
    }
}

