/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import java.util.Set;

final class TypeEnumerator {
    private static final TypeScanner nameVisitor = new TypeScanner();

    private TypeEnumerator() {
    }

    static ImmutableSet<String> getTopLevelTypes(CompilationUnitTree t) {
        return ImmutableSet.copyOf(nameVisitor.scan((Tree)t, null));
    }

    static final class TypeScanner
    extends TreeScanner<Set<String>, Void> {
        TypeScanner() {
        }

        @Override
        public Set<String> scan(Tree node, Void v) {
            return (Set)MoreObjects.firstNonNull(super.scan(node, v), (Object)ImmutableSet.of());
        }

        @Override
        public Set<String> reduce(Set<String> r1, Set<String> r2) {
            return Sets.union(r1, r2);
        }

        @Override
        public Set<String> visitClass(ClassTree reference, Void v) {
            return ImmutableSet.of((Object)reference.getSimpleName().toString());
        }

        @Override
        public Set<String> visitExpressionStatement(ExpressionStatementTree reference, Void v) {
            return this.scan((Tree)reference.getExpression(), v);
        }

        @Override
        public Set<String> visitIdentifier(IdentifierTree reference, Void v) {
            return ImmutableSet.of((Object)reference.getName().toString());
        }

        @Override
        public Set<String> visitMemberSelect(MemberSelectTree reference, Void v) {
            Set<String> expressionSet = this.scan((Tree)reference.getExpression(), v);
            if (expressionSet.size() != 1) {
                String string = String.valueOf("Internal error in NameFinder. Expected to find exactly one identifier in the expression set. Found ");
                String string2 = String.valueOf(expressionSet);
                throw new AssertionError((Object)new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString());
            }
            String expressionStr = expressionSet.iterator().next();
            return ImmutableSet.of((Object)String.format("%s.%s", expressionStr, reference.getIdentifier()));
        }

        @Override
        public Set<String> visitCompilationUnit(CompilationUnitTree reference, Void v) {
            ImmutableSet packageSet;
            Object object = packageSet = reference.getPackageName() == null ? ImmutableSet.of((Object)"") : this.scan((Tree)reference.getPackageName(), v);
            if (packageSet.size() != 1) {
                String string = String.valueOf("Internal error in NameFinder. Expected to find at most one package identifier. Found ");
                String string2 = String.valueOf(packageSet);
                throw new AssertionError((Object)new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString());
            }
            final String packageName = packageSet.isEmpty() ? "" : (String)packageSet.iterator().next();
            Set typeDeclSet = (Set)this.scan(reference.getTypeDecls(), v);
            return FluentIterable.from((Iterable)typeDeclSet).transform((Function)new Function<String, String>(){

                public String apply(String typeName) {
                    return packageName.isEmpty() ? typeName : String.format("%s.%s", packageName, typeName);
                }
            }).toSet();
        }
    }
}

