/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import com.google.testing.compile.ProcessedCompileTesterFactory;
import com.google.testing.compile.TreeContext;
import com.google.testing.compile.TreeDiffer;
import com.google.testing.compile.TreeDifference;
import com.google.testing.compile.TypeEnumerator;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public final class JavaSourcesSubject
extends Subject<JavaSourcesSubject, Iterable<? extends JavaFileObject>>
implements CompileTester,
ProcessedCompileTesterFactory {
    private final List<String> options = new ArrayList<String>(Arrays.asList("-Xlint"));

    JavaSourcesSubject(FailureStrategy failureStrategy, Iterable<? extends JavaFileObject> subject) {
        super(failureStrategy, subject);
    }

    @Override
    public JavaSourcesSubject withCompilerOptions(Iterable<String> options) {
        Iterables.addAll(this.options, options);
        return this;
    }

    @Override
    public JavaSourcesSubject withCompilerOptions(String ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @Override
    public CompileTester processedWith(Processor first, Processor ... rest) {
        return this.processedWith(Lists.asList((Object)first, (Object[])rest));
    }

    @Override
    public CompileTester processedWith(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    @Override
    public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
        new CompilationClause().parsesAs(first, rest);
    }

    @Override
    public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
        return new CompilationClause().compilesWithoutError();
    }

    @Override
    public CompileTester.CleanCompilationClause compilesWithoutWarnings() {
        return new CompilationClause().compilesWithoutWarnings();
    }

    @Override
    public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
        return new CompilationClause().failsToCompile();
    }

    private CompilationClause newCompilationClause(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    private static String messageListing(Iterable<? extends Diagnostic<?>> diagnostics, String headingFormat, Object ... formatArgs) {
        StringBuilder listing = new StringBuilder(String.format(headingFormat, formatArgs)).append('\n');
        for (Diagnostic<?> diagnostic : diagnostics) {
            listing.append(diagnostic.getMessage(null)).append('\n');
        }
        return listing.toString();
    }

    private static String kindToString(Diagnostic.Kind kind, boolean expectingSpecificCount) {
        switch (kind) {
            case ERROR: {
                return expectingSpecificCount ? "errors" : "an error";
            }
            case MANDATORY_WARNING: 
            case WARNING: {
                return expectingSpecificCount ? "warnings" : "a warning";
            }
            case NOTE: {
                return expectingSpecificCount ? "notes" : "a note";
            }
            case OTHER: {
                return expectingSpecificCount ? "diagnostic messages" : "a diagnostic message";
            }
        }
        throw new AssertionError((Object)kind);
    }

    public static JavaSourcesSubject assertThat(JavaFileObject ... javaFileObjects) {
        return (JavaSourcesSubject)Truth.assertAbout((SubjectFactory)JavaSourcesSubjectFactory.javaSources()).that((Object)ImmutableList.copyOf((Object[])javaFileObjects));
    }

    public static final class SingleSourceAdapter
    extends Subject<SingleSourceAdapter, JavaFileObject>
    implements CompileTester,
    ProcessedCompileTesterFactory {
        private final JavaSourcesSubject delegate;

        SingleSourceAdapter(FailureStrategy failureStrategy, JavaFileObject subject) {
            super(failureStrategy, (Object)subject);
            this.delegate = new JavaSourcesSubject(failureStrategy, (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)subject));
        }

        @Override
        public JavaSourcesSubject withCompilerOptions(Iterable<String> options) {
            return this.delegate.withCompilerOptions((Iterable)options);
        }

        @Override
        public JavaSourcesSubject withCompilerOptions(String ... options) {
            return this.delegate.withCompilerOptions(options);
        }

        @Override
        public CompileTester processedWith(Processor first, Processor ... rest) {
            return this.delegate.newCompilationClause(Lists.asList((Object)first, (Object[])rest));
        }

        @Override
        public CompileTester processedWith(Iterable<? extends Processor> processors) {
            return this.delegate.newCompilationClause(processors);
        }

        @Override
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            return this.delegate.compilesWithoutError();
        }

        @Override
        public CompileTester.CleanCompilationClause compilesWithoutWarnings() {
            return this.delegate.compilesWithoutWarnings();
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            return this.delegate.failsToCompile();
        }

        @Override
        public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
            this.delegate.parsesAs(first, rest);
        }
    }

    private final class SuccessfulFileBuilder<T>
    implements CompileTester.SuccessfulFileClause<T> {
        private final CompileTester.GeneratedPredicateClause<T> chainedClause;
        private final String generatedFilePath;
        private final ByteSource generatedByteSource;

        SuccessfulFileBuilder(CompileTester.GeneratedPredicateClause<T> chainedClause, String generatedFilePath, ByteSource generatedByteSource) {
            this.chainedClause = chainedClause;
            this.generatedFilePath = generatedFilePath;
            this.generatedByteSource = generatedByteSource;
        }

        @Override
        public CompileTester.GeneratedPredicateClause<T> and() {
            return this.chainedClause;
        }

        @Override
        public CompileTester.SuccessfulFileClause<T> withContents(ByteSource expectedByteSource) {
            try {
                if (!expectedByteSource.contentEquals(this.generatedByteSource)) {
                    String string = this.generatedFilePath;
                    JavaSourcesSubject.this.failureStrategy.fail(new StringBuilder(52 + String.valueOf(string).length()).append("The contents in ").append(string).append(" did not match the expected contents").toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public CompileTester.SuccessfulFileClause<T> withStringContents(Charset charset, String expectedString) {
            try {
                String generatedString = this.generatedByteSource.asCharSource(charset).read();
                if (!generatedString.equals(expectedString)) {
                    String string = this.generatedFilePath;
                    JavaSourcesSubject.this.failureStrategy.failComparing(new StringBuilder(50 + String.valueOf(string).length()).append("The contents in ").append(string).append(" did not match the expected string").toString(), (CharSequence)expectedString, (CharSequence)generatedString);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }
    }

    private final class CleanCompilationBuilder
    extends GeneratedCompilationBuilder<CompileTester.CleanCompilationClause>
    implements CompileTester.CleanCompilationClause {
        CleanCompilationBuilder(Compilation.Result result) {
            super(result);
            Preconditions.checkArgument((boolean)result.successful());
        }
    }

    private final class SuccessfulCompilationBuilder
    extends GeneratedCompilationBuilder<CompileTester.SuccessfulCompilationClause>
    implements CompileTester.SuccessfulCompilationClause {
        SuccessfulCompilationBuilder(Compilation.Result result) {
            super(result);
            Preconditions.checkArgument((boolean)result.successful());
        }
    }

    private final class UnsuccessfulCompilationBuilder
    extends CompilationWithWarningsBuilder<CompileTester.UnsuccessfulCompilationClause>
    implements CompileTester.UnsuccessfulCompilationClause {
        UnsuccessfulCompilationBuilder(Compilation.Result result) {
            super(result);
            Preconditions.checkArgument((!result.successful() ? 1 : 0) != 0);
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause withErrorCount(int errorCount) {
            return (CompileTester.UnsuccessfulCompilationClause)this.withDiagnosticCount(Diagnostic.Kind.ERROR, errorCount);
        }

        @Override
        public CompileTester.FileClause<CompileTester.UnsuccessfulCompilationClause> withErrorContaining(String messageFragment) {
            return this.withDiagnosticContaining(Diagnostic.Kind.ERROR, messageFragment);
        }
    }

    private abstract class GeneratedCompilationBuilder<T>
    extends CompilationWithWarningsBuilder<T>
    implements CompileTester.GeneratedPredicateClause<T>,
    CompileTester.ChainingClause<CompileTester.GeneratedPredicateClause<T>> {
        protected GeneratedCompilationBuilder(Compilation.Result result) {
            super(result);
        }

        @Override
        public T generatesSources(JavaFileObject first, JavaFileObject ... rest) {
            new JavaSourcesSubject(JavaSourcesSubject.this.failureStrategy, (Iterable<? extends JavaFileObject>)this.result.generatedSources()).parsesAs(first, rest);
            return this.thisObject();
        }

        @Override
        public T generatesFiles(JavaFileObject first, JavaFileObject ... rest) {
            for (JavaFileObject expected : Lists.asList((Object)first, (Object[])rest)) {
                if (this.wasGenerated(this.result, expected)) continue;
                String string = String.valueOf(expected.getName());
                JavaSourcesSubject.this.failureStrategy.fail(string.length() != 0 ? "Did not find a generated file corresponding to ".concat(string) : new String("Did not find a generated file corresponding to "));
            }
            return this.thisObject();
        }

        boolean wasGenerated(Compilation.Result result, JavaFileObject expected) {
            ByteSource expectedByteSource = JavaFileObjects.asByteSource(expected);
            for (JavaFileObject generated : result.generatedFilesByKind().get((Object)expected.getKind())) {
                try {
                    ByteSource generatedByteSource = JavaFileObjects.asByteSource(generated);
                    if (!expectedByteSource.contentEquals(generatedByteSource)) continue;
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Override
        public CompileTester.SuccessfulFileClause<T> generatesFileNamed(JavaFileManager.Location location, String packageName, String relativeName) {
            String expectedFilename = location.getName() + '/' + packageName.replace('.', '/') + '/' + relativeName;
            for (JavaFileObject generated : this.result.generatedFilesByKind().values()) {
                if (!generated.toUri().getPath().endsWith(expectedFilename)) continue;
                return new SuccessfulFileBuilder(this, generated.toUri().getPath(), JavaFileObjects.asByteSource(generated));
            }
            StringBuilder encounteredFiles = new StringBuilder();
            for (JavaFileObject generated : this.result.generatedFilesByKind().values()) {
                if (!generated.toUri().getPath().contains(location.getName())) continue;
                encounteredFiles.append("  ").append(generated.toUri().getPath()).append('\n');
            }
            Object object = String.valueOf(encounteredFiles.toString());
            JavaSourcesSubject.this.failureStrategy.fail(new StringBuilder(68 + String.valueOf(relativeName).length() + String.valueOf(packageName).length() + String.valueOf(object).length()).append("Did not find a generated file corresponding to ").append(relativeName).append(" in package ").append(packageName).append("; Found: ").append((String)object).toString());
            return new SuccessfulFileBuilder(this, null, null);
        }

        @Override
        public CompileTester.GeneratedPredicateClause<T> and() {
            return this;
        }
    }

    private abstract class CompilationWithWarningsBuilder<T>
    implements CompileTester.CompilationWithWarningsClause<T> {
        protected final Compilation.Result result;

        protected CompilationWithWarningsBuilder(Compilation.Result result) {
            this.result = result;
        }

        @Override
        public T withNoteCount(int noteCount) {
            return this.withDiagnosticCount(Diagnostic.Kind.NOTE, noteCount);
        }

        @Override
        public CompileTester.FileClause<T> withNoteContaining(String messageFragment) {
            return this.withDiagnosticContaining(Diagnostic.Kind.NOTE, messageFragment);
        }

        @Override
        public T withWarningCount(int warningCount) {
            return this.withDiagnosticCount(Diagnostic.Kind.WARNING, warningCount);
        }

        @Override
        public CompileTester.FileClause<T> withWarningContaining(String messageFragment) {
            return this.withDiagnosticContaining(Diagnostic.Kind.WARNING, messageFragment);
        }

        protected T withDiagnosticCount(Diagnostic.Kind kind, int expectedCount) {
            ImmutableList diagnostics = this.result.diagnosticsByKind().get((Object)kind);
            if (diagnostics.size() != expectedCount) {
                JavaSourcesSubject.this.failureStrategy.fail(JavaSourcesSubject.messageListing((Iterable)diagnostics, "Expected %d %s, but found the following %d %s:", new Object[]{expectedCount, JavaSourcesSubject.kindToString(kind, true), diagnostics.size(), JavaSourcesSubject.kindToString(kind, true)}));
            }
            return this.thisObject();
        }

        protected CompileTester.FileClause<T> withDiagnosticContaining(final Diagnostic.Kind kind, final String messageFragment) {
            FluentIterable diagnostics = FluentIterable.from((Iterable)this.result.diagnosticsByKind().get((Object)kind));
            final FluentIterable diagnosticsWithMessage = diagnostics.filter(new Predicate<Diagnostic<?>>(){

                public boolean apply(Diagnostic<?> input) {
                    return input.getMessage(null).contains(messageFragment);
                }
            });
            if (diagnosticsWithMessage.isEmpty()) {
                JavaSourcesSubject.this.failureStrategy.fail(JavaSourcesSubject.messageListing((Iterable)diagnostics, "Expected %s containing \"%s\", but only found:", new Object[]{JavaSourcesSubject.kindToString(kind, false), messageFragment}));
            }
            return new CompileTester.FileClause<T>(){

                @Override
                public T and() {
                    return CompilationWithWarningsBuilder.this.thisObject();
                }

                @Override
                public CompileTester.LineClause<T> in(final JavaFileObject file) {
                    final FluentIterable diagnosticsInFile = diagnosticsWithMessage.filter((Predicate)new Predicate<Diagnostic<? extends FileObject>>(){

                        public boolean apply(Diagnostic<? extends FileObject> input) {
                            return input.getSource() != null && file.toUri().getPath().equals(input.getSource().toUri().getPath());
                        }
                    });
                    if (diagnosticsInFile.isEmpty()) {
                        JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected %s in %s, but only found them in %s", JavaSourcesSubject.kindToString(kind, false), file.getName(), diagnosticsWithMessage.transform((Function)new Function<Diagnostic<? extends FileObject>, String>(){

                            public String apply(Diagnostic<? extends FileObject> input) {
                                return input.getSource() != null ? input.getSource().getName() : "(no associated file)";
                            }
                        }).toSet()));
                    }
                    return new CompileTester.LineClause<T>(){

                        @Override
                        public T and() {
                            return CompilationWithWarningsBuilder.this.thisObject();
                        }

                        @Override
                        public CompileTester.ColumnClause<T> onLine(final long lineNumber) {
                            final FluentIterable diagnosticsOnLine = diagnosticsWithMessage.filter(new Predicate<Diagnostic<?>>(){

                                public boolean apply(Diagnostic<?> input) {
                                    return lineNumber == input.getLineNumber();
                                }
                            });
                            if (diagnosticsOnLine.isEmpty()) {
                                JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected %s on line %d of %s, but only found them on line(s) %s", JavaSourcesSubject.kindToString(kind, false), lineNumber, file.getName(), diagnosticsInFile.transform(new Function<Diagnostic<?>, String>(){

                                    public String apply(Diagnostic<?> input) {
                                        long errLine = input.getLineNumber();
                                        return errLine != -1L ? new StringBuilder(20).append(errLine).toString() : "(no associated position)";
                                    }
                                }).toSet()));
                            }
                            return new CompileTester.ColumnClause<T>(){

                                @Override
                                public T and() {
                                    return CompilationWithWarningsBuilder.this.thisObject();
                                }

                                @Override
                                public CompileTester.ChainingClause<T> atColumn(final long columnNumber) {
                                    FluentIterable diagnosticsAtColumn = diagnosticsOnLine.filter(new Predicate<Diagnostic<?>>(){

                                        public boolean apply(Diagnostic<?> input) {
                                            return columnNumber == input.getColumnNumber();
                                        }
                                    });
                                    if (diagnosticsAtColumn.isEmpty()) {
                                        JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected %s at %d:%d of %s, but only found them at column(s) %s", JavaSourcesSubject.kindToString(kind, false), lineNumber, columnNumber, file.getName(), diagnosticsOnLine.transform(new Function<Diagnostic<?>, String>(){

                                            public String apply(Diagnostic<?> input) {
                                                long errCol = input.getColumnNumber();
                                                return errCol != -1L ? new StringBuilder(20).append(errCol).toString() : "(no associated position)";
                                            }
                                        }).toSet()));
                                    }
                                    return this;
                                }
                            };
                        }
                    };
                }
            };
        }

        protected final T thisObject() {
            return (T)this;
        }
    }

    private final class CompilationClause
    implements CompileTester {
        private final ImmutableSet<Processor> processors;

        private CompilationClause() {
            this((Iterable<? extends Processor>)ImmutableSet.of());
        }

        private CompilationClause(Iterable<? extends Processor> processors) {
            this.processors = ImmutableSet.copyOf(processors);
        }

        private String reportFileGenerated(JavaFileObject generatedFile) {
            try {
                StringBuilder entry = new StringBuilder().append(String.format("\n%s:\n", generatedFile.toUri().getPath()));
                if (generatedFile.getKind().equals((Object)JavaFileObject.Kind.CLASS)) {
                    entry.append(String.format("[generated class file (%s bytes)]", JavaFileObjects.asByteSource(generatedFile).size()));
                } else {
                    entry.append(generatedFile.getCharContent(true));
                }
                return entry.append("\n").toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }

        private String reportFilesGenerated(Compilation.Result result) {
            FluentIterable generatedFiles = FluentIterable.from(result.generatedSources());
            StringBuilder message = new StringBuilder("\n\n");
            if (generatedFiles.isEmpty()) {
                return message.append("(No files were generated.)\n").toString();
            }
            message.append("Generated Files\n").append("===============\n");
            for (JavaFileObject generatedFile : generatedFiles) {
                message.append(this.reportFileGenerated(generatedFile));
            }
            return message.toString();
        }

        @Override
        public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
            Compilation.ParseResult actualResult = Compilation.parse((Iterable)JavaSourcesSubject.this.getSubject());
            ImmutableList errors = actualResult.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR);
            if (!errors.isEmpty()) {
                StringBuilder message = new StringBuilder("Parsing produced the following errors:\n");
                for (Diagnostic error : errors) {
                    message.append('\n');
                    message.append(error);
                }
                JavaSourcesSubject.this.failureStrategy.fail(message.toString());
            }
            Compilation.ParseResult expectedResult = Compilation.parse(Lists.asList((Object)first, (Object[])rest));
            final FluentIterable actualTrees = FluentIterable.from(actualResult.compilationUnits());
            FluentIterable expectedTrees = FluentIterable.from(expectedResult.compilationUnits());
            Function<CompilationUnitTree, ImmutableSet<String>> getTypesFunction = new Function<CompilationUnitTree, ImmutableSet<String>>(){

                public ImmutableSet<String> apply(CompilationUnitTree compilationUnit) {
                    return TypeEnumerator.getTopLevelTypes(compilationUnit);
                }
            };
            final ImmutableMap expectedTreeTypes = Maps.toMap((Iterable)expectedTrees, (Function)getTypesFunction);
            final ImmutableMap actualTreeTypes = Maps.toMap((Iterable)actualTrees, (Function)getTypesFunction);
            ImmutableMap matchedTrees = Maps.toMap((Iterable)expectedTrees, (Function)new Function<CompilationUnitTree, Optional<? extends CompilationUnitTree>>(){

                public Optional<? extends CompilationUnitTree> apply(final CompilationUnitTree expectedTree) {
                    return Iterables.tryFind((Iterable)actualTrees, (Predicate)new Predicate<CompilationUnitTree>(){

                        public boolean apply(CompilationUnitTree actualTree) {
                            return ((ImmutableSet)expectedTreeTypes.get((Object)expectedTree)).equals(actualTreeTypes.get((Object)actualTree));
                        }
                    });
                }
            });
            for (Map.Entry matchedTreePair : matchedTrees.entrySet()) {
                CompilationUnitTree expectedTree = (CompilationUnitTree)matchedTreePair.getKey();
                if (!((Optional)matchedTreePair.getValue()).isPresent()) {
                    this.failNoCandidates((ImmutableSet<String>)((ImmutableSet)expectedTreeTypes.get((Object)expectedTree)), expectedTree, (ImmutableMap<? extends CompilationUnitTree, ImmutableSet<String>>)actualTreeTypes, (FluentIterable<? extends CompilationUnitTree>)actualTrees);
                    continue;
                }
                CompilationUnitTree actualTree = (CompilationUnitTree)((Optional)matchedTreePair.getValue()).get();
                TreeDifference treeDifference = TreeDiffer.diffCompilationUnits(expectedTree, actualTree);
                if (treeDifference.isEmpty()) continue;
                String diffReport = treeDifference.getDiffReport(new TreeContext(expectedTree, expectedResult.trees()), new TreeContext(actualTree, actualResult.trees()));
                this.failWithCandidate(expectedTree.getSourceFile(), actualTree.getSourceFile(), diffReport);
            }
        }

        private void failNoCandidates(ImmutableSet<String> expectedTypes, CompilationUnitTree expectedTree, final ImmutableMap<? extends CompilationUnitTree, ImmutableSet<String>> actualTypes, FluentIterable<? extends CompilationUnitTree> actualTrees) {
            String generatedTypesReport = Joiner.on((char)'\n').join((Iterable)actualTrees.transform((Function)new Function<CompilationUnitTree, String>(){

                public String apply(CompilationUnitTree generated) {
                    return String.format("- %s in <%s>", actualTypes.get((Object)generated), generated.getSourceFile().toUri().getPath());
                }
            }).toList());
            JavaSourcesSubject.this.failureStrategy.fail(Joiner.on((char)'\n').join((Object)"", (Object)"An expected source declared one or more top-level types that were not present.", new Object[]{"", String.format("Expected top-level types: <%s>", expectedTypes), String.format("Declared by expected file: <%s>", expectedTree.getSourceFile().toUri().getPath()), "", "The top-level types that were present are as follows: ", "", generatedTypesReport, ""}));
        }

        private void failWithCandidate(JavaFileObject expectedSource, JavaFileObject actualSource, String diffReport) {
            try {
                JavaSourcesSubject.this.failureStrategy.fail(Joiner.on((char)'\n').join((Object)"", (Object)"Source declared the same top-level types of an expected source, but", new Object[]{"didn't match exactly.", "", String.format("Expected file: <%s>", expectedSource.toUri().getPath()), String.format("Actual file: <%s>", actualSource.toUri().getPath()), "", "Diffs:", "======", "", diffReport, "", "Expected Source: ", "================", "", expectedSource.getCharContent(false).toString(), "", "Actual Source:", "=================", "", actualSource.getCharContent(false).toString()}));
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }

        @Override
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            return new SuccessfulCompilationBuilder(this.successfulCompilationResult());
        }

        @Override
        public CompileTester.CleanCompilationClause compilesWithoutWarnings() {
            return (CompileTester.CleanCompilationClause)new CleanCompilationBuilder(this.successfulCompilationResult()).withWarningCount(0);
        }

        private Compilation.Result successfulCompilationResult() {
            Compilation.Result result = Compilation.compile(this.processors, JavaSourcesSubject.this.options, (Iterable)JavaSourcesSubject.this.getSubject());
            if (!result.successful()) {
                ImmutableList errors = result.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR);
                StringBuilder message = new StringBuilder("Compilation produced the following errors:\n");
                for (Diagnostic error : errors) {
                    message.append('\n');
                    message.append(error);
                }
                message.append('\n');
                message.append(this.reportFilesGenerated(result));
                JavaSourcesSubject.this.failureStrategy.fail(message.toString());
            }
            return result;
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            Compilation.Result result = Compilation.compile(this.processors, JavaSourcesSubject.this.options, (Iterable)JavaSourcesSubject.this.getSubject());
            if (result.successful()) {
                String message = Joiner.on((char)'\n').join((Object)"Compilation was expected to fail, but contained no errors.", (Object)"", new Object[]{this.reportFilesGenerated(result)});
                JavaSourcesSubject.this.failureStrategy.fail(message);
            }
            return new UnsuccessfulCompilationBuilder(result);
        }
    }
}

