/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class JavaFileObjects {
    private static final Joiner LINE_JOINER = Joiner.on((char)'\n');

    private JavaFileObjects() {
    }

    public static JavaFileObject forSourceString(String fullyQualifiedName, String source) {
        Preconditions.checkNotNull((Object)fullyQualifiedName);
        if (fullyQualifiedName.startsWith("package ")) {
            throw new IllegalArgumentException(String.format("fullyQualifiedName starts with \"package\" (%s). Did you forget to specify the name and specify just the source text?", fullyQualifiedName));
        }
        return new StringSourceJavaFileObject(fullyQualifiedName, (String)Preconditions.checkNotNull((Object)source));
    }

    public static JavaFileObject forSourceLines(String fullyQualifiedName, String ... lines) {
        return JavaFileObjects.forSourceLines(fullyQualifiedName, Arrays.asList(lines));
    }

    public static JavaFileObject forSourceLines(String fullyQualifiedName, Iterable<String> lines) {
        return JavaFileObjects.forSourceString(fullyQualifiedName, LINE_JOINER.join(lines));
    }

    public static JavaFileObject forResource(URL resourceUrl) {
        if ("jar".equals(resourceUrl.getProtocol())) {
            return new JarFileJavaFileObject(resourceUrl);
        }
        return new ResourceSourceJavaFileObject(resourceUrl);
    }

    public static JavaFileObject forResource(String resourceName) {
        return JavaFileObjects.forResource(Resources.getResource((String)resourceName));
    }

    static JavaFileObject.Kind deduceKind(URI uri) {
        String path = uri.getPath();
        for (JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            if (!path.endsWith(kind.extension)) continue;
            return kind;
        }
        return JavaFileObject.Kind.OTHER;
    }

    static ByteSource asByteSource(final JavaFileObject javaFileObject) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return javaFileObject.openInputStream();
            }
        };
    }

    private static final class ResourceSourceJavaFileObject
    extends SimpleJavaFileObject {
        final ByteSource resourceByteSource;

        ResourceSourceJavaFileObject(URL resourceUrl, URI resourceUri) {
            super(resourceUri, JavaFileObjects.deduceKind(resourceUri));
            this.resourceByteSource = Resources.asByteSource((URL)resourceUrl);
        }

        ResourceSourceJavaFileObject(URL resourceUrl) {
            this(resourceUrl, URI.create(resourceUrl.toString()));
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.resourceByteSource.asCharSource(Charset.defaultCharset()).read();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.resourceByteSource.openStream();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return this.resourceByteSource.asCharSource(Charset.defaultCharset()).openStream();
        }
    }

    private static final class JarFileJavaFileObject
    extends ForwardingJavaFileObject<ResourceSourceJavaFileObject> {
        final String name;
        static final Splitter JAR_URL_SPLITTER = Splitter.on((char)'!');

        JarFileJavaFileObject(URL jarUrl) {
            super(new ResourceSourceJavaFileObject(jarUrl, JarFileJavaFileObject.getPathUri(jarUrl)));
            this.name = jarUrl.toString();
        }

        static final URI getPathUri(URL jarUrl) {
            ImmutableList parts = ImmutableList.copyOf((Iterable)JAR_URL_SPLITTER.split((CharSequence)jarUrl.getPath()));
            Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"The jar url separator (!) appeared more than once in the url: %s", (Object[])new Object[]{jarUrl});
            String pathPart = (String)parts.get(1);
            Preconditions.checkArgument((!pathPart.endsWith("/") ? 1 : 0) != 0, (String)"cannot create a java file object for a directory: %s", (Object[])new Object[]{pathPart});
            return URI.create(pathPart);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static final class StringSourceJavaFileObject
    extends SimpleJavaFileObject {
        final String source;
        final long lastModified;

        StringSourceJavaFileObject(String fullyQualifiedName, String source) {
            super(StringSourceJavaFileObject.createUri(fullyQualifiedName), JavaFileObject.Kind.SOURCE);
            this.source = source;
            this.lastModified = System.currentTimeMillis();
        }

        static URI createUri(String fullyQualifiedClassName) {
            String string = String.valueOf(CharMatcher.is((char)'.').replaceFrom((CharSequence)fullyQualifiedClassName, '/'));
            String string2 = String.valueOf(JavaFileObject.Kind.SOURCE.extension);
            return URI.create(string2.length() != 0 ? string.concat(string2) : new String(string));
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }

        @Override
        public OutputStream openOutputStream() {
            throw new IllegalStateException();
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.source.getBytes(Charset.defaultCharset()));
        }

        @Override
        public Writer openWriter() {
            throw new IllegalStateException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            return new StringReader(this.source);
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }
    }
}

