/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.testing.compile.JavaFileObjects;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

final class InMemoryJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final LoadingCache<URI, JavaFileObject> inMemoryFileObjects = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<URI, JavaFileObject>(){

        public JavaFileObject load(URI key) {
            return new InMemoryJavaFileObject(key);
        }
    });

    InMemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    private static URI uriForFileObject(JavaFileManager.Location location, String packageName, String relativeName) {
        String string = String.valueOf(location.getName());
        String string2 = String.valueOf(CharMatcher.is((char)'.').replaceFrom((CharSequence)packageName, '/'));
        return URI.create(new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(relativeName).length()).append("mem:///").append(string).append("/").append(string2).append("/").append(relativeName).toString());
    }

    private static URI uriForJavaFileObject(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        String string = String.valueOf(location.getName());
        String string2 = String.valueOf(CharMatcher.is((char)'.').replaceFrom((CharSequence)className, '/'));
        String string3 = String.valueOf(kind.extension);
        return URI.create(new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("mem:///").append(string).append("/").append(string2).append(string3).toString());
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (location.isOutputLocation()) {
            return (FileObject)this.inMemoryFileObjects.getIfPresent((Object)InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName));
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location.isOutputLocation()) {
            return (JavaFileObject)this.inMemoryFileObjects.getIfPresent((Object)InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind));
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName);
        return (FileObject)this.inMemoryFileObjects.getUnchecked((Object)uri);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind);
        return (JavaFileObject)this.inMemoryFileObjects.getUnchecked((Object)uri);
    }

    ImmutableList<JavaFileObject> getGeneratedSources() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : this.inMemoryFileObjects.asMap().entrySet()) {
            String string = String.valueOf(StandardLocation.SOURCE_OUTPUT.name());
            if (!((URI)entry.getKey()).getPath().startsWith(string.length() != 0 ? "/".concat(string) : new String("/")) || ((JavaFileObject)entry.getValue()).getKind() != JavaFileObject.Kind.SOURCE) continue;
            result.add(entry.getValue());
        }
        return result.build();
    }

    ImmutableList<JavaFileObject> getOutputFiles() {
        return ImmutableList.copyOf(this.inMemoryFileObjects.asMap().values());
    }

    private static final class InMemoryJavaFileObject
    extends SimpleJavaFileObject
    implements JavaFileObject {
        private long lastModified = 0L;
        private Optional<ByteSource> data = Optional.absent();

        InMemoryJavaFileObject(URI uri) {
            super(uri, JavaFileObjects.deduceKind(uri));
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.data.isPresent()) {
                return ((ByteSource)this.data.get()).openStream();
            }
            throw new FileNotFoundException();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    InMemoryJavaFileObject.this.data = Optional.of((Object)ByteSource.wrap((byte[])this.toByteArray()));
                    InMemoryJavaFileObject.this.lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return ((ByteSource)this.data.get()).asCharSource(Charset.defaultCharset()).openStream();
            }
            throw new FileNotFoundException();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return ((ByteSource)this.data.get()).asCharSource(Charset.defaultCharset()).read();
            }
            throw new FileNotFoundException();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    super.close();
                    InMemoryJavaFileObject.this.data = Optional.of((Object)ByteSource.wrap((byte[])this.toString().getBytes(Charset.defaultCharset())));
                    InMemoryJavaFileObject.this.lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public boolean delete() {
            this.data = Optional.absent();
            this.lastModified = 0L;
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.toUri()).add("kind", (Object)this.kind).toString();
        }
    }
}

