/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.JavaFileObjects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class CompilationRule
implements TestRule {
    private Elements elements;
    private Types types;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                final AtomicReference thrown = new AtomicReference();
                Compilation.Result result = Compilation.compile((Iterable<? extends Processor>)ImmutableList.of((Object)new AbstractProcessor(){

                    @Override
                    public SourceVersion getSupportedSourceVersion() {
                        return SourceVersion.latest();
                    }

                    @Override
                    public Set<String> getSupportedAnnotationTypes() {
                        return ImmutableSet.of((Object)"*");
                    }

                    @Override
                    public synchronized void init(ProcessingEnvironment processingEnv) {
                        super.init(processingEnv);
                        CompilationRule.this.elements = processingEnv.getElementUtils();
                        CompilationRule.this.types = processingEnv.getTypeUtils();
                    }

                    @Override
                    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                        if (roundEnv.processingOver()) {
                            try {
                                base.evaluate();
                            }
                            catch (Throwable e) {
                                thrown.set(e);
                            }
                        }
                        return false;
                    }
                }), (Iterable<String>)ImmutableSet.of(), (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)JavaFileObjects.forSourceLines("Dummy", "final class Dummy {}")));
                Preconditions.checkState((boolean)result.successful(), (Object)result);
                Throwable t = (Throwable)thrown.get();
                if (t != null) {
                    throw t;
                }
            }
        };
    }

    public Elements getElements() {
        Preconditions.checkState((this.elements != null ? 1 : 0) != 0, (Object)"Not running within the rule");
        return this.elements;
    }

    public Types getTypes() {
        Preconditions.checkState((this.elements != null ? 1 : 0) != 0, (Object)"Not running within the rule");
        return this.types;
    }
}

