/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.throwingproviders.CheckedProvideUtils;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.CheckedProviderMethod;
import com.google.inject.throwingproviders.CheckedProviderMethodsModule;
import com.google.inject.throwingproviders.CheckedProviderWithDependencies;
import com.google.inject.throwingproviders.ProviderChecker;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ThrowingProviderBinder {
    private static final TypeLiteral<CheckedProvider<?>> CHECKED_PROVIDER_TYPE = new TypeLiteral<CheckedProvider<?>>(){};
    private static final TypeLiteral<CheckedProviderMethod<?>> CHECKED_PROVIDER_METHOD_TYPE = new TypeLiteral<CheckedProviderMethod<?>>(){};
    private final Binder binder;

    private ThrowingProviderBinder(Binder binder) {
        this.binder = binder;
    }

    public static ThrowingProviderBinder create(Binder binder) {
        return new ThrowingProviderBinder(binder.skipSources(new Class[]{ThrowingProviderBinder.class, SecondaryBinder.class}));
    }

    public static Module forModule(Module module) {
        return CheckedProviderMethodsModule.forModule(module);
    }

    @Deprecated
    public <P extends CheckedProvider> SecondaryBinder<P, ?> bind(Class<P> interfaceType, Type clazz) {
        return new SecondaryBinder(interfaceType, clazz);
    }

    public <P extends CheckedProvider, T> SecondaryBinder<P, T> bind(Class<P> interfaceType, Class<T> clazz) {
        return new SecondaryBinder(interfaceType, clazz);
    }

    public <P extends CheckedProvider, T> SecondaryBinder<P, T> bind(Class<P> interfaceType, TypeLiteral<T> typeLiteral) {
        return new SecondaryBinder(interfaceType, typeLiteral.getType());
    }

    private static class ResultException
    extends RuntimeException {
        ResultException(Exception cause) {
            super(cause);
        }
    }

    static class Result
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Object value;
        private final Exception exception;

        private Result(Object value, Exception exception) {
            this.value = value;
            this.exception = exception;
        }

        public static Result forValue(Object value) {
            return new Result(value, null);
        }

        public static Result forException(Exception e) {
            return new Result(null, e);
        }

        public Object getOrThrow() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }

    public class SecondaryBinder<P extends CheckedProvider, T> {
        private final Class<P> interfaceType;
        private final Type valueType;
        private final List<Class<? extends Throwable>> exceptionTypes;
        private final boolean valid;
        private Class<? extends Annotation> annotationType;
        private Annotation annotation;
        private Key<P> interfaceKey;
        private boolean scopeExceptions = true;

        public SecondaryBinder(Class<P> interfaceType, Type valueType) {
            this.interfaceType = (Class)Preconditions.checkNotNull(interfaceType, (Object)"interfaceType");
            this.valueType = (Type)Preconditions.checkNotNull((Object)valueType, (Object)"valueType");
            if (this.checkInterface()) {
                this.exceptionTypes = this.getExceptionType(interfaceType);
                this.valid = true;
            } else {
                this.valid = false;
                this.exceptionTypes = ImmutableList.of();
            }
        }

        List<Class<? extends Throwable>> getExceptionTypes() {
            return this.exceptionTypes;
        }

        Key<P> getKey() {
            return this.interfaceKey;
        }

        public SecondaryBinder<P, T> annotatedWith(Class<? extends Annotation> annotationType) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException("Cannot set annotation twice");
            }
            this.annotationType = annotationType;
            return this;
        }

        public SecondaryBinder<P, T> annotatedWith(Annotation annotation) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException("Cannot set annotation twice");
            }
            this.annotation = annotation;
            return this;
        }

        public SecondaryBinder<P, T> scopeExceptions(boolean scopeExceptions) {
            this.scopeExceptions = scopeExceptions;
            return this;
        }

        public ScopedBindingBuilder to(P target) {
            Key targetKey = Key.get(this.interfaceType, (Annotation)UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.to(targetKey);
        }

        public ScopedBindingBuilder to(Class<? extends P> targetType) {
            return this.to(Key.get(targetType));
        }

        public ScopedBindingBuilder providing(Class<? extends T> cxtorClass) {
            return this.providing(TypeLiteral.get(cxtorClass));
        }

        public ScopedBindingBuilder providing(TypeLiteral<? extends T> cxtorLiteral) {
            Provider typeProvider;
            Key typeKey;
            Constructor<? extends T> cxtor = CheckedProvideUtils.findThrowingConstructor(cxtorLiteral, ThrowingProviderBinder.this.binder);
            if (cxtor != null) {
                CheckedProvideUtils.validateExceptions(ThrowingProviderBinder.this.binder, cxtorLiteral.getExceptionTypes(cxtor), this.exceptionTypes, this.interfaceType);
                typeKey = Key.get(cxtorLiteral, (Annotation)UniqueAnnotations.create());
                ThrowingProviderBinder.this.binder.bind(typeKey).toConstructor(cxtor).in(Scopes.NO_SCOPE);
                typeProvider = ThrowingProviderBinder.this.binder.getProvider(typeKey);
            } else {
                typeProvider = null;
                typeKey = null;
            }
            CheckedProviderWithDependencies checkedProvider = new CheckedProviderWithDependencies<T>(this){

                @Override
                public T get() throws Exception {
                    try {
                        return typeProvider.get();
                    }
                    catch (ProvisionException pe) {
                        if (pe.getCause() instanceof Exception) {
                            throw (Exception)pe.getCause();
                        }
                        if (pe.getCause() instanceof Error) {
                            throw (Error)pe.getCause();
                        }
                        throw pe;
                    }
                }

                public Set<Dependency<?>> getDependencies() {
                    return ImmutableSet.of((Object)Dependency.get((Key)typeKey));
                }
            };
            Key targetKey = Key.get((TypeLiteral)CHECKED_PROVIDER_TYPE, (Annotation)UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance((Object)checkedProvider);
            return this.toInternal(targetKey);
        }

        ScopedBindingBuilder toProviderMethod(CheckedProviderMethod<?> target) {
            Key targetKey = Key.get((TypeLiteral)CHECKED_PROVIDER_METHOD_TYPE, (Annotation)UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.toInternal(targetKey);
        }

        public ScopedBindingBuilder to(Key<? extends P> targetKey) {
            Preconditions.checkNotNull(targetKey, (Object)"targetKey");
            return this.toInternal(targetKey);
        }

        private ScopedBindingBuilder toInternal(Key<? extends CheckedProvider<?>> targetKey) {
            final Key resultKey = Key.get(Result.class, (Annotation)UniqueAnnotations.create());
            final Provider resultProvider = ThrowingProviderBinder.this.binder.getProvider(resultKey);
            Provider targetProvider = ThrowingProviderBinder.this.binder.getProvider(targetKey);
            this.interfaceKey = this.createKey();
            if (this.valid) {
                ThrowingProviderBinder.this.binder.bind(this.interfaceKey).toProvider((Provider)new ProviderWithDependencies<P>(){
                    private final P instance;
                    {
                        this.instance = (CheckedProvider)SecondaryBinder.this.interfaceType.cast(Proxy.newProxyInstance(SecondaryBinder.this.interfaceType.getClassLoader(), new Class[]{SecondaryBinder.this.interfaceType}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                Result result;
                                if (method.getDeclaringClass() == Object.class) {
                                    return method.invoke((Object)this, args);
                                }
                                if (SecondaryBinder.this.scopeExceptions) {
                                    return ((Result)resultProvider.get()).getOrThrow();
                                }
                                try {
                                    result = (Result)resultProvider.get();
                                }
                                catch (ProvisionException pe) {
                                    Throwable cause = pe.getCause();
                                    if (cause instanceof ResultException) {
                                        throw ((ResultException)cause).getCause();
                                    }
                                    throw pe;
                                }
                                return result.getOrThrow();
                            }
                        }));
                    }

                    public P get() {
                        return this.instance;
                    }

                    public Set<Dependency<?>> getDependencies() {
                        return ImmutableSet.of((Object)Dependency.get((Key)resultKey));
                    }
                });
            }
            return ThrowingProviderBinder.this.binder.bind(resultKey).toProvider(this.createResultProvider(targetKey, targetProvider));
        }

        private ProviderWithDependencies<Result> createResultProvider(final Key<? extends CheckedProvider<?>> targetKey, final Provider<? extends CheckedProvider<?>> targetProvider) {
            return new ProviderWithDependencies<Result>(){

                public Result get() {
                    try {
                        return Result.forValue(((CheckedProvider)targetProvider.get()).get());
                    }
                    catch (Exception e) {
                        for (Class exceptionType : SecondaryBinder.this.exceptionTypes) {
                            if (!exceptionType.isInstance(e)) continue;
                            if (SecondaryBinder.this.scopeExceptions) {
                                return Result.forException(e);
                            }
                            throw new ResultException(e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }

                public Set<Dependency<?>> getDependencies() {
                    return ImmutableSet.of((Object)Dependency.get((Key)targetKey));
                }
            };
        }

        private List<Class<? extends Throwable>> getExceptionType(Class<P> interfaceType) {
            try {
                Method getMethod = interfaceType.getMethod("get", new Class[0]);
                List exceptionLiterals = TypeLiteral.get(interfaceType).getExceptionTypes((Member)getMethod);
                ArrayList results = Lists.newArrayList();
                for (TypeLiteral exLiteral : exceptionLiterals) {
                    results.add(exLiteral.getRawType().asSubclass(Throwable.class));
                }
                return results;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Not allowed to inspect exception types", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No 'get'method available", e);
            }
        }

        private boolean checkInterface() {
            try {
                ProviderChecker.checkInterface(this.interfaceType, (Optional<? extends Type>)Optional.of((Object)this.valueType));
                return true;
            }
            catch (IllegalArgumentException e) {
                ThrowingProviderBinder.this.binder.addError(e.getMessage(), new Object[0]);
                return false;
            }
        }

        private Key<P> createKey() {
            TypeLiteral typeLiteral;
            if (this.interfaceType.getTypeParameters().length == 1) {
                ParameterizedType type = Types.newParameterizedTypeWithOwner(this.interfaceType.getEnclosingClass(), this.interfaceType, (Type[])new Type[]{this.valueType});
                typeLiteral = TypeLiteral.get((Type)type);
            } else {
                typeLiteral = TypeLiteral.get(this.interfaceType);
            }
            if (this.annotation != null) {
                return Key.get((TypeLiteral)typeLiteral, (Annotation)this.annotation);
            }
            if (this.annotationType != null) {
                return Key.get((TypeLiteral)typeLiteral, this.annotationType);
            }
            return Key.get((TypeLiteral)typeLiteral);
        }
    }
}

