/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.ModifierOrderer;
import com.google.googlejavaformat.java.Replacement;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.DiagnosticCollector;
import org.openjdk.javax.tools.DiagnosticListener;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.SimpleJavaFileObject;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.source.tree.Tree;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.parser.JavacParser;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Options;

@Immutable
public final class Formatter {
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    static final Predicate<Diagnostic<?>> ERROR_DIAGNOSTIC = new Predicate<Diagnostic<?>>(){

        public boolean apply(Diagnostic<?> input) {
            if (input.getKind() != Diagnostic.Kind.ERROR) {
                return false;
            }
            switch (input.getCode()) {
                case "compiler.err.invalid.meth.decl.ret.type.req": {
                    return false;
                }
            }
            return true;
        }
    };
    private final JavaFormatterOptions options;

    public Formatter() {
        this(JavaFormatterOptions.defaultOptions());
    }

    public Formatter(JavaFormatterOptions options) {
        this.options = options;
    }

    static void format(final JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options) {
        Context context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, (Object)diagnostics);
        Options.instance((Context)context).put("allowStringFolding", "false");
        Options.instance((Context)context).put(Option.SOURCE, "9");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation((JavaFileManager.Location)StandardLocation.PLATFORM_CLASS_PATH, (Iterable)ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput.getText();
            }
        };
        Log.instance((Context)context).useSource((JavaFileObject)source);
        ParserFactory parserFactory = ParserFactory.instance((Context)context);
        JavacParser parser = parserFactory.newParser((CharSequence)javaInput.getText(), true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        javaInput.setCompilationUnit(unit);
        Iterable errorDiagnostics = Iterables.filter((Iterable)diagnostics.getDiagnostics(), ERROR_DIAGNOSTIC);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            throw FormattingError.fromJavacDiagnostics(errorDiagnostics);
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput);
        new JavaInputAstVisitor(builder, options.indentationMultiplier()).scan((Tree)unit, null);
        builder.sync(javaInput.getText().length());
        builder.drain();
        Doc doc = new DocBuilder().withOps((List<Op>)builder.build()).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.maxLineLength(), new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write((CharSequence)this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        return this.formatSource(input, Collections.singleton(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(input.length()))));
    }

    public String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        return JavaOutput.applyReplacements(input, this.getFormatReplacements(input, characterRanges));
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput(input);
        javaInput = ModifierOrderer.reorderModifiers(javaInput, characterRanges);
        String lineSeparator = Newlines.guessLineSeparator(input);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, javaInput, new JavaCommentsHelper(lineSeparator, this.options));
        try {
            Formatter.format(javaInput, javaOutput, this.options);
        }
        catch (FormattingError e) {
            throw new FormatterException((Iterable<FormatterDiagnostic>)e.diagnostics());
        }
        RangeSet<Integer> tokenRangeSet = javaInput.characterRangesToTokenRanges(characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }

    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, Newlines.lineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet characterRanges = TreeRangeSet.create();
        for (Range lineRange : lineRanges.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lines.size() - 1))).asRanges()) {
            int lineStart = (Integer)lines.get((Integer)lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get((Integer)lineRange.upperEndpoint()) - 1;
            Range range = Range.closedOpen((Comparable)Integer.valueOf(lineStart), (Comparable)Integer.valueOf(lineEnd));
            characterRanges.add(range);
        }
        return characterRanges;
    }
}

