/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JavaCommentsHelper
implements CommentsHelper {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private final JavaFormatterOptions options;

    public JavaCommentsHelper(JavaFormatterOptions options) {
        this.options = options;
    }

    @Override
    public String rewrite(Input.Tok tok, int maxWidth, int column0) {
        if (!tok.isComment()) {
            return tok.getOriginalText();
        }
        String text = tok.getOriginalText();
        if (tok.isJavadocComment()) {
            text = this.options.javadocFormatter().format(this.options, text, column0);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : NEWLINE_SPLITTER.split((CharSequence)text)) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom((CharSequence)line));
        }
        if (lines.size() == 1) {
            return tok.getOriginalText().trim();
        }
        if (tok.isSlashSlashComment()) {
            return JavaCommentsHelper.indentLineComments(lines, column0);
        }
        if (JavaCommentsHelper.javadocShaped(lines)) {
            return JavaCommentsHelper.indentJavadoc(lines, column0);
        }
        return JavaCommentsHelper.preserveIndentation(lines, column0);
    }

    private static String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder = new StringBuilder();
        int startCol = -1;
        for (i = 1; i < lines.size(); ++i) {
            int lineIdx = CharMatcher.whitespace().negate().indexIn((CharSequence)lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder.append(lines.get(0));
        for (i = 1; i < lines.size(); ++i) {
            builder.append("\n").append(Strings.repeat((String)" ", (int)column0));
            if (lines.get(i).length() >= startCol) {
                builder.append(lines.get(i).substring(startCol));
                continue;
            }
            builder.append(lines.get(i));
        }
        return builder.toString();
    }

    private static String indentLineComments(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        builder.append(lines.get(0).trim());
        String indentString = Strings.repeat((String)" ", (int)column0);
        for (int i = 1; i < lines.size(); ++i) {
            builder.append("\n").append(indentString).append(lines.get(i).trim());
        }
        return builder.toString();
    }

    private static String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        builder.append(lines.get(0).trim());
        int indent = column0 + 1;
        String indentString = Strings.repeat((String)" ", (int)indent);
        for (int i = 1; i < lines.size(); ++i) {
            builder.append("\n").append(indentString);
            String line = lines.get(i).trim();
            if (!line.startsWith("*")) {
                builder.append("* ");
            }
            builder.append(line);
        }
        return builder.toString();
    }

    private static boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = it.next().trim();
        if (first.startsWith("/**")) {
            return true;
        }
        if (!first.startsWith("/*")) {
            return false;
        }
        while (it.hasNext()) {
            if (it.next().trim().startsWith("*")) continue;
            return false;
        }
        return true;
    }
}

