/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.Preconditions;

public class FormatterDiagnostic {
    private final String filename;
    private final int lineNumber;
    private final String message;
    private final int column;

    public FormatterDiagnostic(String filename, int lineNumber, int column, String message) {
        Preconditions.checkArgument((lineNumber >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)filename);
        Preconditions.checkNotNull((Object)message);
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.column = column;
        this.message = message;
    }

    public String filename() {
        return this.filename;
    }

    public int line() {
        return this.lineNumber;
    }

    public int column() {
        return this.column;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.filename).append(':');
        sb.append(this.lineNumber).append(':');
        sb.append(this.column + 1).append(':');
        sb.append(' ');
        sb.append("error: ").append(this.message);
        return sb.toString();
    }
}

