/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class FirebaseToken {
    private final Map<String, Object> claims;

    FirebaseToken(Map<String, Object> claims) {
        Preconditions.checkArgument((claims != null && claims.containsKey("sub") ? 1 : 0) != 0, (Object)"Claims map must at least contain sub");
        this.claims = ImmutableMap.copyOf(claims);
    }

    public String getUid() {
        return (String)this.claims.get("sub");
    }

    public String getIssuer() {
        return (String)this.claims.get("iss");
    }

    public String getName() {
        return (String)this.claims.get("name");
    }

    public String getPicture() {
        return (String)this.claims.get("picture");
    }

    public String getEmail() {
        return (String)this.claims.get("email");
    }

    public boolean isEmailVerified() {
        Object emailVerified = this.claims.get("email_verified");
        return emailVerified != null && (Boolean)emailVerified != false;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }
}

