/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class Iterators {
    private static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    };

    public static <I, O> Iterator<O> createCompoundIterator(Iterable<I> iterable, Function<I, Iterator<O>> function) {
        return new CompoundIterator<I, O>(iterable, function);
    }

    private static class CompoundIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> inputs;
        private final Function<I, Iterator<O>> convertor;
        private Iterator<O> currentIterator = Iterators.access$000();

        public CompoundIterator(Iterable<I> iterable, Function<I, Iterator<O>> function) {
            this.inputs = iterable.iterator();
            this.convertor = function;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator != null && !this.currentIterator.hasNext()) {
                this.update();
            }
            return this.currentIterator != null;
        }

        @Override
        public O next() {
            if (this.currentIterator == EMPTY && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void update() {
            while (this.inputs.hasNext()) {
                this.currentIterator = this.convertor.apply(this.inputs.next());
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
            this.currentIterator = null;
        }
    }
}

