/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.DaggerCollections;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import dagger.producers.internal.SetProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public final class SetOfProducedProducer<T>
extends AbstractProducer<Set<Produced<T>>> {
    private final List<Producer<T>> individualProducers;
    private final List<Producer<Collection<T>>> collectionProducers;

    public static <T> Producer<Set<T>> empty() {
        return SetProducer.empty();
    }

    public static <T> Builder<T> builder(int individualProducerSize, int collectionProducerSize) {
        return new Builder(individualProducerSize, collectionProducerSize);
    }

    private SetOfProducedProducer(List<Producer<T>> individualProducers, List<Producer<Collection<T>>> collectionProducers) {
        this.individualProducers = individualProducers;
        this.collectionProducers = collectionProducers;
    }

    @Override
    public ListenableFuture<Set<Produced<T>>> compute() {
        ArrayList<Object> futureProducedCollections = new ArrayList<Object>(this.individualProducers.size() + this.collectionProducers.size());
        for (Producer<T> producer : this.individualProducers) {
            futureProducedCollections.add(Producers.createFutureProduced(Producers.createFutureSingletonSet((ListenableFuture)Preconditions.checkNotNull(producer.get()))));
        }
        for (Producer<Object> producer : this.collectionProducers) {
            futureProducedCollections.add(Producers.createFutureProduced((ListenableFuture)Preconditions.checkNotNull(producer.get())));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futureProducedCollections), (Function)new Function<List<Produced<? extends Collection<T>>>, Set<Produced<T>>>(){

            public Set<Produced<T>> apply(List<Produced<? extends Collection<T>>> producedCollections) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Produced producedCollection : producedCollections) {
                    try {
                        Collection collection = producedCollection.get();
                        if (collection == null) {
                            builder.add(Produced.failed(new NullPointerException("Cannot contribute a null collection into a producer set binding when it's injected as Set<Produced<T>>.")));
                            continue;
                        }
                        for (Object value : collection) {
                            if (value == null) {
                                builder.add(Produced.failed(new NullPointerException("Cannot contribute a null element into a producer set binding when it's injected as Set<Produced<T>>.")));
                                continue;
                            }
                            builder.add(Produced.successful(value));
                        }
                    }
                    catch (ExecutionException e) {
                        builder.add(Produced.failed(e.getCause()));
                    }
                }
                return builder.build();
            }
        });
    }

    public static final class Builder<T> {
        private final List<Producer<T>> individualProducers;
        private final List<Producer<Collection<T>>> collectionProducers;

        private Builder(int individualProducerSize, int collectionProducerSize) {
            this.individualProducers = DaggerCollections.presizedList((int)individualProducerSize);
            this.collectionProducers = DaggerCollections.presizedList((int)collectionProducerSize);
        }

        public Builder<T> addProducer(Producer<? extends T> individualProducer) {
            assert (individualProducer != null) : "Codegen error? Null producer";
            this.individualProducers.add(individualProducer);
            return this;
        }

        public Builder<T> addCollectionProducer(Producer<? extends Collection<? extends T>> multipleProducer) {
            assert (multipleProducer != null) : "Codegen error? Null producer";
            this.collectionProducers.add(multipleProducer);
            return this;
        }

        public SetOfProducedProducer<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProducers)) : "Codegen error?  Duplicates in the producer list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProducers)) : "Codegen error?  Duplicates in the producer list";
            return new SetOfProducedProducer(this.individualProducers, this.collectionProducers);
        }
    }
}

