/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

public abstract class ProducerMonitor {
    private static final ProducerMonitor NO_OP = new ProducerMonitor(){

        @Override
        public <T> void addCallbackTo(ListenableFuture<T> future) {
        }
    };

    public void requested() {
    }

    public void ready() {
    }

    public void methodStarting() {
    }

    public void methodFinished() {
    }

    public void succeeded(Object value) {
    }

    public void failed(Throwable t) {
    }

    public <T> void addCallbackTo(ListenableFuture<T> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T value) {
                ProducerMonitor.this.succeeded(value);
            }

            public void onFailure(Throwable t) {
                ProducerMonitor.this.failed(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static ProducerMonitor noOp() {
        return NO_OP;
    }
}

