/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentMonitor;
import dagger.producers.monitoring.internal.Monitors;
import javax.inject.Provider;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AbstractProducer<T>
implements Producer<T> {
    private final Provider<ProductionComponentMonitor> monitorProvider;
    @NullableDecl
    private final ProducerToken token;
    private volatile ListenableFuture<T> instance = null;
    protected volatile ProducerMonitor monitor = null;

    protected AbstractProducer() {
        this(Monitors.noOpProductionComponentMonitorProvider(), null);
    }

    protected AbstractProducer(Provider<ProductionComponentMonitor> monitorProvider, @NullableDecl ProducerToken token) {
        this.monitorProvider = (Provider)Preconditions.checkNotNull(monitorProvider);
        this.token = token;
    }

    protected abstract ListenableFuture<T> compute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListenableFuture<T> get() {
        ListenableFuture<T> result = this.instance;
        if (result == null) {
            AbstractProducer abstractProducer = this;
            synchronized (abstractProducer) {
                result = this.instance;
                if (result == null) {
                    this.monitor = ((ProductionComponentMonitor)this.monitorProvider.get()).producerMonitorFor(this.token);
                    this.monitor.requested();
                    this.instance = result = this.compute();
                    if (result == null) {
                        throw new NullPointerException("compute returned null");
                    }
                    this.monitor.addCallbackTo(result);
                }
            }
        }
        return result;
    }
}

