/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Reusable;
import dagger.internal.codegen.AutoValue_Scope;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.producers.ProductionScope;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

abstract class Scope {
    Scope() {
    }

    abstract Equivalence.Wrapper<AnnotationMirror> scopeAnnotation();

    static Scope scope(AnnotationMirror scopeAnnotation) {
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(scopeAnnotation.getAnnotationType().asElement(), javax.inject.Scope.class));
        return new AutoValue_Scope((Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap((Object)scopeAnnotation));
    }

    static Scope scope(TypeElement scopeType) {
        return Scope.scope(SimpleAnnotationMirror.of(scopeType));
    }

    private static Scope scope(Elements elements, Class<? extends Annotation> scopeAnnotationClass) {
        return Scope.scope(elements.getTypeElement(scopeAnnotationClass.getCanonicalName()));
    }

    static ImmutableSet<Scope> scopesOf(Element element) {
        return FluentIterable.from(InjectionAnnotations.getScopes(element)).transform((Function)new Function<AnnotationMirror, Scope>(){

            public Scope apply(AnnotationMirror annotationMirror) {
                return Scope.scope(annotationMirror);
            }
        }).toSet();
    }

    static Optional<Scope> uniqueScopeOf(Element element) {
        ImmutableSet<? extends AnnotationMirror> scopeAnnotations = InjectionAnnotations.getScopes(element);
        if (scopeAnnotations.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)Scope.scope((AnnotationMirror)Iterables.getOnlyElement(scopeAnnotations)));
    }

    static Scope productionScope(Elements elements) {
        return Scope.scope(elements, ProductionScope.class);
    }

    static Scope singletonScope(Elements elements) {
        return Scope.scope(elements, Singleton.class);
    }

    static Scope reusableScope(Elements elements) {
        return Scope.scope(elements, Reusable.class);
    }

    public String getReadableSource() {
        return ErrorMessages.stripCommonTypePrefixes("@" + this.getQualifiedName());
    }

    public String getQualifiedName() {
        return this.scopeAnnotationElement().getQualifiedName().toString();
    }

    public TypeElement scopeAnnotationElement() {
        return MoreTypes.asTypeElement(((AnnotationMirror)this.scopeAnnotation().get()).getAnnotationType());
    }

    public String toString() {
        return ((AnnotationMirror)this.scopeAnnotation().get()).toString();
    }
}

