/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.Futures;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.TypeNames;
import dagger.producers.internal.Producers;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class OptionalFactories {
    private static final FieldSpec ABSENT_OPTIONAL_PROVIDER_FIELD = FieldSpec.builder(TypeNames.PROVIDER, "ABSENT_OPTIONAL_PROVIDER", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_RAWTYPES).initializer("$T.create($T.absent())", InstanceFactory.class, Optional.class).addJavadoc("A {@link $T} that returns {@code $T.absent()}.", Provider.class, Optional.class).build();
    private static final MethodSpec ABSENT_OPTIONAL_PROVIDER_METHOD = MethodSpec.methodBuilder("absentOptionalProvider").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addTypeVariable(TypeVariableName.get("T")).returns(TypeNames.providerOf(TypeNames.optionalOf(TypeVariableName.get("T")))).addJavadoc("Returns a {@link $T} that returns {@code $T.absent()}.", Provider.class, Optional.class).addCode("$L // safe covariant cast\n", AnnotationSpecs.SUPPRESS_WARNINGS_UNCHECKED).addCode("$1T provider = ($1T) $2N;", TypeNames.providerOf(TypeNames.optionalOf(TypeVariableName.get("T"))), ABSENT_OPTIONAL_PROVIDER_FIELD).addCode("return provider;", new Object[0]).build();
    private final Table<BindingType, DependencyRequest.Kind, TypeSpec> presentFactoryClasses = HashBasedTable.create();
    private Optional<CodeBlock> absentOptionalProviderMethod = Optional.absent();

    OptionalFactories() {
    }

    CodeBlock absentOptionalProvider() {
        if (!this.absentOptionalProviderMethod.isPresent()) {
            this.absentOptionalProviderMethod = Optional.of((Object)CodeBlock.of("$N()", ABSENT_OPTIONAL_PROVIDER_METHOD));
        }
        return (CodeBlock)this.absentOptionalProviderMethod.get();
    }

    CodeBlock presentOptionalFactory(ContributionBinding binding, CodeBlock delegateFactory) {
        TypeMirror valueType = OptionalType.from(binding.key()).valueType();
        DependencyRequest.Kind valueKind = DependencyRequest.extractKindAndType(valueType).kind();
        if (!this.presentFactoryClasses.contains((Object)binding.bindingType(), (Object)valueKind)) {
            this.presentFactoryClasses.put((Object)binding.bindingType(), (Object)valueKind, (Object)this.createPresentFactoryClass(binding.bindingType(), valueKind));
        }
        return CodeBlock.of("$N.of($L)", this.presentFactoryClasses.get((Object)binding.bindingType(), (Object)valueKind), delegateFactory);
    }

    void addMembers(TypeSpec.Builder component) {
        if (this.absentOptionalProviderMethod.isPresent()) {
            component.addField(ABSENT_OPTIONAL_PROVIDER_FIELD).addMethod(ABSENT_OPTIONAL_PROVIDER_METHOD);
        }
        for (TypeSpec presentFactoryClass : this.presentFactoryClasses.values()) {
            component.addType(presentFactoryClass);
        }
    }

    private TypeSpec createPresentFactoryClass(BindingType bindingType, DependencyRequest.Kind valueKind) {
        TypeVariableName typeVariable = TypeVariableName.get("T");
        TypeName valueType = valueKind.typeName(typeVariable);
        ParameterizedTypeName factoryType = bindingType.frameworkClassOf(TypeNames.optionalOf(valueType));
        FieldSpec delegateField = FieldSpec.builder(bindingType.frameworkClassOf(typeVariable), "delegate", Modifier.PRIVATE, Modifier.FINAL).build();
        ParameterSpec delegateParameter = ParameterSpec.builder(delegateField.type, "delegate", new Modifier[0]).build();
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder("get").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC);
        block0 : switch (bindingType) {
            case PROVISION: {
                getMethodBuilder.returns(TypeNames.optionalOf(valueType)).addCode("return $T.of($L);", Optional.class, FrameworkType.PROVIDER.to(valueKind, CodeBlock.of("$N", delegateField)));
                break;
            }
            case PRODUCTION: {
                getMethodBuilder.returns(TypeNames.listenableFutureOf(TypeNames.optionalOf(valueType)));
                switch (valueKind) {
                    case FUTURE: 
                    case PRODUCER: {
                        getMethodBuilder.addCode("return $T.immediateFuture($T.of($L));", Futures.class, Optional.class, FrameworkType.PRODUCER.to(valueKind, CodeBlock.of("$N", delegateField)));
                        break block0;
                    }
                    case INSTANCE: {
                        getMethodBuilder.addCode("return $L;", OptionalFactories.transformFutureToOptional(typeVariable, CodeBlock.of("$N.get()", delegateField)));
                        break block0;
                    }
                    case PRODUCED: {
                        getMethodBuilder.addCode("return $L;", OptionalFactories.transformFutureToOptional(valueType, CodeBlock.of("$T.createFutureProduced($N.get())", Producers.class, delegateField)));
                        break block0;
                    }
                }
                throw new UnsupportedOperationException(factoryType + " objects are not supported");
            }
            default: {
                throw new AssertionError((Object)bindingType);
            }
        }
        MethodSpec getMethod = getMethodBuilder.build();
        String factoryClassName = String.format("PresentOptional%s%s", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, valueKind.toString()), bindingType.frameworkClass().getSimpleName());
        return TypeSpec.classBuilder(factoryClassName).addTypeVariable(typeVariable).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(factoryType).addJavadoc("A {@link $T} that uses a delegate {@code $T}.", factoryType, delegateField.type).addField(delegateField).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(delegateParameter).addCode("this.$N = $T.checkNotNull($N);", delegateField, Preconditions.class, delegateParameter).build()).addMethod(getMethod).addMethod(MethodSpec.methodBuilder("of").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addTypeVariable(typeVariable).returns(factoryType).addParameter(delegateParameter).addCode("return new $L<$T>($N);", factoryClassName, typeVariable, delegateParameter).build()).build();
    }

    private static CodeBlock transformFutureToOptional(TypeName inputType, CodeBlock inputFuture) {
        return CodeBlock.of("$T.transform($L, $L)", Futures.class, inputFuture, TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(ParameterizedTypeName.get(ClassName.get(Function.class), inputType, TypeNames.optionalOf(inputType))).addMethod(MethodSpec.methodBuilder("apply").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(TypeNames.optionalOf(inputType)).addParameter(inputType, "input", new Modifier[0]).addCode("return $T.of(input);", Optional.class).build()).build());
    }
}

