/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Multibindings;
import dagger.internal.codegen.AutoValue_MultibindingDeclaration;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.SetType;
import dagger.multibindings.Multibinds;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class MultibindingDeclaration
extends BindingDeclaration
implements BindingType.HasBindingType,
ContributionType.HasContributionType {
    MultibindingDeclaration() {
    }

    @Override
    public abstract Key key();

    @Override
    public abstract ContributionType contributionType();

    @Override
    public abstract BindingType bindingType();

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final Key.Factory keyFactory;
        private final TypeElement objectElement;

        Factory(Elements elements, Types types, Key.Factory keyFactory) {
            this.elements = elements;
            this.types = types;
            this.keyFactory = keyFactory;
            this.objectElement = elements.getTypeElement(Object.class.getCanonicalName());
        }

        ImmutableSet<MultibindingDeclaration> forMultibindingsInterface(TypeElement interfaceElement) {
            Preconditions.checkArgument((boolean)interfaceElement.getKind().equals((Object)ElementKind.INTERFACE));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(interfaceElement, Multibindings.class));
            BindingType bindingType = this.bindingType(interfaceElement.getEnclosingElement());
            DeclaredType interfaceType = MoreTypes.asDeclared(interfaceElement.asType());
            ImmutableSet.Builder declarations = ImmutableSet.builder();
            for (ExecutableElement method : MoreElements.getLocalAndInheritedMethods(interfaceElement, this.elements)) {
                if (method.getEnclosingElement().equals(this.objectElement)) continue;
                ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(interfaceType, method));
                declarations.add((Object)this.forDeclaredMethod(bindingType, method, methodType, interfaceElement));
            }
            return declarations.build();
        }

        MultibindingDeclaration forMultibindsMethod(ExecutableElement moduleMethod, TypeElement moduleElement) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class));
            return this.forDeclaredMethod(this.bindingType(moduleElement), moduleMethod, MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(moduleElement.asType()), moduleMethod)), moduleElement);
        }

        private BindingType bindingType(Element moduleElement) {
            if (MoreElements.isAnnotationPresent(moduleElement, Module.class)) {
                return BindingType.PROVISION;
            }
            if (MoreElements.isAnnotationPresent(moduleElement, ProducerModule.class)) {
                return BindingType.PRODUCTION;
            }
            throw new IllegalArgumentException("Expected " + moduleElement + " to be a @Module or @ProducerModule");
        }

        private MultibindingDeclaration forDeclaredMethod(BindingType bindingType, ExecutableElement method, ExecutableType methodType, TypeElement contributingType) {
            TypeMirror returnType = methodType.getReturnType();
            Preconditions.checkArgument((SetType.isSet(returnType) || MapType.isMap(returnType) ? 1 : 0) != 0, (String)"%s must return a set or map", (Object[])new Object[]{method});
            return new AutoValue_MultibindingDeclaration((Optional<Element>)Optional.of((Object)method), (Optional<TypeElement>)Optional.of((Object)contributingType), this.keyFactory.forMultibindsMethod(bindingType, methodType, method), this.contributionType(returnType), bindingType);
        }

        private ContributionType contributionType(TypeMirror returnType) {
            if (MapType.isMap(returnType)) {
                return ContributionType.MAP;
            }
            if (SetType.isSet(returnType)) {
                return ContributionType.SET;
            }
            throw new IllegalArgumentException("Must be Map or Set: " + returnType);
        }
    }
}

