/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.Module;
import dagger.Multibindings;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_ModuleDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.multibindings.Multibinds;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class ModuleDescriptor {
    ModuleDescriptor() {
    }

    static final Function<ModuleDescriptor, TypeElement> getModuleElement() {
        return new Function<ModuleDescriptor, TypeElement>(){

            public TypeElement apply(ModuleDescriptor input) {
                return input.moduleElement();
            }
        };
    }

    abstract TypeElement moduleElement();

    abstract ImmutableSet<ModuleDescriptor> includedModules();

    abstract ImmutableSet<ContributionBinding> bindings();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<DelegateDeclaration> delegateDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalDeclarations();

    static final class Factory {
        private final Elements elements;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;
        private final MultibindingDeclaration.Factory multibindingDeclarationFactory;
        private final DelegateDeclaration.Factory bindingDelegateDeclarationFactory;
        private final SubcomponentDeclaration.Factory subcomponentDeclarationFactory;
        private final OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory;

        Factory(Elements elements, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory, MultibindingDeclaration.Factory multibindingDeclarationFactory, DelegateDeclaration.Factory bindingDelegateDeclarationFactory, SubcomponentDeclaration.Factory subcomponentDeclarationFactory, OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory) {
            this.elements = elements;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
            this.multibindingDeclarationFactory = multibindingDeclarationFactory;
            this.bindingDelegateDeclarationFactory = bindingDelegateDeclarationFactory;
            this.subcomponentDeclarationFactory = subcomponentDeclarationFactory;
            this.optionalBindingDeclarationFactory = optionalBindingDeclarationFactory;
        }

        ModuleDescriptor create(TypeElement moduleElement) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder optionalDeclarations = ImmutableSet.builder();
            for (ExecutableElement moduleMethod : ElementFilter.methodsIn(this.elements.getAllMembers(moduleElement))) {
                if (MoreElements.isAnnotationPresent(moduleMethod, Provides.class)) {
                    bindings.add((Object)this.provisionBindingFactory.forProvidesMethod(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Produces.class)) {
                    bindings.add((Object)this.productionBindingFactory.forProducesMethod(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Binds.class)) {
                    delegates.add((Object)this.bindingDelegateDeclarationFactory.create(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class)) {
                    multibindingDeclarations.add((Object)this.multibindingDeclarationFactory.forMultibindsMethod(moduleMethod, moduleElement));
                }
                if (!MoreElements.isAnnotationPresent(moduleMethod, BindsOptionalOf.class)) continue;
                optionalDeclarations.add((Object)this.optionalBindingDeclarationFactory.forMethod(moduleMethod, moduleElement));
            }
            for (TypeElement memberType : ElementFilter.typesIn(this.elements.getAllMembers(moduleElement))) {
                if (!MoreElements.isAnnotationPresent(memberType, Multibindings.class)) continue;
                multibindingDeclarations.addAll(this.multibindingDeclarationFactory.forMultibindingsInterface(memberType));
            }
            return new AutoValue_ModuleDescriptor(moduleElement, (ImmutableSet<ModuleDescriptor>)ImmutableSet.copyOf(this.collectIncludedModules(new LinkedHashSet<ModuleDescriptor>(), moduleElement)), (ImmutableSet<ContributionBinding>)bindings.build(), (ImmutableSet<MultibindingDeclaration>)multibindingDeclarations.build(), this.subcomponentDeclarationFactory.forModule(moduleElement), (ImmutableSet<DelegateDeclaration>)delegates.build(), (ImmutableSet<OptionalBindingDeclaration>)optionalDeclarations.build());
        }

        @CanIgnoreReturnValue
        private Set<ModuleDescriptor> collectIncludedModules(Set<ModuleDescriptor> includedModules, TypeElement moduleElement) {
            Optional<AnnotationMirror> moduleAnnotation;
            TypeMirror superclass = moduleElement.getSuperclass();
            if (!superclass.getKind().equals((Object)TypeKind.NONE)) {
                Verify.verify((boolean)superclass.getKind().equals((Object)TypeKind.DECLARED));
                TypeElement superclassElement = MoreTypes.asTypeElement(superclass);
                if (!superclassElement.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                    this.collectIncludedModules(includedModules, superclassElement);
                }
            }
            if ((moduleAnnotation = ConfigurationAnnotations.getModuleAnnotation(moduleElement)).isPresent()) {
                for (TypeMirror moduleIncludesType : ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)moduleAnnotation.get())) {
                    includedModules.add(this.create(MoreTypes.asTypeElement(moduleIncludesType)));
                }
            }
            return includedModules;
        }
    }

    static enum Kind {
        MODULE(Module.class, Provides.class, (ImmutableSet<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class)),
        PRODUCER_MODULE(ProducerModule.class, Produces.class, (ImmutableSet<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class));

        private final Class<? extends Annotation> moduleAnnotation;
        private final Class<? extends Annotation> methodAnnotation;
        private final ImmutableSet<? extends Class<? extends Annotation>> includesTypes;

        static Optional<Kind> forAnnotatedElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.moduleAnnotation())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object[])new Object[]{element, kinds});
            return Optional.fromNullable((Object)Iterables.getOnlyElement(kinds, null));
        }

        private Kind(Class<? extends Annotation> moduleAnnotation, Class<? extends Annotation> methodAnnotation, ImmutableSet<? extends Class<? extends Annotation>> includesTypes) {
            this.moduleAnnotation = moduleAnnotation;
            this.methodAnnotation = methodAnnotation;
            this.includesTypes = includesTypes;
        }

        Optional<AnnotationMirror> getModuleAnnotationMirror(TypeElement element) {
            return MoreElements.getAnnotationMirror(element, this.moduleAnnotation);
        }

        Class<? extends Annotation> moduleAnnotation() {
            return this.moduleAnnotation;
        }

        Class<? extends Annotation> methodAnnotation() {
            return this.methodAnnotation;
        }

        ImmutableSet<? extends Class<? extends Annotation>> includesTypes() {
            return this.includesTypes;
        }
    }
}

