/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor7;

final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final InjectValidator injectValidator;
    private static final TypeVisitor<Boolean, MembersInjectionBinding> VISIBLE_TO_MEMBERS_INJECTOR = new SimpleTypeVisitor7<Boolean, MembersInjectionBinding>(Boolean.valueOf(true)){

        @Override
        public Boolean visitArray(ArrayType t, MembersInjectionBinding p) {
            return (Boolean)this.visit(t.getComponentType(), p);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, MembersInjectionBinding p) {
            return MembersInjectorGenerator.visibleToMembersInjector(p, t.asElement());
        }
    };

    MembersInjectorGenerator(Filer filer, Elements elements, InjectValidator injectValidator) {
        super(filer, elements);
        this.injectValidator = injectValidator;
    }

    @Override
    ClassName nameGeneratedType(MembersInjectionBinding binding) {
        return SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(MembersInjectionBinding binding) {
        return Optional.of((Object)binding.membersInjectedType());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, MembersInjectionBinding binding) {
        if (binding.injectionSites().isEmpty()) {
            return Optional.absent();
        }
        if (!this.injectValidator.isValidType(binding.key().type())) {
            return Optional.absent();
        }
        Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        TypeSpec.Builder injectorTypeBuilder = TypeSpec.classBuilder(generatedTypeName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariables((Iterable<TypeVariableName>)typeParameters);
        TypeName injectedTypeName = TypeName.get(binding.key().type());
        ParameterizedTypeName implementedType = TypeNames.membersInjectorOf(injectedTypeName);
        injectorTypeBuilder.addSuperinterface(implementedType);
        MethodSpec.Builder injectMembersBuilder = MethodSpec.methodBuilder("injectMembers").returns(TypeName.VOID).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter(injectedTypeName, "instance", new Modifier[0]).addCode("if (instance == null) {", new Object[0]).addStatement("throw new $T($S)", NullPointerException.class, "Cannot inject members into a null reference").addCode("}", new Object[0]);
        ImmutableMap<BindingKey, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(binding);
        ImmutableMap.Builder dependencyFieldsBuilder = ImmutableMap.builder();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC);
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder("create").returns(implementedType).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariables((Iterable<TypeVariableName>)typeParameters);
        createMethodBuilder.addCode("return new $T(", SourceFiles.parameterizedGeneratedTypeNameForBinding(binding));
        ImmutableList.Builder constructorInvocationParameters = ImmutableList.builder();
        boolean usesRawFrameworkTypes = false;
        UniqueNameSet fieldNames = new UniqueNameSet();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            BindingKey bindingKey = (BindingKey)fieldEntry.getKey();
            FrameworkField bindingField = (FrameworkField)fieldEntry.getValue();
            boolean useRawFrameworkType = VISIBLE_TO_MEMBERS_INJECTOR.visit(bindingKey.key().type(), binding) == false;
            String fieldName = fieldNames.getUniqueName(bindingField.name());
            TypeName fieldType = useRawFrameworkType ? bindingField.type().rawType : bindingField.type();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(fieldType, fieldName, Modifier.PRIVATE, Modifier.FINAL);
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder(fieldType, fieldName, new Modifier[0]);
            if (useRawFrameworkType) {
                usesRawFrameworkTypes = true;
                fieldBuilder.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_RAWTYPES);
                parameterBuilder.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_RAWTYPES);
            }
            constructorBuilder.addParameter(parameterBuilder.build());
            createMethodBuilder.addParameter(parameterBuilder.build());
            FieldSpec field = fieldBuilder.build();
            injectorTypeBuilder.addField(field);
            constructorBuilder.addStatement("assert $N != null", field);
            constructorBuilder.addStatement("this.$N = $N", field, field);
            dependencyFieldsBuilder.put((Object)bindingKey, (Object)field);
            constructorInvocationParameters.add((Object)CodeBlock.of("$N", field));
        }
        createMethodBuilder.addCode(CodeBlocks.join((Iterable<CodeBlock>)constructorInvocationParameters.build(), ", "));
        createMethodBuilder.addCode(");", new Object[0]);
        injectorTypeBuilder.addMethod(constructorBuilder.build());
        injectorTypeBuilder.addMethod(createMethodBuilder.build());
        HashSet<String> delegateMethods = new HashSet<String>();
        ImmutableMap dependencyFields = dependencyFieldsBuilder.build();
        ArrayList<MethodSpec> injectMethodsForSubclasses = new ArrayList<MethodSpec>();
        for (MembersInjectionBinding.InjectionSite injectionSite : binding.injectionSites()) {
            injectMembersBuilder.addCode(MembersInjectorGenerator.visibleToMembersInjector(binding, injectionSite.element()) ? this.directInjectMemberCodeBlock(binding, (ImmutableMap<BindingKey, FieldSpec>)dependencyFields, injectionSite) : this.delegateInjectMemberCodeBlock((ImmutableMap<BindingKey, FieldSpec>)dependencyFields, injectionSite));
            if (injectionSite.element().getModifiers().contains((Object)Modifier.PUBLIC) || !injectionSite.element().getEnclosingElement().equals(binding.membersInjectedType()) || !delegateMethods.add(this.injectionSiteDelegateMethodName(injectionSite.element()))) continue;
            injectMethodsForSubclasses.add(this.injectorMethodForSubclasses((ImmutableMap<BindingKey, FieldSpec>)dependencyFields, (List<TypeVariableName>)typeParameters, injectedTypeName, injectionSite.element(), injectionSite.dependencies()));
        }
        if (usesRawFrameworkTypes) {
            injectMembersBuilder.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_UNCHECKED);
        }
        injectorTypeBuilder.addMethod(injectMembersBuilder.build());
        for (MethodSpec methodSpec : injectMethodsForSubclasses) {
            injectorTypeBuilder.addMethod(methodSpec);
        }
        return Optional.of((Object)injectorTypeBuilder);
    }

    private static boolean visibleToMembersInjector(MembersInjectionBinding binding, Element element) {
        return MoreElements.getPackage(element).equals(MoreElements.getPackage(binding.membersInjectedType())) || element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private CodeBlock directInjectMemberCodeBlock(MembersInjectionBinding binding, ImmutableMap<BindingKey, FieldSpec> dependencyFields, MembersInjectionBinding.InjectionSite injectionSite) {
        return CodeBlock.of(injectionSite.element().getKind().isField() ? "$L.$L = $L;" : "$L.$L($L);", this.getInstanceCodeBlockWithPotentialCast(injectionSite.element().getEnclosingElement(), binding.membersInjectedType()), injectionSite.element().getSimpleName(), CodeBlocks.makeParametersCodeBlock(this.parameterCodeBlocks(dependencyFields, injectionSite.dependencies(), true)));
    }

    private CodeBlock delegateInjectMemberCodeBlock(ImmutableMap<BindingKey, FieldSpec> dependencyFields, MembersInjectionBinding.InjectionSite injectionSite) {
        return CodeBlock.of("$L.$L($L);", SourceFiles.membersInjectorNameForType(MoreElements.asType(injectionSite.element().getEnclosingElement())), this.injectionSiteDelegateMethodName(injectionSite.element()), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)new ImmutableList.Builder().add((Object)CodeBlock.of("instance", new Object[0])).addAll(this.parameterCodeBlocks(dependencyFields, injectionSite.dependencies(), false)).build()));
    }

    private ImmutableList<CodeBlock> parameterCodeBlocks(ImmutableMap<BindingKey, FieldSpec> dependencyFields, ImmutableSet<DependencyRequest> dependencies, boolean passValue) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (DependencyRequest dependency : dependencies) {
            CodeBlock fieldCodeBlock = CodeBlock.of("$L", ((FieldSpec)dependencyFields.get((Object)dependency.bindingKey())).name);
            parameters.add((Object)(passValue ? SourceFiles.frameworkTypeUsageStatement(fieldCodeBlock, dependency.kind()) : fieldCodeBlock));
        }
        return parameters.build();
    }

    private CodeBlock getInstanceCodeBlockWithPotentialCast(Element injectionSiteElement, Element bindingElement) {
        if (injectionSiteElement.equals(bindingElement)) {
            return CodeBlock.of("instance", new Object[0]);
        }
        TypeName injectionSiteName = TypeName.get(injectionSiteElement.asType());
        if (injectionSiteName instanceof ParameterizedTypeName) {
            injectionSiteName = ((ParameterizedTypeName)injectionSiteName).rawType;
        }
        return CodeBlock.of("(($T) instance)", injectionSiteName);
    }

    private String injectionSiteDelegateMethodName(Element injectionSiteElement) {
        return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, injectionSiteElement.getSimpleName().toString());
    }

    private MethodSpec injectorMethodForSubclasses(ImmutableMap<BindingKey, FieldSpec> dependencyFields, List<TypeVariableName> typeParameters, TypeName injectedTypeName, Element injectionElement, ImmutableSet<DependencyRequest> dependencies) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(this.injectionSiteDelegateMethodName(injectionElement)).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(injectedTypeName, "instance", new Modifier[0]).addTypeVariables(typeParameters);
        ImmutableList.Builder providedParameters = ImmutableList.builder();
        HashSet<String> parameterNames = new HashSet<String>();
        for (DependencyRequest dependency : dependencies) {
            FieldSpec field = (FieldSpec)dependencyFields.get((Object)dependency.bindingKey());
            ParameterSpec parameter = ParameterSpec.builder(field.type, this.staticInjectMethodDependencyParameterName(parameterNames, dependency, field), new Modifier[0]).build();
            methodBuilder.addParameter(parameter);
            providedParameters.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$N", parameter), dependency.kind()));
        }
        if (injectionElement.getKind().isField()) {
            methodBuilder.addStatement("instance.$L = $L", injectionElement.getSimpleName(), Iterables.getOnlyElement((Iterable)providedParameters.build()));
        } else {
            methodBuilder.addStatement("instance.$L($L)", injectionElement.getSimpleName(), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)providedParameters.build()));
        }
        return methodBuilder.build();
    }

    private String staticInjectMethodDependencyParameterName(Set<String> parameterNames, DependencyRequest dependency, FieldSpec field) {
        StringBuilder parameterName = new StringBuilder(((Element)dependency.requestElement().get()).getSimpleName().toString());
        switch (dependency.kind()) {
            case LAZY: 
            case INSTANCE: 
            case FUTURE: {
                String suffix = ((ParameterizedTypeName)field.type).rawType.simpleName();
                if (parameterName.length() > suffix.length() && parameterName.substring(parameterName.length() - suffix.length()).equals(suffix)) break;
                parameterName.append(suffix);
                break;
            }
        }
        int baseLength = parameterName.length();
        int i = 2;
        while (!parameterNames.add(parameterName.toString())) {
            parameterName.replace(baseLength, parameterName.length(), String.valueOf(i));
            ++i;
        }
        return parameterName.toString();
    }
}

