/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.internal.codegen.AutoValue_Key;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.Production;
import dagger.producers.internal.ProductionImplementation;
import dagger.producers.monitoring.ProductionComponentMonitor;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Key {
    Key() {
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedQualifier();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    abstract Optional<MultibindingContributionIdentifier> multibindingContributionIdentifier();

    abstract Builder toBuilder();

    static Builder builder(TypeMirror type) {
        return new AutoValue_Key.Builder().type(type);
    }

    Optional<AnnotationMirror> qualifier() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedQualifier());
    }

    TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    Key withoutMultibindingContributionIdentifier() {
        return this.toBuilder().multibindingContributionIdentifier((Optional<MultibindingContributionIdentifier>)Optional.absent()).build();
    }

    boolean isValidMembersInjectionKey() {
        return !this.qualifier().isPresent() && !this.type().getKind().equals((Object)TypeKind.WILDCARD);
    }

    boolean isValidImplicitProvisionKey(Types types) {
        return Key.isValidImplicitProvisionKey(this.qualifier(), this.type(), types);
    }

    static boolean isValidImplicitProvisionKey(Optional<? extends AnnotationMirror> qualifier, TypeMirror type, final Types types) {
        if (qualifier.isPresent()) {
            return false;
        }
        return type.accept(new SimpleTypeVisitor6<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                TypeElement element = MoreElements.asType(type.asElement());
                if (!element.getKind().equals((Object)ElementKind.CLASS) || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    return false;
                }
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (typeMirror.getKind() == TypeKind.DECLARED) continue;
                    return false;
                }
                return MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() || !types.isSameType(types.erasure(element.asType()), type);
            }
        }, null);
    }

    public String toString() {
        return Joiner.on((char)' ').skipNulls().join(this.qualifier().orNull(), (Object)this.type(), new Object[]{this.multibindingContributionIdentifier().orNull()});
    }

    static <T extends HasKey> ImmutableSetMultimap<Key, T> indexByKey(Iterable<T> haveKeys) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(haveKeys, (Function)new Function<HasKey, Key>(){

            public Key apply(HasKey hasKey) {
                return hasKey.key();
            }
        }));
    }

    static final class Factory {
        private final Types types;
        private final Elements elements;

        Factory(Types types, Elements elements) {
            this.types = (Types)Preconditions.checkNotNull((Object)types);
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        }

        private TypeElement getClassElement(Class<?> cls) {
            return this.elements.getTypeElement(cls.getCanonicalName());
        }

        private TypeMirror boxPrimitives(TypeMirror type) {
            return type.getKind().isPrimitive() ? this.types.boxedClass((PrimitiveType)type).asType() : type;
        }

        private DeclaredType setOf(TypeMirror elementType) {
            return this.types.getDeclaredType(this.getClassElement(Set.class), this.boxPrimitives(elementType));
        }

        private DeclaredType mapOf(TypeMirror keyType, TypeMirror valueType) {
            return this.types.getDeclaredType(this.getClassElement(Map.class), this.boxPrimitives(keyType), this.boxPrimitives(valueType));
        }

        private TypeMirror mapOfFrameworkType(TypeMirror keyType, TypeElement frameworkType, TypeMirror valueType) {
            return this.mapOf(keyType, this.types.getDeclaredType(frameworkType, this.boxPrimitives(valueType)));
        }

        Key forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            return this.forMethod(componentMethod, componentMethod.getReturnType());
        }

        Key forProductionComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror returnType = componentMethod.getReturnType();
            TypeMirror keyType = MoreTypes.isTypeOf(ListenableFuture.class, returnType) ? (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments()) : returnType;
            return this.forMethod(componentMethod, keyType);
        }

        Key forSubcomponentBuilderMethod(ExecutableElement subcomponentBuilderMethod, DeclaredType declaredContainer) {
            Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, subcomponentBuilderMethod));
            return Key.builder(resolvedMethod.getReturnType()).build();
        }

        Key forSubcomponentBuilder(TypeMirror builderType) {
            return Key.builder(builderType).build();
        }

        Key forProvidesMethod(ExecutableElement method, TypeElement contributingModule) {
            return this.forBindingMethod(method, contributingModule, (Optional<TypeElement>)Optional.of((Object)this.getClassElement(Provider.class)));
        }

        Key forProducesMethod(ExecutableElement method, TypeElement contributingModule) {
            return this.forBindingMethod(method, contributingModule, (Optional<TypeElement>)Optional.of((Object)this.getClassElement(Producer.class)));
        }

        Key forBindsMethod(ExecutableElement method, TypeElement contributingModule) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, Binds.class));
            return this.forBindingMethod(method, contributingModule, (Optional<TypeElement>)Optional.absent());
        }

        Key forBindsOptionalOfMethod(ExecutableElement method, TypeElement contributingModule) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, BindsOptionalOf.class));
            return this.forBindingMethod(method, contributingModule, (Optional<TypeElement>)Optional.absent());
        }

        private Key forBindingMethod(ExecutableElement method, TypeElement contributingModule, Optional<TypeElement> frameworkType) {
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributingModule.asType()), method));
            ContributionType contributionType = ContributionType.fromBindingMethod(method);
            TypeMirror returnType = methodType.getReturnType();
            if (frameworkType.isPresent() && ((TypeElement)frameworkType.get()).equals(this.getClassElement(Producer.class)) && MoreTypes.isType(returnType) && MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                returnType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            TypeMirror keyType = this.bindingMethodKeyType(returnType, method, contributionType, frameworkType);
            Key key = this.forMethod(method, keyType);
            return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.toBuilder().multibindingContributionIdentifier(new MultibindingContributionIdentifier(method, contributingModule)).build();
        }

        Key forMultibindsMethod(BindingType bindingType, ExecutableType executableType, ExecutableElement method) {
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD), (String)"%s must be a method", (Object[])new Object[]{method});
            TypeElement factoryType = this.elements.getTypeElement(bindingType.frameworkClass().getCanonicalName());
            TypeMirror returnType = executableType.getReturnType();
            TypeMirror keyType = MapType.isMap(returnType) ? this.mapOfFrameworkType(MapType.from(returnType).keyType(), factoryType, MapType.from(returnType).valueType()) : returnType;
            return this.forMethod(method, keyType);
        }

        private TypeMirror bindingMethodKeyType(TypeMirror returnType, ExecutableElement method, ContributionType contributionType, Optional<TypeElement> frameworkType) {
            switch (contributionType) {
                case UNIQUE: {
                    return returnType;
                }
                case SET: {
                    return this.setOf(returnType);
                }
                case MAP: {
                    if (frameworkType.isPresent()) {
                        return this.mapOfFrameworkType(this.mapKeyType(method), (TypeElement)frameworkType.get(), returnType);
                    }
                    return this.mapOf(this.mapKeyType(method), returnType);
                }
                case SET_VALUES: {
                    Preconditions.checkArgument((boolean)SetType.isSet(returnType));
                    return returnType;
                }
            }
            throw new AssertionError();
        }

        Key forDelegateBinding(DelegateDeclaration delegateDeclaration, Class<?> frameworkType) {
            return delegateDeclaration.contributionType().equals((Object)ContributionType.MAP) ? this.wrapMapValue(delegateDeclaration.key(), frameworkType) : delegateDeclaration.key();
        }

        private TypeMirror mapKeyType(ExecutableElement method) {
            AnnotationMirror mapKeyAnnotation = (AnnotationMirror)MapKeys.getMapKey(method).get();
            return MapKeys.unwrapValue(mapKeyAnnotation).isPresent() ? MapKeys.getUnwrappedMapKeyType(mapKeyAnnotation.getAnnotationType(), this.types) : mapKeyAnnotation.getAnnotationType();
        }

        private Key forMethod(ExecutableElement method, TypeMirror keyType) {
            return this.forQualifiedType(InjectionAnnotations.getQualifier(method), keyType);
        }

        Key forInjectConstructorWithResolvedType(TypeMirror type) {
            return Key.builder(type).build();
        }

        Key forComponent(TypeMirror type) {
            return Key.builder(type).build();
        }

        Key forMembersInjectedType(TypeMirror type) {
            return Key.builder(type).build();
        }

        Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type) {
            return Key.builder(this.boxPrimitives(type)).qualifier(qualifier).build();
        }

        Key forProductionExecutor() {
            return Key.builder(this.getClassElement(Executor.class).asType()).qualifier(this.getClassElement(Production.class)).build();
        }

        Key forProductionImplementationExecutor() {
            return Key.builder(this.getClassElement(Executor.class).asType()).qualifier(this.getClassElement(ProductionImplementation.class)).build();
        }

        Key forProductionComponentMonitor() {
            return Key.builder(this.getClassElement(ProductionComponentMonitor.class).asType()).build();
        }

        FluentIterable<Key> implicitFrameworkMapKeys(Key requestKey) {
            return FluentIterable.from((Iterable)Optional.presentInstances((Iterable)ImmutableList.of(this.implicitMapProviderKeyFrom(requestKey), this.implicitMapProducerKeyFrom(requestKey))));
        }

        Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
            return this.wrapMapKey(possibleMapKey, Provider.class);
        }

        Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
            return this.rewrapMapKey(possibleMapKey, Produced.class, Producer.class).or(this.wrapMapKey(possibleMapKey, Producer.class));
        }

        Key convertToDelegateKey(Key possibleMapKey) {
            TypeMirror wrappedValueType;
            if (!MapType.isMap(possibleMapKey)) {
                return possibleMapKey;
            }
            MapType mapType = MapType.from(possibleMapKey);
            if (mapType.valuesAreTypeOf(Provider.class)) {
                wrappedValueType = mapType.unwrappedValueType(Provider.class);
            } else if (mapType.valuesAreTypeOf(Producer.class)) {
                wrappedValueType = mapType.unwrappedValueType(Producer.class);
            } else {
                return possibleMapKey;
            }
            return possibleMapKey.toBuilder().type(this.mapOf(mapType.keyType(), wrappedValueType)).build();
        }

        private Key wrapMapValue(Key key, Class<?> newWrappingClass) {
            Preconditions.checkArgument((boolean)FrameworkTypes.isFrameworkType(this.elements.getTypeElement(newWrappingClass.getName()).asType()));
            return (Key)this.wrapMapKey(key, newWrappingClass).get();
        }

        Optional<Key> rewrapMapKey(Key possibleMapKey, Class<?> currentWrappingClass, Class<?> newWrappingClass) {
            MapType mapType;
            Preconditions.checkArgument((!currentWrappingClass.equals(newWrappingClass) ? 1 : 0) != 0);
            if (MapType.isMap(possibleMapKey) && (mapType = MapType.from(possibleMapKey)).valuesAreTypeOf(currentWrappingClass)) {
                TypeElement wrappingElement = this.getClassElement(newWrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.unwrappedValueType(currentWrappingClass));
                return Optional.of((Object)possibleMapKey.toBuilder().type(this.mapOf(mapType.keyType(), wrappedValueType)).build());
            }
            return Optional.absent();
        }

        private Optional<Key> wrapMapKey(Key possibleMapKey, Class<?> wrappingClass) {
            MapType mapType;
            if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).valuesAreTypeOf(wrappingClass)) {
                TypeElement wrappingElement = this.getClassElement(wrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.valueType());
                return Optional.of((Object)possibleMapKey.toBuilder().type(this.mapOf(mapType.keyType(), wrappedValueType)).build());
            }
            return Optional.absent();
        }

        Optional<Key> unwrapSetKey(Key key, Class<?> wrappingClass) {
            SetType setType;
            if (SetType.isSet(key) && (setType = SetType.from(key)).elementsAreTypeOf(wrappingClass)) {
                return Optional.of((Object)key.toBuilder().type(this.setOf(setType.unwrappedElementType(wrappingClass))).build());
            }
            return Optional.absent();
        }

        Optional<Key> unwrapOptional(Key key) {
            if (!OptionalType.isOptional(key)) {
                return Optional.absent();
            }
            TypeMirror underlyingType = DependencyRequest.extractKindAndType(OptionalType.from(key).valueType()).type();
            return Optional.of((Object)key.toBuilder().type(underlyingType).build());
        }
    }

    static final class MultibindingContributionIdentifier {
        private final String identifierString;

        MultibindingContributionIdentifier(ExecutableElement bindingMethod, TypeElement contributingModule) {
            this.identifierString = String.format("%s#%s", contributingModule.getQualifiedName(), bindingMethod.getSimpleName());
        }

        public String toString() {
            return this.identifierString;
        }

        public boolean equals(Object obj) {
            return obj instanceof MultibindingContributionIdentifier && ((MultibindingContributionIdentifier)obj).identifierString.equals(this.identifierString);
        }

        public int hashCode() {
            return this.identifierString.hashCode();
        }
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder wrappedType(Equivalence.Wrapper<TypeMirror> var1);

        Builder type(TypeMirror type) {
            return this.wrappedType((Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap(Preconditions.checkNotNull((Object)type)));
        }

        abstract Builder wrappedQualifier(Optional<Equivalence.Wrapper<AnnotationMirror>> var1);

        abstract Builder wrappedQualifier(Equivalence.Wrapper<AnnotationMirror> var1);

        Builder qualifier(AnnotationMirror qualifier) {
            return this.wrappedQualifier((Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap(Preconditions.checkNotNull((Object)qualifier)));
        }

        Builder qualifier(Optional<AnnotationMirror> qualifier) {
            return this.wrappedQualifier(MoreAnnotationMirrors.wrapOptionalInEquivalence((Optional<AnnotationMirror>)((Optional)Preconditions.checkNotNull(qualifier))));
        }

        Builder qualifier(TypeElement annotationType) {
            return this.qualifier(SimpleAnnotationMirror.of(annotationType));
        }

        abstract Builder multibindingContributionIdentifier(Optional<MultibindingContributionIdentifier> var1);

        abstract Builder multibindingContributionIdentifier(MultibindingContributionIdentifier var1);

        abstract Key build();
    }

    static interface HasKey {
        public Key key();
    }
}

