/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.Lazy;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor7;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final Types types;
    private final Elements elements;

    DependencyRequestFormatter(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
    }

    String toDependencyTrace(BindingGraphValidator.DependencyPath dependencyPath) {
        return Joiner.on((char)'\n').join((Iterable)dependencyPath.resolvedRequests().transform((Function)new Function<BindingGraphValidator.ResolvedRequest, String>(){

            public String apply(BindingGraphValidator.ResolvedRequest resolvedRequest) {
                ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations = resolvedRequest.dependentOptionalBindingDeclarations();
                return optionalBindingDeclarations.isEmpty() ? DependencyRequestFormatter.this.format(resolvedRequest.dependencyRequest()) : DependencyRequestFormatter.this.formatSyntheticOptionalBindingDependency((ImmutableSet<OptionalBindingDeclaration>)optionalBindingDeclarations);
            }
        }).filter(Predicates.not((Predicate)Predicates.equalTo((Object)""))).toList().reverse());
    }

    @Override
    public String format(DependencyRequest request) {
        if (!request.requestElement().isPresent()) {
            return "";
        }
        return ((Element)request.requestElement().get()).accept(new ElementKindVisitor7<String, DependencyRequest>(){

            @Override
            public String visitExecutableAsMethod(ExecutableElement method, DependencyRequest request) {
                StringBuilder builder = new StringBuilder();
                builder.append("    ").append(DependencyRequestFormatter.this.formatKey(request.key())).append(" is ").append(DependencyRequestFormatter.this.componentMethodRequestVerb(request)).append(" at\n").append("        ");
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(method, builder);
                builder.append('(');
                for (VariableElement variableElement : method.getParameters()) {
                    builder.append(variableElement.getSimpleName());
                }
                builder.append(')');
                return builder.toString();
            }

            @Override
            public String visitVariableAsParameter(VariableElement variable, DependencyRequest request) {
                StringBuilder builder = new StringBuilder();
                DependencyRequestFormatter.this.appendRequestedTypeIsInjectedAt(builder, request);
                ExecutableElement methodOrConstructor = MoreElements.asExecutable(variable.getEnclosingElement());
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(methodOrConstructor, builder).append('(');
                List<? extends VariableElement> parameters = methodOrConstructor.getParameters();
                int parameterIndex = parameters.indexOf(variable);
                builder.append(DependencyRequestFormatter.this.formatArgumentInList(parameterIndex, parameters.size(), variable.getSimpleName()));
                builder.append(')');
                return builder.toString();
            }

            @Override
            public String visitVariableAsField(VariableElement variable, DependencyRequest request) {
                StringBuilder builder = new StringBuilder();
                DependencyRequestFormatter.this.appendRequestedTypeIsInjectedAt(builder, request);
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(variable, builder);
                return builder.toString();
            }

            @Override
            public String visitType(TypeElement e, DependencyRequest request) {
                return "";
            }

            @Override
            protected String defaultAction(Element element, DependencyRequest request) {
                throw new IllegalStateException("Invalid request " + (Object)((Object)element.getKind()) + " element " + element);
            }
        }, request);
    }

    @CanIgnoreReturnValue
    private StringBuilder appendRequestedTypeIsInjectedAt(StringBuilder builder, DependencyRequest request) {
        return builder.append("    ").append(this.formatKey(request.key().qualifier(), this.requestedType(request))).append(" is injected at\n").append("        ");
    }

    private TypeMirror requestedType(DependencyRequest request) {
        TypeMirror keyType = request.key().type();
        switch (request.kind()) {
            case FUTURE: {
                return this.wrapType(ListenableFuture.class, keyType);
            }
            case PROVIDER_OF_LAZY: {
                return this.wrapType(Provider.class, this.wrapType(Lazy.class, keyType));
            }
        }
        if (request.kind().frameworkClass.isPresent()) {
            return this.wrapType((Class)request.kind().frameworkClass.get(), keyType);
        }
        return keyType;
    }

    private DeclaredType wrapType(Class<?> wrapperType, TypeMirror wrappedType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(wrapperType.getCanonicalName()), wrappedType);
    }

    private String formatKey(Key key) {
        return this.formatKey(key.qualifier(), key.type());
    }

    private String formatKey(Optional<AnnotationMirror> qualifier, TypeMirror type) {
        StringBuilder builder = new StringBuilder();
        if (qualifier.isPresent()) {
            builder.append(qualifier.get()).append(' ');
        }
        builder.append(type);
        return builder.toString();
    }

    private String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: {
                return "produced";
            }
            case PROVIDER_OF_LAZY: 
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: {
                return "provided";
            }
            case MEMBERS_INJECTOR: {
                return "injected";
            }
        }
        throw new AssertionError((Object)("illegal request kind for method: " + request));
    }

    @CanIgnoreReturnValue
    private StringBuilder appendEnclosingTypeAndMemberName(Element member, StringBuilder builder) {
        TypeElement type = MoreElements.asType(member.getEnclosingElement());
        return builder.append(type.getQualifiedName()).append('.').append(member.getSimpleName());
    }

    private String formatSyntheticOptionalBindingDependency(ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations) {
        OptionalBindingDeclaration optionalBindingDeclaration = (OptionalBindingDeclaration)optionalBindingDeclarations.iterator().next();
        StringBuilder builder = new StringBuilder();
        builder.append("    ").append("@BindsOptionalOf ").append(this.formatKey(optionalBindingDeclaration.key())).append(" is declared at\n").append("        ");
        this.appendEnclosingTypeAndMemberName((Element)optionalBindingDeclaration.bindingElement().get(), builder);
        builder.append("()");
        if (optionalBindingDeclarations.size() > 1) {
            builder.append(", among others");
        }
        return builder.toString();
    }
}

