/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import javax.lang.model.element.ExecutableElement;

enum ContributionType {
    MAP,
    SET,
    SET_VALUES,
    UNIQUE;


    boolean isMultibinding() {
        return !this.equals((Object)UNIQUE);
    }

    private static ContributionType forProvisionType(Provides.Type provisionType) {
        switch (provisionType) {
            case SET: {
                return SET;
            }
            case SET_VALUES: {
                return SET_VALUES;
            }
            case MAP: {
                return MAP;
            }
            case UNIQUE: {
                return UNIQUE;
            }
        }
        throw new AssertionError((Object)("Unknown provision type: " + provisionType));
    }

    private static ContributionType forProductionType(Produces.Type productionType) {
        switch (productionType) {
            case SET: {
                return SET;
            }
            case SET_VALUES: {
                return SET_VALUES;
            }
            case MAP: {
                return MAP;
            }
            case UNIQUE: {
                return UNIQUE;
            }
        }
        throw new AssertionError((Object)("Unknown production type: " + productionType));
    }

    static ContributionType fromBindingMethod(ExecutableElement method) {
        if (MoreElements.isAnnotationPresent(method, IntoMap.class)) {
            return MAP;
        }
        if (MoreElements.isAnnotationPresent(method, IntoSet.class)) {
            return SET;
        }
        if (MoreElements.isAnnotationPresent(method, ElementsIntoSet.class)) {
            return SET_VALUES;
        }
        if (MoreElements.isAnnotationPresent(method, Provides.class)) {
            return ContributionType.forProvisionType(method.getAnnotation(Provides.class).type());
        }
        if (MoreElements.isAnnotationPresent(method, Produces.class)) {
            return ContributionType.forProductionType(method.getAnnotation(Produces.class).type());
        }
        return UNIQUE;
    }

    static <T extends HasContributionType> ImmutableListMultimap<ContributionType, T> indexByContributionType(Iterable<T> haveContributionTypes) {
        return Multimaps.index(haveContributionTypes, (Function)new Function<HasContributionType, ContributionType>(){

            public ContributionType apply(HasContributionType hasContributionType) {
                return hasContributionType.contributionType();
            }
        });
    }

    static interface HasContributionType {
        public ContributionType contributionType();
    }
}

