/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class ComponentHierarchyValidator {
    ComponentHierarchyValidator() {
    }

    ValidationReport<TypeElement> validate(ComponentDescriptor componentDescriptor) {
        return this.validateSubcomponentMethods(componentDescriptor, (ImmutableMap<TypeElement, TypeElement>)Maps.toMap(componentDescriptor.transitiveModuleTypes(), (Function)Functions.constant((Object)componentDescriptor.componentDefinitionType())));
    }

    private ValidationReport<TypeElement> validateSubcomponentMethods(ComponentDescriptor componentDescriptor, ImmutableMap<TypeElement, TypeElement> existingModuleToOwners) {
        ValidationReport.Builder<TypeElement> reportBuilder = ValidationReport.about(componentDescriptor.componentDefinitionType());
        for (Map.Entry subcomponentEntry : componentDescriptor.subcomponentsByFactoryMethod().entrySet()) {
            ComponentDescriptor.ComponentMethodDescriptor subcomponentMethodDescriptor = (ComponentDescriptor.ComponentMethodDescriptor)subcomponentEntry.getKey();
            ComponentDescriptor subcomponentDescriptor = (ComponentDescriptor)subcomponentEntry.getValue();
            for (VariableElement variableElement : subcomponentMethodDescriptor.methodElement().getParameters()) {
                TypeElement moduleType = MoreTypes.asTypeElement(variableElement.asType());
                TypeElement originatingComponent = (TypeElement)existingModuleToOwners.get((Object)moduleType);
                if (originatingComponent == null) continue;
                reportBuilder.addError(String.format("%s is present in %s. A subcomponent cannot use an instance of a module that differs from its parent.", moduleType.getSimpleName(), originatingComponent.getQualifiedName()), variableElement);
            }
            reportBuilder.addSubreport(this.validateSubcomponentMethods(subcomponentDescriptor, (ImmutableMap<TypeElement, TypeElement>)new ImmutableMap.Builder().putAll(existingModuleToOwners).putAll((Map)Maps.toMap((Iterable)Sets.difference(subcomponentDescriptor.transitiveModuleTypes(), (Set)existingModuleToOwners.keySet()), (Function)Functions.constant((Object)subcomponentDescriptor.componentDefinitionType()))).build()));
        }
        return reportBuilder.build();
    }
}

