/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.squareup.javapoet.TypeName;
import dagger.Component;
import dagger.internal.codegen.AutoValue_BindingGraphValidator_ResolvedRequest;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MissingBindingSuggestions;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class BindingGraphValidator {
    private final Elements elements;
    private final Types types;
    private final CompilerOptions compilerOptions;
    private final InjectValidator injectValidator;
    private final InjectBindingRegistry injectBindingRegistry;
    private final BindingDeclarationFormatter bindingDeclarationFormatter;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final KeyFormatter keyFormatter;
    private final Key.Factory keyFactory;

    BindingGraphValidator(Elements elements, Types types, CompilerOptions compilerOptions, InjectValidator injectValidator, InjectBindingRegistry injectBindingRegistry, BindingDeclarationFormatter bindingDeclarationFormatter, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFormatter dependencyRequestFormatter, KeyFormatter keyFormatter, Key.Factory keyFactory) {
        this.elements = elements;
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.injectValidator = injectValidator;
        this.injectBindingRegistry = injectBindingRegistry;
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.keyFormatter = keyFormatter;
        this.keyFactory = keyFactory;
    }

    ValidationReport<TypeElement> validate(BindingGraph subject) {
        Validation validation = new Validation(subject);
        validation.validateSubgraph();
        return validation.buildReport();
    }

    private void appendIndentedComponentsList(StringBuilder message, Iterable<TypeElement> types) {
        for (TypeElement scopedComponent : types) {
            message.append("    ");
            for (Scope scope : Scope.scopesOf(scopedComponent)) {
                message.append(scope.getReadableSource()).append(' ');
            }
            message.append(ErrorMessages.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
        }
    }

    private ImmutableSet<TypeElement> scopedTypesIn(Set<TypeElement> types) {
        return FluentIterable.from(types).filter((Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement input) {
                return !Scope.scopesOf(input).isEmpty();
            }
        }).toSet();
    }

    private boolean doesPathRequireProvisionOnly(DependencyPath path) {
        if (path.size() == 1) {
            switch (path.currentDependencyRequest().kind()) {
                case PROVIDER: 
                case LAZY: 
                case INSTANCE: 
                case MEMBERS_INJECTOR: {
                    return true;
                }
                case PRODUCER: 
                case PRODUCED: 
                case FUTURE: {
                    return false;
                }
            }
            throw new AssertionError();
        }
        return !this.provisionsDependingOnLatestRequest(path).isEmpty();
    }

    private FluentIterable<ContributionBinding> provisionsDependingOnLatestRequest(final DependencyPath path) {
        return FluentIterable.from(path.previousResolvedBindings().bindings()).filter(BindingType.isOfType(BindingType.PROVISION)).filter((Predicate)new Predicate<Binding>(){

            public boolean apply(Binding binding) {
                return binding.implicitDependencies().contains(path.currentDependencyRequest());
            }
        }).filter(ContributionBinding.class);
    }

    private String formatContributionType(ContributionType type) {
        switch (type) {
            case MAP: {
                return "Map";
            }
            case SET: 
            case SET_VALUES: {
                return "Set";
            }
            case UNIQUE: {
                return "Unique";
            }
        }
        throw new IllegalStateException("Unknown binding type: " + (Object)((Object)type));
    }

    private String formatCurrentDependencyRequestKey(DependencyPath path) {
        return this.keyFormatter.format(path.currentDependencyRequest().key());
    }

    static abstract class ResolvedRequest {
        static final Function<ResolvedRequest, DependencyRequest> DEPENDENCY_REQUEST = new Function<ResolvedRequest, DependencyRequest>(){

            public DependencyRequest apply(ResolvedRequest resolvedRequest) {
                return resolvedRequest.dependencyRequest();
            }
        };

        ResolvedRequest() {
        }

        abstract DependencyRequest dependencyRequest();

        abstract ResolvedBindings resolvedBindings();

        abstract Optional<ResolvedBindings> dependentBindings();

        ImmutableSet<OptionalBindingDeclaration> dependentOptionalBindingDeclarations() {
            if (this.dependentBindings().isPresent()) {
                ResolvedBindings dependentBindings = (ResolvedBindings)this.dependentBindings().get();
                for (ContributionBinding dependentBinding : dependentBindings.contributionBindings()) {
                    if (!dependentBinding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_OPTIONAL_BINDING) || !dependentBinding.dependencies().contains((Object)this.dependencyRequest())) continue;
                    return dependentBindings.optionalBindingDeclarations();
                }
            }
            return ImmutableSet.of();
        }

        private static ResolvedRequest create(DependencyRequest request, ResolvedBindings resolvedBindings, Optional<ResolvedBindings> dependentBindings) {
            return new AutoValue_BindingGraphValidator_ResolvedRequest(request, resolvedBindings, dependentBindings);
        }
    }

    private final class Validation {
        final BindingGraph subject;
        final ValidationReport.Builder<TypeElement> reportBuilder;
        final Optional<Validation> parent;
        final ImmutableMap<ComponentDescriptor, BindingGraph> subgraphsByComponentDescriptor;

        Validation(BindingGraph subject, Optional<Validation> parent) {
            this.subject = subject;
            this.reportBuilder = ValidationReport.about(subject.componentDescriptor().componentDefinitionType());
            this.parent = parent;
            this.subgraphsByComponentDescriptor = Maps.uniqueIndex(subject.subgraphs(), BindingGraph.COMPONENT_DESCRIPTOR);
        }

        Validation(BindingGraph topLevelGraph) {
            this(topLevelGraph, (Optional<Validation>)Optional.absent());
        }

        BindingGraph topLevelGraph() {
            return this.parent.isPresent() ? ((Validation)this.parent.get()).topLevelGraph() : this.subject;
        }

        ValidationReport<TypeElement> buildReport() {
            return this.reportBuilder.build();
        }

        void validateSubgraph() {
            this.validateComponentScope();
            this.validateDependencyScopes();
            this.validateComponentHierarchy();
            this.validateBuilders();
            for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : this.subject.componentDescriptor().componentMethods()) {
                Optional<DependencyRequest> entryPoint = componentMethod.dependencyRequest();
                if (!entryPoint.isPresent()) continue;
                this.traverseDependencyRequest((DependencyRequest)entryPoint.get(), new DependencyPath());
            }
            for (Map.Entry entry : this.subject.componentDescriptor().subcomponentsByFactoryMethod().entrySet()) {
                this.validateSubcomponentFactoryMethod(((ComponentDescriptor.ComponentMethodDescriptor)entry.getKey()).methodElement(), (BindingGraph)this.subgraphsByComponentDescriptor.get(entry.getValue()));
            }
            for (BindingGraph subgraph : this.subject.subgraphs()) {
                Validation subgraphValidation = new Validation(subgraph, (Optional<Validation>)Optional.of((Object)this));
                subgraphValidation.validateSubgraph();
                this.reportBuilder.addSubreport(subgraphValidation.buildReport());
            }
        }

        private void validateSubcomponentFactoryMethod(ExecutableElement factoryMethod, BindingGraph subgraph) {
            FluentIterable missingModules = FluentIterable.from(subgraph.componentRequirements()).filter(Predicates.not((Predicate)Predicates.in(this.subgraphFactoryMethodParameters(factoryMethod)))).filter((Predicate)new Predicate<TypeElement>(){

                public boolean apply(TypeElement moduleType) {
                    return !Util.componentCanMakeNewInstances(moduleType);
                }
            });
            if (!missingModules.isEmpty()) {
                this.reportBuilder.addError(String.format("%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", subgraph.componentDescriptor().componentDefinitionType().getQualifiedName(), Joiner.on((String)", ").join((Iterable)missingModules.toSet())), factoryMethod);
            }
        }

        private ImmutableSet<TypeElement> subgraphFactoryMethodParameters(ExecutableElement factoryMethod) {
            DeclaredType componentType = MoreTypes.asDeclared(this.subject.componentDescriptor().componentDefinitionType().asType());
            ExecutableType factoryMethodType = MoreTypes.asExecutable(BindingGraphValidator.this.types.asMemberOf(componentType, factoryMethod));
            return MoreTypes.asTypeElements(factoryMethodType.getParameterTypes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void traverseDependencyRequest(DependencyRequest request, DependencyPath path) {
            path.push(request, this.resolvedBindings(request));
            try {
                if (path.hasCycle()) {
                    this.reportCycle(path);
                    return;
                }
                if (path.visitCurrentDependencyRequest()) {
                    this.validateResolvedBindings(path);
                    for (Map.Entry entry : path.currentResolvedBindings().bindingsByComponent()) {
                        Validation validation = this.validationForComponent((ComponentDescriptor)entry.getKey());
                        Binding binding = (Binding)entry.getValue();
                        for (DependencyRequest nextRequest : binding.implicitDependencies()) {
                            validation.traverseDependencyRequest(nextRequest, path);
                        }
                    }
                }
            }
            finally {
                path.pop();
            }
        }

        private ResolvedBindings resolvedBindings(DependencyRequest request) {
            BindingKey bindingKey = request.bindingKey();
            ResolvedBindings resolvedBindings = (ResolvedBindings)this.subject.resolvedBindings().get((Object)bindingKey);
            return resolvedBindings == null ? ResolvedBindings.noBindings(bindingKey, this.subject.componentDescriptor()) : resolvedBindings;
        }

        private Validation validationForComponent(ComponentDescriptor component) {
            if (component.equals(this.subject.componentDescriptor())) {
                return this;
            }
            if (this.parent.isPresent()) {
                return ((Validation)this.parent.get()).validationForComponent(component);
            }
            throw new IllegalArgumentException(String.format("unknown component %s within %s", component.componentDefinitionType(), this.subject.componentDescriptor().componentDefinitionType()));
        }

        private void validateResolvedBindings(DependencyPath path) {
            ResolvedBindings resolvedBindings = path.currentResolvedBindings();
            if (resolvedBindings.isEmpty()) {
                this.reportMissingBinding(path);
                return;
            }
            switch (resolvedBindings.bindingKey().kind()) {
                case CONTRIBUTION: {
                    if (Iterables.any(resolvedBindings.bindings(), BindingType.isOfType(BindingType.MEMBERS_INJECTION))) {
                        throw new AssertionError((Object)"contribution binding keys should never have members injection bindings");
                    }
                    this.validateNullability(path, (Set<ContributionBinding>)resolvedBindings.contributionBindings());
                    if (resolvedBindings.contributionBindings().size() > 1) {
                        this.reportDuplicateBindings(path);
                        return;
                    }
                    ContributionBinding contributionBinding = resolvedBindings.contributionBinding();
                    if (contributionBinding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION)) {
                        TypeMirror type = contributionBinding.key().type();
                        ValidationReport<TypeElement> report = BindingGraphValidator.this.injectValidator.validateType(MoreTypes.asTypeElement(type));
                        if (!report.isClean()) {
                            this.reportBuilder.addSubreport(report);
                            return;
                        }
                    }
                    if (contributionBinding.bindingType().equals((Object)BindingType.PRODUCTION) && BindingGraphValidator.this.doesPathRequireProvisionOnly(path)) {
                        this.reportProviderMayNotDependOnProducer(path);
                        return;
                    }
                    if (BindingGraphValidator.this.compilerOptions.usesProducers()) {
                        Key productionImplementationExecutorKey = BindingGraphValidator.this.keyFactory.forProductionImplementationExecutor();
                        if (!contributionBinding.key().equals(productionImplementationExecutorKey)) {
                            Key productionExecutorKey = BindingGraphValidator.this.keyFactory.forProductionExecutor();
                            for (DependencyRequest request : contributionBinding.dependencies()) {
                                if (!request.key().equals(productionExecutorKey) && !request.key().equals(productionImplementationExecutorKey)) continue;
                                this.reportDependsOnProductionExecutor(path);
                                return;
                            }
                        }
                    }
                    if (!contributionBinding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP)) break;
                    this.validateMapKeys(path, contributionBinding);
                    break;
                }
                case MEMBERS_INJECTION: {
                    if (!Iterables.all(resolvedBindings.bindings(), BindingType.isOfType(BindingType.MEMBERS_INJECTION))) {
                        throw new AssertionError((Object)"members injection binding keys should never have contribution bindings");
                    }
                    if (resolvedBindings.bindings().size() > 1) {
                        this.reportDuplicateBindings(path);
                        return;
                    }
                    this.validateMembersInjectionBinding((MembersInjectionBinding)resolvedBindings.membersInjectionBinding().get(), path);
                    return;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        private ResolvedBindings inlineContributionsWithoutBindingElements(ResolvedBindings resolvedBinding) {
            if (Iterables.all(resolvedBinding.bindings(), BindingDeclaration.HAS_BINDING_ELEMENT)) {
                return resolvedBinding;
            }
            ImmutableSetMultimap.Builder contributions = ImmutableSetMultimap.builder();
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder optionalBindingDeclarations = ImmutableSet.builder();
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(resolvedBinding);
            ResolvedBindings queued = (ResolvedBindings)queue.poll();
            while (queued != null) {
                multibindingDeclarations.addAll(queued.multibindingDeclarations());
                subcomponentDeclarations.addAll(queued.subcomponentDeclarations());
                optionalBindingDeclarations.addAll(queued.optionalBindingDeclarations());
                for (Map.Entry bindingEntry : queued.allContributionBindings().entries()) {
                    BindingGraph owningGraph = this.validationForComponent((ComponentDescriptor)((ComponentDescriptor)bindingEntry.getKey())).subject;
                    ContributionBinding binding = (ContributionBinding)bindingEntry.getValue();
                    if (binding.bindingElement().isPresent()) {
                        contributions.put(bindingEntry);
                        continue;
                    }
                    for (DependencyRequest dependency : binding.dependencies()) {
                        queue.add(owningGraph.resolvedBindings().get((Object)dependency.bindingKey()));
                    }
                }
                queued = (ResolvedBindings)queue.poll();
            }
            return ResolvedBindings.forContributionBindings(resolvedBinding.bindingKey(), resolvedBinding.owningComponent(), (Multimap<ComponentDescriptor, ? extends ContributionBinding>)contributions.build(), (Iterable<MultibindingDeclaration>)multibindingDeclarations.build(), (Iterable<SubcomponentDeclaration>)subcomponentDeclarations.build(), (Iterable<OptionalBindingDeclaration>)optionalBindingDeclarations.build());
        }

        private ImmutableListMultimap<ContributionType, BindingDeclaration> declarationsByType(ResolvedBindings resolvedBinding) {
            ResolvedBindings inlined = this.inlineContributionsWithoutBindingElements(resolvedBinding);
            return new ImmutableListMultimap.Builder().putAll(ContributionType.indexByContributionType(inlined.contributionBindings())).putAll(ContributionType.indexByContributionType(inlined.multibindingDeclarations())).build();
        }

        private void validateNullability(DependencyPath path, Set<ContributionBinding> bindings) {
            if (path.currentDependencyRequest().isNullable()) {
                return;
            }
            String typeName = TypeName.get(path.currentDependencyRequest().key().type()).toString();
            for (ContributionBinding binding : bindings) {
                if (!binding.nullableType().isPresent()) continue;
                this.reportBuilder.addItem(ErrorMessages.nullableToNonNullable(typeName, BindingGraphValidator.this.bindingDeclarationFormatter.format(binding)) + "\n at: " + BindingGraphValidator.this.dependencyRequestFormatter.toDependencyTrace(path), BindingGraphValidator.this.compilerOptions.nullableValidationKind(), path.entryPointElement());
            }
        }

        private void validateMapKeys(DependencyPath path, ContributionBinding binding) {
            Preconditions.checkArgument((boolean)binding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP), (String)"binding must be a synthetic multibound map: %s", (Object[])new Object[]{binding});
            ImmutableSet.Builder multibindingContributionsBuilder = ImmutableSet.builder();
            for (DependencyRequest dependency : binding.dependencies()) {
                multibindingContributionsBuilder.add((Object)((ResolvedBindings)this.subject.resolvedBindings().get((Object)dependency.bindingKey())).contributionBinding());
            }
            ImmutableSet multibindingContributions = multibindingContributionsBuilder.build();
            this.validateMapKeySet(path, (Set<ContributionBinding>)multibindingContributions);
            this.validateMapKeyAnnotationTypes(path, (Set<ContributionBinding>)multibindingContributions);
        }

        private void validateMapKeySet(DependencyPath path, Set<ContributionBinding> mapBindings) {
            for (Collection mapBindingsForMapKey : ContributionBinding.indexMapBindingsByMapKey(mapBindings).asMap().values()) {
                if (mapBindingsForMapKey.size() <= 1) continue;
                this.reportDuplicateMapKeys(path, mapBindingsForMapKey);
            }
        }

        private void validateMapKeyAnnotationTypes(DependencyPath path, Set<ContributionBinding> contributionBindings) {
            ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> mapBindingsByAnnotationType = ContributionBinding.indexMapBindingsByAnnotationType(contributionBindings);
            if (mapBindingsByAnnotationType.keySet().size() > 1) {
                this.reportInconsistentMapKeyAnnotations(path, (Multimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding>)mapBindingsByAnnotationType);
            }
        }

        private void validateMembersInjectionBinding(final MembersInjectionBinding binding, final DependencyPath path) {
            binding.key().type().accept(new SimpleTypeVisitor6<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror e, Void p) {
                    Validation.this.reportBuilder.addError("Invalid members injection request.", binding.membersInjectedType());
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType type, Void ignored) {
                    for (TypeMirror typeMirror : type.getTypeArguments()) {
                        boolean declared;
                        switch (typeMirror.getKind()) {
                            case ARRAY: {
                                declared = MoreTypes.asArray(typeMirror).getComponentType().accept(new SimpleTypeVisitor6<Boolean, Void>(){

                                    @Override
                                    protected Boolean defaultAction(TypeMirror e, Void p) {
                                        return false;
                                    }

                                    @Override
                                    public Boolean visitDeclared(DeclaredType t, Void p) {
                                        for (TypeMirror typeMirror : t.getTypeArguments()) {
                                            if (typeMirror.accept(this, null).booleanValue()) continue;
                                            return false;
                                        }
                                        return true;
                                    }

                                    @Override
                                    public Boolean visitArray(ArrayType t, Void p) {
                                        return t.getComponentType().accept(this, null);
                                    }

                                    @Override
                                    public Boolean visitPrimitive(PrimitiveType t, Void p) {
                                        return true;
                                    }
                                }, null);
                                break;
                            }
                            case DECLARED: {
                                declared = true;
                                break;
                            }
                            default: {
                                declared = false;
                            }
                        }
                        if (declared) continue;
                        Validation.this.reportBuilder.addError(String.format("Type parameters must be bounded for members injection. %s required by %s, via:\n%s", typeMirror.toString(), type.toString(), BindingGraphValidator.this.dependencyRequestFormatter.toDependencyTrace(path)), path.entryPointElement());
                        return null;
                    }
                    TypeElement element = MoreElements.asType(type.asElement());
                    if (!MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() && BindingGraphValidator.this.types.isSameType(BindingGraphValidator.this.types.erasure(element.asType()), type)) {
                        Validation.this.reportBuilder.addError(String.format("%s has type parameters, cannot members inject the raw type. via:\n%s", type.toString(), BindingGraphValidator.this.dependencyRequestFormatter.toDependencyTrace(path)), path.entryPointElement());
                    }
                    return null;
                }
            }, null);
        }

        private void validateComponentHierarchy() {
            ComponentDescriptor descriptor = this.subject.componentDescriptor();
            TypeElement componentType = descriptor.componentDefinitionType();
            this.validateComponentHierarchy(componentType, componentType, new ArrayDeque<TypeElement>());
        }

        private void validateComponentHierarchy(TypeElement rootComponent, TypeElement componentType, Deque<TypeElement> componentStack) {
            if (componentStack.contains(componentType)) {
                StringBuilder message = new StringBuilder();
                message.append(rootComponent.getQualifiedName());
                message.append(" contains a cycle in its component dependencies:\n");
                componentStack.push(componentType);
                BindingGraphValidator.this.appendIndentedComponentsList(message, componentStack);
                componentStack.pop();
                this.reportBuilder.addItem(message.toString(), (Diagnostic.Kind)((Object)BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get()), (Element)rootComponent, (AnnotationMirror)ConfigurationAnnotations.getComponentAnnotation(rootComponent).get());
            } else {
                Optional<AnnotationMirror> componentAnnotation = ConfigurationAnnotations.getComponentAnnotation(componentType);
                if (componentAnnotation.isPresent()) {
                    componentStack.push(componentType);
                    ImmutableSet<TypeElement> dependencies = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies((AnnotationMirror)componentAnnotation.get()));
                    for (TypeElement dependency : dependencies) {
                        this.validateComponentHierarchy(rootComponent, dependency, componentStack);
                    }
                    componentStack.pop();
                }
            }
        }

        private void validateDependencyScopes() {
            ComponentDescriptor descriptor = this.subject.componentDescriptor();
            ImmutableSet<Scope> scopes = descriptor.scopes();
            ImmutableSet scopedDependencies = BindingGraphValidator.this.scopedTypesIn(descriptor.dependencies());
            if (!scopes.isEmpty()) {
                Scope singletonScope = Scope.singletonScope(BindingGraphValidator.this.elements);
                if (BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent() && scopes.contains((Object)singletonScope)) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                        this.reportBuilder.addItem(message.toString(), (Diagnostic.Kind)((Object)BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get()), (Element)descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                    }
                } else if (scopedDependencies.size() > 1) {
                    StringBuilder message = new StringBuilder();
                    for (Scope scope : scopes) {
                        message.append(scope.getReadableSource()).append(' ');
                    }
                    message.append(descriptor.componentDefinitionType().getQualifiedName()).append(" depends on more than one scoped component:\n");
                    BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                    this.reportBuilder.addError(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                } else if (!BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().equals((Object)ValidationType.NONE)) {
                    this.validateScopeHierarchy(descriptor.componentDefinitionType(), descriptor.componentDefinitionType(), new ArrayDeque<ImmutableSet<Scope>>(), new ArrayDeque<TypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(descriptor.componentDefinitionType().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                this.reportBuilder.addError(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
            }
        }

        private void validateBuilders() {
            Sets.SetView missingSetters;
            ComponentDescriptor componentDesc = this.subject.componentDescriptor();
            if (!componentDesc.builderSpec().isPresent()) {
                return;
            }
            ImmutableSet<TypeElement> availableDependencies = this.subject.availableDependencies();
            Set requiredDependencies = Sets.filter(availableDependencies, (Predicate)new Predicate<TypeElement>(){

                public boolean apply(TypeElement input) {
                    return !Util.componentCanMakeNewInstances(input);
                }
            });
            final ComponentDescriptor.BuilderSpec spec = (ComponentDescriptor.BuilderSpec)componentDesc.builderSpec().get();
            Map<TypeElement, ExecutableElement> allSetters = spec.methodMap();
            ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(this.subject.componentDescriptor().kind());
            Sets.SetView extraSetters = Sets.difference(allSetters.keySet(), availableDependencies);
            if (!extraSetters.isEmpty()) {
                Collection excessMethods = Maps.filterKeys(allSetters, (Predicate)Predicates.in((Collection)extraSetters)).values();
                FluentIterable formatted = FluentIterable.from(excessMethods).transform((Function)new Function<ExecutableElement, String>(){

                    public String apply(ExecutableElement input) {
                        return BindingGraphValidator.this.methodSignatureFormatter.format(input, (Optional<DeclaredType>)Optional.of((Object)MoreTypes.asDeclared(spec.builderDefinitionType().asType())));
                    }
                });
                this.reportBuilder.addError(String.format(msgs.extraSetters(), formatted), spec.builderDefinitionType());
            }
            if (!(missingSetters = Sets.difference((Set)requiredDependencies, allSetters.keySet())).isEmpty()) {
                this.reportBuilder.addError(String.format(msgs.missingSetters(), missingSetters), spec.builderDefinitionType());
            }
        }

        private void validateScopeHierarchy(TypeElement rootComponent, TypeElement componentType, Deque<ImmutableSet<Scope>> scopeStack, Deque<TypeElement> scopedDependencyStack) {
            ImmutableSet<Scope> scopes = Scope.scopesOf(componentType);
            if (this.stackOverlaps(scopeStack, scopes)) {
                scopedDependencyStack.push(componentType);
                StringBuilder message = new StringBuilder();
                message.append(rootComponent.getQualifiedName());
                message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, scopedDependencyStack);
                if (BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
                    this.reportBuilder.addItem(message.toString(), (Diagnostic.Kind)((Object)BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get()), (Element)rootComponent, (AnnotationMirror)ConfigurationAnnotations.getComponentAnnotation(rootComponent).get());
                }
                scopedDependencyStack.pop();
            } else {
                ImmutableSet scopedDependencies;
                Optional<AnnotationMirror> componentAnnotation = MoreElements.getAnnotationMirror(componentType, Component.class);
                if (componentAnnotation.isPresent() && (scopedDependencies = BindingGraphValidator.this.scopedTypesIn(MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies((AnnotationMirror)componentAnnotation.get())))).size() == 1) {
                    scopeStack.push(scopes);
                    scopedDependencyStack.push(componentType);
                    this.validateScopeHierarchy(rootComponent, (TypeElement)Iterables.getOnlyElement((Iterable)scopedDependencies), scopeStack, scopedDependencyStack);
                    scopedDependencyStack.pop();
                    scopeStack.pop();
                }
            }
        }

        private <T> boolean stackOverlaps(Deque<ImmutableSet<T>> stack, ImmutableSet<T> set) {
            for (ImmutableSet<T> entry : stack) {
                if (Sets.intersection(entry, set).isEmpty()) continue;
                return true;
            }
            return false;
        }

        void validateComponentScope() {
            ImmutableMap<BindingKey, ResolvedBindings> resolvedBindings = this.subject.resolvedBindings();
            ImmutableSet<Scope> componentScopes = this.subject.componentDescriptor().scopes();
            ImmutableSet.Builder incompatiblyScopedMethodsBuilder = ImmutableSet.builder();
            Scope reusableScope = Scope.reusableScope(BindingGraphValidator.this.elements);
            for (ResolvedBindings bindings : resolvedBindings.values()) {
                block5: for (ContributionBinding contributionBinding : bindings.ownedContributionBindings()) {
                    Optional<Scope> bindingScope = contributionBinding.scope();
                    if (!bindingScope.isPresent() || ((Scope)bindingScope.get()).equals(reusableScope) || componentScopes.contains(bindingScope.get())) continue;
                    switch (contributionBinding.bindingKind()) {
                        case SYNTHETIC_DELEGATE_BINDING: 
                        case PROVISION: {
                            incompatiblyScopedMethodsBuilder.add((Object)BindingGraphValidator.this.methodSignatureFormatter.format(MoreElements.asExecutable((Element)contributionBinding.bindingElement().get())));
                            continue block5;
                        }
                        case INJECTION: {
                            incompatiblyScopedMethodsBuilder.add((Object)(((Scope)bindingScope.get()).getReadableSource() + " class " + ((TypeElement)contributionBinding.bindingTypeElement().get()).getQualifiedName()));
                            continue block5;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            ImmutableSet incompatiblyScopedMethods = incompatiblyScopedMethodsBuilder.build();
            if (!incompatiblyScopedMethods.isEmpty()) {
                TypeElement componentType = this.subject.componentDescriptor().componentDefinitionType();
                StringBuilder message = new StringBuilder(componentType.getQualifiedName());
                if (!componentScopes.isEmpty()) {
                    message.append(" scoped with ");
                    for (Scope scope : componentScopes) {
                        message.append(scope.getReadableSource()).append(' ');
                    }
                    message.append("may not reference bindings with different scopes:\n");
                } else {
                    message.append(" (unscoped) may not reference scoped bindings:\n");
                }
                for (String method : incompatiblyScopedMethods) {
                    message.append("    ").append(method).append("\n");
                }
                this.reportBuilder.addError(message.toString(), componentType, this.subject.componentDescriptor().componentAnnotation());
            }
        }

        private void reportProviderMayNotDependOnProducer(DependencyPath path) {
            StringBuilder errorMessage = new StringBuilder();
            if (path.size() == 1) {
                new Formatter(errorMessage).format("%s is a provision entry-point, which cannot depend on a production.", BindingGraphValidator.this.formatCurrentDependencyRequestKey(path));
            } else {
                FluentIterable dependentProvisions = BindingGraphValidator.this.provisionsDependingOnLatestRequest(path);
                new Formatter(errorMessage).format("%s is a provision, which cannot depend on a production.", ((ContributionBinding)dependentProvisions.iterator().next()).key());
            }
            this.reportBuilder.addError(errorMessage.toString(), path.entryPointElement());
        }

        private StringBuilder requiresErrorMessageBase(DependencyPath path) {
            Optional<MembersInjectionBinding> membersInjectionBinding;
            String requiresErrorMessageFormat;
            Key key = path.currentDependencyRequest().key();
            if (key.type().getKind().equals((Object)TypeKind.WILDCARD)) {
                requiresErrorMessageFormat = "Dagger does not support injecting Provider<T>, Lazy<T> or Produced<T> when T is a wildcard type such as <%s>.";
            } else {
                boolean requiresProvision = BindingGraphValidator.this.doesPathRequireProvisionOnly(path);
                requiresErrorMessageFormat = !key.isValidImplicitProvisionKey(BindingGraphValidator.this.types) ? (requiresProvision ? "%s cannot be provided without an @Provides-annotated method." : "%s cannot be provided without an @Provides- or @Produces-annotated method.") : (requiresProvision ? "%s cannot be provided without an @Inject constructor or from an @Provides-annotated method." : "%s cannot be provided without an @Inject constructor or from an @Provides- or @Produces-annotated method.");
            }
            StringBuilder errorMessage = new StringBuilder(String.format(requiresErrorMessageFormat, BindingGraphValidator.this.formatCurrentDependencyRequestKey(path)));
            if (key.isValidMembersInjectionKey() && (membersInjectionBinding = BindingGraphValidator.this.injectBindingRegistry.getOrFindMembersInjectionBinding(key)).isPresent() && !((MembersInjectionBinding)membersInjectionBinding.get()).injectionSites().isEmpty()) {
                errorMessage.append(" ");
                errorMessage.append("This type supports members injection but cannot be implicitly provided.");
            }
            return errorMessage.append('\n');
        }

        private void reportMissingBinding(DependencyPath path) {
            StringBuilder errorMessage = this.requiresErrorMessageBase(path).append(BindingGraphValidator.this.dependencyRequestFormatter.toDependencyTrace(path));
            for (String suggestion : MissingBindingSuggestions.forKey(this.topLevelGraph(), path.currentDependencyRequest().bindingKey())) {
                errorMessage.append('\n').append(suggestion);
            }
            this.reportBuilder.addError(errorMessage.toString(), path.entryPointElement());
        }

        private void reportDependsOnProductionExecutor(DependencyPath path) {
            this.reportBuilder.addError(String.format("%s may not depend on the production executor.", BindingGraphValidator.this.formatCurrentDependencyRequestKey(path)), path.entryPointElement());
        }

        private void reportDuplicateBindings(DependencyPath path) {
            ResolvedBindings resolvedBindings = path.currentResolvedBindings();
            if (FluentIterable.from(resolvedBindings.contributionBindings()).transform(ContributionBinding.KIND).anyMatch(Predicates.or(ContributionBinding.Kind.IS_SYNTHETIC_MULTIBINDING_KIND, (Predicate)Predicates.equalTo((Object)((Object)ContributionBinding.Kind.SYNTHETIC_MAP))))) {
                this.reportMultipleContributionTypes(path);
                return;
            }
            StringBuilder builder = new StringBuilder();
            new Formatter(builder).format("%s is bound multiple times:", BindingGraphValidator.this.formatCurrentDependencyRequestKey(path));
            ResolvedBindings inlined = this.inlineContributionsWithoutBindingElements(resolvedBindings);
            ImmutableSet<ContributionBinding> duplicateBindings = inlined.contributionBindings();
            Sets.SetView conflictingDeclarations = Sets.union(duplicateBindings, inlined.subcomponentDeclarations());
            BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, conflictingDeclarations, 1, 10);
            this.owningReportBuilder((Iterable<ContributionBinding>)duplicateBindings).addError(builder.toString(), path.entryPointElement());
        }

        private ValidationReport.Builder<TypeElement> owningReportBuilder(Iterable<ContributionBinding> duplicateBindings) {
            ImmutableSet.Builder owningComponentsBuilder = ImmutableSet.builder();
            for (ContributionBinding binding : duplicateBindings) {
                ResolvedBindings resolvedBindings = (ResolvedBindings)this.subject.resolvedBindings().get((Object)BindingKey.contribution(binding.key()));
                owningComponentsBuilder.addAll((Iterable)resolvedBindings.allContributionBindings().inverse().get((Object)binding));
            }
            ImmutableSet owningComponents = owningComponentsBuilder.build();
            for (Validation validation : this.validationPath()) {
                if (!owningComponents.contains((Object)validation.subject.componentDescriptor())) continue;
                return validation.reportBuilder;
            }
            throw new AssertionError((Object)("cannot find owning component for duplicate bindings: " + duplicateBindings));
        }

        private ImmutableList<Validation> validationPath() {
            ImmutableList.Builder validationPath = ImmutableList.builder();
            Optional<Validation> validation = Optional.of((Object)this);
            while (validation.isPresent()) {
                validationPath.add(validation.get());
                validation = ((Validation)validation.get()).parent;
            }
            return validationPath.build().reverse();
        }

        private void reportMultipleContributionTypes(DependencyPath path) {
            StringBuilder builder = new StringBuilder();
            new Formatter(builder).format("%s has incompatible bindings or declarations:\n", BindingGraphValidator.this.formatCurrentDependencyRequestKey(path));
            ResolvedBindings resolvedBindings = path.currentResolvedBindings();
            ImmutableListMultimap<ContributionType, BindingDeclaration> declarationsByType = this.declarationsByType(resolvedBindings);
            Verify.verify((declarationsByType.keySet().size() > 1 ? 1 : 0) != 0, (String)"expected multiple contribution types for %s: %s", (Object[])new Object[]{resolvedBindings.bindingKey(), declarationsByType});
            for (ContributionType contributionType : Ordering.natural().immutableSortedCopy((Iterable)declarationsByType.keySet())) {
                builder.append("    ");
                builder.append(BindingGraphValidator.this.formatContributionType(contributionType));
                builder.append(" bindings and declarations:");
                BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, declarationsByType.get((Object)contributionType), 2, 10);
                builder.append('\n');
            }
            this.reportBuilder.addError(builder.toString(), path.entryPointElement());
        }

        private void reportDuplicateMapKeys(DependencyPath path, Collection<ContributionBinding> mapBindings) {
            StringBuilder builder = new StringBuilder();
            builder.append(ErrorMessages.duplicateMapKeysError(BindingGraphValidator.this.formatCurrentDependencyRequestKey(path)));
            BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, mapBindings, 1, 10);
            this.reportBuilder.addError(builder.toString(), path.entryPointElement());
        }

        private void reportInconsistentMapKeyAnnotations(DependencyPath path, Multimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> mapBindingsByAnnotationType) {
            StringBuilder builder = new StringBuilder(ErrorMessages.inconsistentMapKeyAnnotationsError(BindingGraphValidator.this.formatCurrentDependencyRequestKey(path)));
            for (Map.Entry entry : mapBindingsByAnnotationType.asMap().entrySet()) {
                DeclaredType annotationType = (DeclaredType)((Equivalence.Wrapper)entry.getKey()).get();
                Collection bindings = (Collection)entry.getValue();
                builder.append('\n').append("    ").append(annotationType).append(':');
                BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, bindings, 2, 10);
            }
            this.reportBuilder.addError(builder.toString(), path.entryPointElement());
        }

        private void reportCycle(DependencyPath path) {
            if (!this.providersBreakingCycle(path).isEmpty()) {
                return;
            }
            TypeElement componentType = MoreElements.asType(path.entryPointElement().getEnclosingElement());
            this.reportBuilder.addItem(String.format("%s.%s() contains a dependency cycle:\n%s", componentType.getQualifiedName(), path.entryPointElement().getSimpleName(), BindingGraphValidator.this.dependencyRequestFormatter.toDependencyTrace(path)), Diagnostic.Kind.ERROR, path.entryPointElement());
        }

        private ImmutableSet<DependencyRequest> providersBreakingCycle(DependencyPath path) {
            return path.cycle().skip(1).filter((Predicate)new Predicate<ResolvedRequest>(){

                public boolean apply(ResolvedRequest resolvedRequest) {
                    DependencyRequest dependencyRequest = resolvedRequest.dependencyRequest();
                    if (dependencyRequest.requestElement().isPresent()) {
                        return this.breaksCycle(dependencyRequest.key().type(), dependencyRequest.kind());
                    }
                    if (!resolvedRequest.dependentOptionalBindingDeclarations().isEmpty()) {
                        TypeMirror requestedOptionalType = ((ResolvedBindings)resolvedRequest.dependentBindings().get()).key().type();
                        DependencyRequest.KindAndType kindAndType = DependencyRequest.extractKindAndType(OptionalType.from(requestedOptionalType).valueType());
                        return this.breaksCycle(kindAndType.type(), kindAndType.kind());
                    }
                    return false;
                }

                private boolean breaksCycle(TypeMirror requestedType, DependencyRequest.Kind requestKind) {
                    switch (requestKind) {
                        case PROVIDER: 
                        case LAZY: 
                        case PROVIDER_OF_LAZY: {
                            return true;
                        }
                        case INSTANCE: {
                            return MapType.isMap(requestedType) && MapType.from(requestedType).valuesAreTypeOf(Provider.class);
                        }
                    }
                    return false;
                }
            }).transform(ResolvedRequest.DEPENDENCY_REQUEST).toSet();
        }
    }

    static final class DependencyPath {
        private final Deque<ResolvedRequest> path = new ArrayDeque<ResolvedRequest>();
        private final LinkedHashMultiset<BindingKey> keyPath = LinkedHashMultiset.create();
        private final Set<DependencyRequest> resolvedDependencyRequests = new HashSet<DependencyRequest>();

        DependencyPath() {
        }

        Element entryPointElement() {
            return (Element)this.path.getFirst().dependencyRequest().requestElement().get();
        }

        DependencyRequest currentDependencyRequest() {
            return this.path.getLast().dependencyRequest();
        }

        ResolvedBindings currentResolvedBindings() {
            return this.path.getLast().resolvedBindings();
        }

        ResolvedBindings previousResolvedBindings() {
            Preconditions.checkState((this.size() > 1 ? 1 : 0) != 0);
            return ((ResolvedRequest)Iterators.get(this.path.descendingIterator(), (int)1)).resolvedBindings();
        }

        boolean hasCycle() {
            return this.keyPath.count((Object)this.currentDependencyRequest().bindingKey()) > 1;
        }

        FluentIterable<ResolvedRequest> cycle() {
            Preconditions.checkState((boolean)this.hasCycle(), (Object)"no cycle");
            return this.resolvedRequests().skip(Iterables.indexOf(this.keyPath, (Predicate)Predicates.equalTo((Object)this.currentDependencyRequest().bindingKey())));
        }

        void push(DependencyRequest request, ResolvedBindings resolvedBindings) {
            this.path.add(ResolvedRequest.create(request, resolvedBindings, (Optional<ResolvedBindings>)(this.path.isEmpty() ? Optional.absent() : Optional.of((Object)this.currentResolvedBindings()))));
            this.keyPath.add((Object)request.bindingKey());
        }

        void pop() {
            Verify.verify((boolean)this.keyPath.remove((Object)this.path.removeLast().dependencyRequest().bindingKey()));
        }

        boolean visitCurrentDependencyRequest() {
            return this.resolvedDependencyRequests.add(this.currentDependencyRequest());
        }

        int size() {
            return this.path.size();
        }

        FluentIterable<ResolvedRequest> resolvedRequests() {
            return FluentIterable.from(this.path);
        }
    }
}

