/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AnnotationCreatorGenerator;
import dagger.internal.codegen.CodeBlocks;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;

class AnnotationExpression
extends SimpleAnnotationValueVisitor6<CodeBlock, AnnotationValue> {
    private final AnnotationMirror annotation;
    private final ClassName creatorClass;
    private static final SimpleTypeVisitor6<CodeBlock, CodeBlock> ARRAY_LITERAL_PREFIX = new SimpleTypeVisitor6<CodeBlock, CodeBlock>(){

        @Override
        public CodeBlock visitArray(ArrayType t, CodeBlock p) {
            return CodeBlock.of("new $T[] $L", RAW_TYPE_NAME.visit(t.getComponentType()), p);
        }

        @Override
        protected CodeBlock defaultAction(TypeMirror e, CodeBlock p) {
            return p;
        }
    };
    private static final SimpleTypeVisitor6<TypeName, Void> RAW_TYPE_NAME = new SimpleTypeVisitor6<TypeName, Void>(){

        @Override
        public TypeName visitDeclared(DeclaredType t, Void p) {
            return ClassName.get(MoreTypes.asTypeElement(t));
        }

        @Override
        protected TypeName defaultAction(TypeMirror e, Void p) {
            return TypeName.get(e);
        }
    };

    AnnotationExpression(AnnotationMirror annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationCreatorGenerator.getAnnotationCreatorClassName(MoreTypes.asTypeElement(annotation.getAnnotationType()));
    }

    CodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private CodeBlock getAnnotationInstanceExpression(AnnotationMirror annotation) {
        return CodeBlock.of("$T.$L($L)", this.creatorClass, AnnotationCreatorGenerator.createMethodName(MoreElements.asType(annotation.getAnnotationType().asElement())), CodeBlocks.makeParametersCodeBlock(Iterables.transform(AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).entrySet(), (Function)new Function<Map.Entry<ExecutableElement, AnnotationValue>, CodeBlock>(){

            public CodeBlock apply(Map.Entry<ExecutableElement, AnnotationValue> entry) {
                return AnnotationExpression.this.getValueExpression(entry.getKey().getReturnType(), entry.getValue());
            }
        })));
    }

    CodeBlock getValueExpression(TypeMirror valueType, AnnotationValue value) {
        return (CodeBlock)ARRAY_LITERAL_PREFIX.visit(valueType, (CodeBlock)this.visit(value, value));
    }

    @Override
    public CodeBlock visitEnumConstant(VariableElement c, AnnotationValue p) {
        return CodeBlock.of("$T.$L", TypeName.get(c.getEnclosingElement().asType()), c.getSimpleName());
    }

    @Override
    public CodeBlock visitAnnotation(AnnotationMirror a, AnnotationValue p) {
        return this.getAnnotationInstanceExpression(a);
    }

    @Override
    public CodeBlock visitType(TypeMirror t, AnnotationValue p) {
        return CodeBlock.of("$T.class", TypeName.get(t));
    }

    @Override
    public CodeBlock visitString(String s, AnnotationValue p) {
        return CodeBlock.of("$S", s);
    }

    @Override
    public CodeBlock visitByte(byte b, AnnotationValue p) {
        return CodeBlock.of("(byte) $L", b);
    }

    @Override
    public CodeBlock visitChar(char c, AnnotationValue p) {
        return CodeBlock.of("$L", p);
    }

    @Override
    public CodeBlock visitDouble(double d, AnnotationValue p) {
        return CodeBlock.of("$LD", d);
    }

    @Override
    public CodeBlock visitFloat(float f, AnnotationValue p) {
        return CodeBlock.of("$LF", Float.valueOf(f));
    }

    @Override
    public CodeBlock visitLong(long i, AnnotationValue p) {
        return CodeBlock.of("$LL", i);
    }

    @Override
    public CodeBlock visitShort(short s, AnnotationValue p) {
        return CodeBlock.of("(short) $L", s);
    }

    @Override
    protected CodeBlock defaultAction(Object o, AnnotationValue p) {
        return CodeBlock.of("$L", o);
    }

    @Override
    public CodeBlock visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (AnnotationValue annotationValue : values) {
            codeBlocks.add(this.visit(annotationValue, p));
        }
        return CodeBlock.of("{$L}", CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)codeBlocks.build()));
    }
}

