/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

final class SimpleMethodRequestRepresentation
extends RequestRepresentation {
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;
    private final ProvisionBinding provisionBinding;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final MembersInjectionMethods membersInjectionMethods;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final boolean isExperimentalMergedMode;

    @AssistedInject
    SimpleMethodRequestRepresentation(@Assisted ProvisionBinding binding, MembersInjectionMethods membersInjectionMethods, CompilerOptions compilerOptions, XProcessingEnv processingEnv, ComponentRequestRepresentations componentRequestRepresentations, ComponentRequirementExpressions componentRequirementExpressions, ComponentImplementation componentImplementation) {
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
        this.provisionBinding = binding;
        Preconditions.checkArgument((boolean)this.provisionBinding.implicitDependencies().isEmpty(), (Object)"framework deps are not currently supported");
        Preconditions.checkArgument((boolean)this.provisionBinding.bindingElement().isPresent());
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.membersInjectionMethods = membersInjectionMethods;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.isExperimentalMergedMode = componentImplementation.compilerMode().isExperimentalMergedMode();
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return InjectionMethods.ProvisionMethod.requiresInjectionMethod(this.provisionBinding, this.compilerOptions, requestingClass) ? this.invokeInjectionMethod(requestingClass) : this.invokeMethod(requestingClass);
    }

    private Expression invokeMethod(ClassName requestingClass) {
        CodeBlock invocation;
        CodeBlock arguments = CodeBlocks.makeParametersCodeBlock(InjectionMethods.ProvisionMethod.invokeArguments(this.provisionBinding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam));
        XElement bindingElement = this.provisionBinding.bindingElement().get();
        XTypeElement bindingTypeElement = this.provisionBinding.bindingTypeElement().get();
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            invocation = CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.constructorTypeName(requestingClass), arguments});
        } else if (XElementKt.isMethod((XElement)bindingElement)) {
            Optional<CodeBlock> requiredModuleInstance = this.moduleReference(requestingClass);
            CodeBlock module = requiredModuleInstance.isPresent() ? requiredModuleInstance.get() : (bindingTypeElement.isKotlinObject() && !bindingTypeElement.isCompanionObject() ? CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{bindingTypeElement.getClassName()}) : CodeBlock.of((String)"$T", (Object[])new Object[]{bindingTypeElement.getClassName()}));
            invocation = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{module, XElements.asMethod(bindingElement).getJvmName(), arguments});
        } else {
            throw new AssertionError((Object)("Unexpected binding element: " + bindingElement));
        }
        return Expression.create(this.simpleMethodReturnType(), invocation);
    }

    private TypeName constructorTypeName(ClassName requestingClass) {
        XType type = this.provisionBinding.key().type().xprocessing();
        return type.getTypeArguments().stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, requestingClass.packageName())) ? type.getTypeName() : TypeNames.rawTypeName(type.getTypeName());
    }

    private Expression invokeInjectionMethod(ClassName requestingClass) {
        return this.injectMembers(InjectionMethods.ProvisionMethod.invoke(this.provisionBinding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam, requestingClass, this.moduleReference(requestingClass), this.compilerOptions), requestingClass);
    }

    private Expression dependencyArgument(DependencyRequest dependency, ClassName requestingClass) {
        return this.isExperimentalMergedMode ? this.componentRequestRepresentations.getExperimentalSwitchingProviderDependencyRepresentation(BindingRequest.bindingRequest(dependency)).getDependencyExpression(dependency.kind(), this.provisionBinding) : this.componentRequestRepresentations.getDependencyArgumentExpression(dependency, requestingClass);
    }

    private Expression injectMembers(CodeBlock instance, ClassName requestingClass) {
        if (this.provisionBinding.injectionSites().isEmpty()) {
            return Expression.create(this.simpleMethodReturnType(), instance);
        }
        if (XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && !this.provisionBinding.key().type().xprocessing().getTypeArguments().isEmpty()) {
            TypeName keyType = this.provisionBinding.key().type().xprocessing().getTypeName();
            instance = CodeBlock.of((String)"($T) ($T) $L", (Object[])new Object[]{keyType, TypeNames.rawTypeName(keyType), instance});
        }
        return this.isExperimentalMergedMode ? this.membersInjectionMethods.getInjectExpressionExperimental(this.provisionBinding, instance, requestingClass) : this.membersInjectionMethods.getInjectExpression(this.provisionBinding.key(), instance, requestingClass);
    }

    private Optional<CodeBlock> moduleReference(ClassName requestingClass) {
        return this.provisionBinding.requiresModuleInstance() ? this.provisionBinding.contributingModule().map(XTypeElement::getType).map(ComponentRequirement::forModule).map(module -> this.isExperimentalMergedMode ? CodeBlock.of((String)"(($T) dependencies[0])", (Object[])new Object[]{module.type().getTypeName()}) : this.componentRequirementExpressions.getExpression((ComponentRequirement)module, requestingClass)) : Optional.empty();
    }

    private XType simpleMethodReturnType() {
        return this.provisionBinding.contributedPrimitiveType().orElse(this.provisionBinding.key().type().xprocessing());
    }

    @AssistedFactory
    static interface Factory {
        public SimpleMethodRequestRepresentation create(ProvisionBinding var1);
    }
}

