/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.writing.ComponentImplementation;

enum FrameworkInstanceKind {
    SWITCHING_PROVIDER,
    EXPERIMENTAL_SWITCHING_PROVIDER,
    STATIC_FACTORY,
    PROVIDER_FIELD;


    public static FrameworkInstanceKind from(ContributionBinding binding, ComponentImplementation.CompilerMode compilerMode) {
        if (FrameworkInstanceKind.usesSwitchingProvider(binding, compilerMode)) {
            if (compilerMode.isExperimentalMergedMode()) {
                return EXPERIMENTAL_SWITCHING_PROVIDER;
            }
            if (compilerMode.isFastInit()) {
                return SWITCHING_PROVIDER;
            }
            throw new IllegalStateException("Compiler mode " + (Object)((Object)compilerMode) + " cannot use Switching Provider.");
        }
        if (FrameworkInstanceKind.usesStaticFactoryCreation(binding, compilerMode)) {
            return STATIC_FACTORY;
        }
        return PROVIDER_FIELD;
    }

    private static boolean usesSwitchingProvider(ContributionBinding binding, ComponentImplementation.CompilerMode compilerMode) {
        if (!compilerMode.isFastInit() && !compilerMode.isExperimentalMergedMode()) {
            return false;
        }
        if (compilerMode.isExperimentalMergedMode() && binding.kind().equals((Object)BindingKind.ASSISTED_FACTORY)) {
            return false;
        }
        switch (binding.kind()) {
            case ASSISTED_INJECTION: 
            case BOUND_INSTANCE: 
            case COMPONENT: 
            case COMPONENT_DEPENDENCY: 
            case DELEGATE: 
            case MEMBERS_INJECTOR: {
                return false;
            }
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: 
            case OPTIONAL: {
                return !binding.dependencies().isEmpty();
            }
            case INJECTION: 
            case PROVISION: 
            case ASSISTED_FACTORY: 
            case COMPONENT_PROVISION: 
            case SUBCOMPONENT_CREATOR: 
            case PRODUCTION: 
            case COMPONENT_PRODUCTION: 
            case MEMBERS_INJECTION: {
                return true;
            }
        }
        throw new AssertionError((Object)String.format("No such binding kind: %s", new Object[]{binding.kind()}));
    }

    private static boolean usesStaticFactoryCreation(ContributionBinding binding, ComponentImplementation.CompilerMode compilerMode) {
        if (!binding.dependencies().isEmpty() || binding.scope().isPresent()) {
            return false;
        }
        switch (binding.kind()) {
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: {
                return true;
            }
            case PROVISION: {
                return !compilerMode.isFastInit() && !compilerMode.isExperimentalMergedMode() && !binding.requiresModuleInstance();
            }
            case INJECTION: {
                return !compilerMode.isFastInit() && !compilerMode.isExperimentalMergedMode();
            }
        }
        return false;
    }
}

