/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentProvisionRequestRepresentation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.SubcomponentCreatorRequestRepresentation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;

final class ExperimentalSwitchingProviders {
    private static final int MAX_CASES_PER_SWITCH = 100;
    private static final long MAX_CASES_PER_CLASS = 10000L;
    private static final TypeVariableName T = TypeVariableName.get((String)"T");
    private final Map<Key, SwitchingProviderBuilder> switchingProviderBuilders = new LinkedHashMap<Key, SwitchingProviderBuilder>();
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final Provider<ComponentRequestRepresentations> componentRequestRepresentationsProvider;

    ExperimentalSwitchingProviders(ComponentImplementation.ShardImplementation shardImplementation, Provider<ComponentRequestRepresentations> componentRequestRepresentationsProvider) {
        this.shardImplementation = (ComponentImplementation.ShardImplementation)Preconditions.checkNotNull((Object)shardImplementation);
        this.componentRequestRepresentationsProvider = (Provider)Preconditions.checkNotNull(componentRequestRepresentationsProvider);
    }

    FrameworkFieldInitializer.FrameworkInstanceCreationExpression newFrameworkInstanceCreationExpression(final ProvisionBinding binding, final RequestRepresentation unscopedInstanceRequestRepresentation) {
        return new FrameworkFieldInitializer.FrameworkInstanceCreationExpression(){

            @Override
            public CodeBlock creationExpression() {
                return ExperimentalSwitchingProviders.this.switchingProviderBuilders.computeIfAbsent(binding.key(), key -> ExperimentalSwitchingProviders.this.getSwitchingProviderBuilder()).getNewInstanceCodeBlock(binding, unscopedInstanceRequestRepresentation);
            }
        };
    }

    private SwitchingProviderBuilder getSwitchingProviderBuilder() {
        if ((long)this.switchingProviderBuilders.size() % 10000L == 0L) {
            String name = this.shardImplementation.getUniqueClassName("SwitchingProvider");
            SwitchingProviderBuilder switchingProviderBuilder = new SwitchingProviderBuilder(this.shardImplementation.name().nestedClass(name));
            this.shardImplementation.addTypeSupplier((Supplier<TypeSpec>)((Supplier)() -> switchingProviderBuilder.build()));
            return switchingProviderBuilder;
        }
        return (SwitchingProviderBuilder)Iterables.getLast(this.switchingProviderBuilders.values());
    }

    private final class SwitchingProviderBuilder {
        private final Map<Integer, CodeBlock> switchCases = new TreeMap<Integer, CodeBlock>();
        private final Map<Key, Integer> switchIds = new HashMap<Key, Integer>();
        private final ClassName switchingProviderType;

        SwitchingProviderBuilder(ClassName switchingProviderType) {
            this.switchingProviderType = (ClassName)Preconditions.checkNotNull((Object)switchingProviderType);
        }

        private CodeBlock getNewInstanceCodeBlock(ProvisionBinding binding, RequestRepresentation unscopedInstanceRequestRepresentation) {
            CodeBlock switchingProviderDependencies;
            Key key = binding.key();
            if (!this.switchIds.containsKey(key)) {
                int switchId = this.switchIds.size();
                this.switchIds.put(key, switchId);
                this.switchCases.put(switchId, this.createSwitchCaseCodeBlock(key, unscopedInstanceRequestRepresentation));
            }
            switch (binding.kind()) {
                case COMPONENT_PROVISION: {
                    switchingProviderDependencies = ((ComponentProvisionRequestRepresentation)unscopedInstanceRequestRepresentation).getComponentRequirementExpression(ExperimentalSwitchingProviders.this.shardImplementation.name());
                    break;
                }
                case SUBCOMPONENT_CREATOR: {
                    switchingProviderDependencies = ((SubcomponentCreatorRequestRepresentation)unscopedInstanceRequestRepresentation).getDependencyExpressionArguments();
                    break;
                }
                case MULTIBOUND_SET: 
                case MULTIBOUND_MAP: 
                case OPTIONAL: 
                case INJECTION: 
                case PROVISION: 
                case ASSISTED_FACTORY: {
                    switchingProviderDependencies = ((ComponentRequestRepresentations)ExperimentalSwitchingProviders.this.componentRequestRepresentationsProvider.get()).getCreateMethodArgumentsCodeBlock(binding, ExperimentalSwitchingProviders.this.shardImplementation.name());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected binding kind: " + (Object)((Object)binding.kind()));
                }
            }
            return CodeBlock.of((String)"new $T<$L>($L)", (Object[])new Object[]{this.switchingProviderType, CodeBlock.of((String)"$T", (Object[])new Object[]{ExperimentalSwitchingProviders.this.shardImplementation.accessibleTypeName(binding.contributedType())}), switchingProviderDependencies.isEmpty() ? CodeBlock.of((String)"$L", (Object[])new Object[]{this.switchIds.get(key)}) : CodeBlock.of((String)"$L, $L", (Object[])new Object[]{this.switchIds.get(key), switchingProviderDependencies})});
        }

        private CodeBlock createSwitchCaseCodeBlock(Key key, RequestRepresentation unscopedInstanceRequestRepresentation) {
            CodeBlock instanceCodeBlock = unscopedInstanceRequestRepresentation.getDependencyExpression(this.switchingProviderType).box().codeBlock();
            return CodeBlock.builder().add("case $L: // $L \n", new Object[]{this.switchIds.get(key), key}).addStatement("return ($T) $L", new Object[]{T, instanceCodeBlock}).build();
        }

        private TypeSpec build() {
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.switchingProviderType).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).addTypeVariable(T).addSuperinterface((TypeName)TypeNames.providerOf((TypeName)T)).addMethods(this.getMethods());
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
            builder.addField(TypeName.INT, "id", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.addParameter(TypeName.INT, "id", new Modifier[0]).addStatement("this.id = id", new Object[0]);
            builder.addField(Object[].class, "dependencies", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
            constructor.addParameter(Object[].class, "dependencies", new Modifier[0]).addStatement("this.dependencies = dependencies", new Object[0]).varargs(true);
            return builder.addMethod(constructor.build()).build();
        }

        private ImmutableList<MethodSpec> getMethods() {
            ImmutableList<CodeBlock> switchCodeBlockPartitions = this.switchCodeBlockPartitions();
            if (switchCodeBlockPartitions.size() == 1) {
                return ImmutableList.of((Object)MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addAnnotation(Override.class).returns((TypeName)T).addCode((CodeBlock)Iterables.getOnlyElement(switchCodeBlockPartitions)).build());
            }
            MethodSpec.Builder routerMethod = MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)T).beginControlFlow("switch (id / $L)", new Object[]{100});
            ImmutableList.Builder getMethods = ImmutableList.builder();
            for (int i = 0; i < switchCodeBlockPartitions.size(); ++i) {
                MethodSpec method = MethodSpec.methodBuilder((String)("get" + i)).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).returns((TypeName)T).addCode((CodeBlock)switchCodeBlockPartitions.get(i)).build();
                getMethods.add((Object)method);
                routerMethod.addStatement("case $L: return $N()", new Object[]{i, method});
            }
            routerMethod.addStatement("default: throw new $T(id)", new Object[]{AssertionError.class}).endControlFlow();
            return getMethods.add((Object)routerMethod.build()).build();
        }

        private ImmutableList<CodeBlock> switchCodeBlockPartitions() {
            return (ImmutableList)Lists.partition((List)ImmutableList.copyOf(this.switchCases.values()), (int)100).stream().map(partitionCases -> CodeBlock.builder().beginControlFlow("switch (id)", new Object[0]).add(CodeBlocks.concat(partitionCases)).addStatement("default: throw new $T(id)", new Object[]{AssertionError.class}).endControlFlow().build()).collect(DaggerStreams.toImmutableList());
        }
    }
}

