/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_BindingGraphImpl;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_BindingNodeImpl;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_ComponentNodeImpl;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_DependencyEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_MissingBindingImpl;
import dagger.internal.codegen.validation.AutoValue_ExternalBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.spi.DiagnosticReporter;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.Key;
import dagger.spi.model.Scope;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class ExternalBindingGraphConverter {
    private ExternalBindingGraphConverter() {
    }

    public static DiagnosticReporter fromSpiModel(dagger.spi.model.DiagnosticReporter reporter) {
        return DiagnosticReporterImpl.create(reporter);
    }

    public static dagger.model.BindingGraph fromSpiModel(BindingGraph graph) {
        return BindingGraphImpl.create(graph);
    }

    private static ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> fromSpiModel(Network<BindingGraph.Node, BindingGraph.Edge> spiNetwork) {
        MutableNetwork network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        ImmutableMap fromSpiNodes = (ImmutableMap)spiNetwork.nodes().stream().collect(DaggerStreams.toImmutableMap(spiNode -> spiNode, ExternalBindingGraphConverter::fromSpiModel));
        for (BindingGraph.Node node : fromSpiNodes.values()) {
            network.addNode((Object)node);
        }
        for (BindingGraph.Edge edge : spiNetwork.edges()) {
            EndpointPair edgePair = spiNetwork.incidentNodes((Object)edge);
            network.addEdge((Object)((BindingGraph.Node)fromSpiNodes.get(edgePair.source())), (Object)((BindingGraph.Node)fromSpiNodes.get(edgePair.target())), (Object)ExternalBindingGraphConverter.fromSpiModel(edge));
        }
        return ImmutableNetwork.copyOf((Network)network);
    }

    private static BindingGraph.Node fromSpiModel(BindingGraph.Node node) {
        if (node instanceof Binding) {
            return BindingNodeImpl.create((Binding)node);
        }
        if (node instanceof BindingGraph.ComponentNode) {
            return ComponentNodeImpl.create((BindingGraph.ComponentNode)node);
        }
        if (node instanceof BindingGraph.MissingBinding) {
            return MissingBindingImpl.create((BindingGraph.MissingBinding)node);
        }
        throw new IllegalStateException("Unhandled node type: " + node.getClass());
    }

    private static BindingGraph.Edge fromSpiModel(BindingGraph.Edge edge) {
        if (edge instanceof BindingGraph.DependencyEdge) {
            return DependencyEdgeImpl.create((BindingGraph.DependencyEdge)edge);
        }
        if (edge instanceof BindingGraph.ChildFactoryMethodEdge) {
            return ChildFactoryMethodEdgeImpl.create((BindingGraph.ChildFactoryMethodEdge)edge);
        }
        if (edge instanceof BindingGraph.SubcomponentCreatorBindingEdge) {
            return SubcomponentCreatorBindingEdgeImpl.create((BindingGraph.SubcomponentCreatorBindingEdge)edge);
        }
        throw new IllegalStateException("Unhandled edge type: " + edge.getClass());
    }

    private static Key.MultibindingContributionIdentifier fromSpiModel(Key.MultibindingContributionIdentifier identifier) {
        return new Key.MultibindingContributionIdentifier(identifier.bindingMethod(), identifier.contributingModule());
    }

    private static dagger.model.Key fromSpiModel(Key key) {
        return dagger.model.Key.builder((TypeMirror)key.type().java()).qualifier(key.qualifier().map(DaggerAnnotation::java)).multibindingContributionIdentifier(key.multibindingContributionIdentifier().isPresent() ? Optional.of(ExternalBindingGraphConverter.fromSpiModel((Key.MultibindingContributionIdentifier)key.multibindingContributionIdentifier().get())) : Optional.empty()).build();
    }

    private static BindingKind fromSpiModel(dagger.spi.model.BindingKind bindingKind) {
        return BindingKind.valueOf((String)bindingKind.name());
    }

    private static RequestKind fromSpiModel(dagger.spi.model.RequestKind requestKind) {
        return RequestKind.valueOf((String)requestKind.name());
    }

    private static DependencyRequest fromSpiModel(dagger.spi.model.DependencyRequest request) {
        DependencyRequest.Builder builder = DependencyRequest.builder().kind(ExternalBindingGraphConverter.fromSpiModel(request.kind())).key(ExternalBindingGraphConverter.fromSpiModel(request.key())).isNullable(request.isNullable());
        request.requestElement().ifPresent(e -> builder.requestElement(e.java()));
        return builder.build();
    }

    private static dagger.model.Scope fromSpiModel(Scope scope) {
        return dagger.model.Scope.scope((AnnotationMirror)scope.scopeAnnotation().java());
    }

    private static dagger.model.ComponentPath fromSpiModel(ComponentPath path) {
        return dagger.model.ComponentPath.create((Iterable)((Iterable)path.components().stream().map(DaggerTypeElement::java).collect(DaggerStreams.toImmutableList())));
    }

    private static BindingGraph.ComponentNode toSpiModel(BindingGraph.ComponentNode componentNode) {
        return ((ComponentNodeImpl)componentNode).spiDelegate();
    }

    private static BindingGraph.MaybeBinding toSpiModel(BindingGraph.MaybeBinding maybeBinding) {
        if (maybeBinding instanceof MissingBindingImpl) {
            return ((MissingBindingImpl)maybeBinding).spiDelegate();
        }
        if (maybeBinding instanceof BindingNodeImpl) {
            return ((BindingNodeImpl)maybeBinding).spiDelegate();
        }
        throw new IllegalStateException("Unhandled binding type: " + maybeBinding.getClass());
    }

    private static BindingGraph.DependencyEdge toSpiModel(BindingGraph.DependencyEdge dependencyEdge) {
        return ((DependencyEdgeImpl)dependencyEdge).spiDelegate();
    }

    private static BindingGraph.ChildFactoryMethodEdge toSpiModel(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge) {
        return ((ChildFactoryMethodEdgeImpl)childFactoryMethodEdge).spiDelegate();
    }

    private static final class DiagnosticReporterImpl
    implements DiagnosticReporter {
        private final dagger.spi.model.DiagnosticReporter delegate;

        static DiagnosticReporterImpl create(dagger.spi.model.DiagnosticReporter reporter) {
            return new DiagnosticReporterImpl(reporter);
        }

        DiagnosticReporterImpl(dagger.spi.model.DiagnosticReporter delegate) {
            this.delegate = delegate;
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String message) {
            this.delegate.reportComponent(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(componentNode), message);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportComponent(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(componentNode), messageFormat, firstArg, moreArgs);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.delegate.reportBinding(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(binding), message);
        }

        @FormatMethod
        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportBinding(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(binding), messageFormat, firstArg, moreArgs);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.delegate.reportDependency(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(dependencyEdge), message);
        }

        @FormatMethod
        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportDependency(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(dependencyEdge), messageFormat, firstArg, moreArgs);
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(childFactoryMethodEdge), message);
        }

        @FormatMethod
        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, ExternalBindingGraphConverter.toSpiModel(childFactoryMethodEdge), messageFormat, firstArg, moreArgs);
        }
    }

    @AutoValue
    static abstract class BindingGraphImpl
    extends dagger.model.BindingGraph {
        private ImmutableMap<dagger.model.ComponentPath, BindingGraph.ComponentNode> componentNodesByPath;

        BindingGraphImpl() {
        }

        static dagger.model.BindingGraph create(BindingGraph bindingGraph) {
            AutoValue_ExternalBindingGraphConverter_BindingGraphImpl bindingGraphImpl = new AutoValue_ExternalBindingGraphConverter_BindingGraphImpl((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)ExternalBindingGraphConverter.fromSpiModel((Network<BindingGraph.Node, BindingGraph.Edge>)((Network)bindingGraph.network())), bindingGraph.isFullBindingGraph());
            bindingGraphImpl.componentNodesByPath = (ImmutableMap)bindingGraphImpl.componentNodes().stream().collect(DaggerStreams.toImmutableMap(BindingGraph.ComponentNode::componentPath, node -> node));
            return bindingGraphImpl;
        }

        public Optional<BindingGraph.ComponentNode> componentNode(dagger.model.ComponentPath componentPath) {
            return this.componentNodesByPath.containsKey((Object)componentPath) ? Optional.of((BindingGraph.ComponentNode)this.componentNodesByPath.get((Object)componentPath)) : Optional.empty();
        }

        @Memoized
        public ImmutableSetMultimap<Class<? extends BindingGraph.Node>, ? extends BindingGraph.Node> nodesByClass() {
            return super.nodesByClass();
        }
    }

    @AutoValue
    static abstract class SubcomponentCreatorBindingEdgeImpl
    implements BindingGraph.SubcomponentCreatorBindingEdge {
        SubcomponentCreatorBindingEdgeImpl() {
        }

        static BindingGraph.SubcomponentCreatorBindingEdge create(BindingGraph.SubcomponentCreatorBindingEdge subcomponentCreatorBindingEdge) {
            return new AutoValue_ExternalBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl((ImmutableSet<TypeElement>)((ImmutableSet)subcomponentCreatorBindingEdge.declaringModules().stream().map(DaggerTypeElement::java).collect(DaggerStreams.toImmutableSet())), subcomponentCreatorBindingEdge);
        }

        abstract BindingGraph.SubcomponentCreatorBindingEdge spiDelegate();

        public final String toString() {
            return this.spiDelegate().toString();
        }
    }

    @AutoValue
    static abstract class ChildFactoryMethodEdgeImpl
    implements BindingGraph.ChildFactoryMethodEdge {
        ChildFactoryMethodEdgeImpl() {
        }

        static BindingGraph.ChildFactoryMethodEdge create(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge) {
            return new AutoValue_ExternalBindingGraphConverter_ChildFactoryMethodEdgeImpl(childFactoryMethodEdge.factoryMethod().java(), childFactoryMethodEdge);
        }

        abstract BindingGraph.ChildFactoryMethodEdge spiDelegate();

        public final String toString() {
            return this.spiDelegate().toString();
        }
    }

    @AutoValue
    static abstract class DependencyEdgeImpl
    implements BindingGraph.DependencyEdge {
        DependencyEdgeImpl() {
        }

        static BindingGraph.DependencyEdge create(BindingGraph.DependencyEdge dependencyEdge) {
            return new AutoValue_ExternalBindingGraphConverter_DependencyEdgeImpl(ExternalBindingGraphConverter.fromSpiModel(dependencyEdge.dependencyRequest()), dependencyEdge.isEntryPoint(), dependencyEdge);
        }

        abstract BindingGraph.DependencyEdge spiDelegate();

        public final String toString() {
            return this.spiDelegate().toString();
        }
    }

    @AutoValue
    static abstract class MissingBindingImpl
    extends BindingGraph.MissingBinding {
        MissingBindingImpl() {
        }

        static BindingGraph.MissingBinding create(BindingGraph.MissingBinding missingBinding) {
            return new AutoValue_ExternalBindingGraphConverter_MissingBindingImpl(ExternalBindingGraphConverter.fromSpiModel(missingBinding.componentPath()), ExternalBindingGraphConverter.fromSpiModel(missingBinding.key()), missingBinding);
        }

        abstract BindingGraph.MissingBinding spiDelegate();

        @Memoized
        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    @AutoValue
    static abstract class BindingNodeImpl
    implements dagger.model.Binding {
        BindingNodeImpl() {
        }

        static dagger.model.Binding create(Binding binding) {
            return new AutoValue_ExternalBindingGraphConverter_BindingNodeImpl(ExternalBindingGraphConverter.fromSpiModel(binding.key()), ExternalBindingGraphConverter.fromSpiModel(binding.componentPath()), (ImmutableSet<DependencyRequest>)((ImmutableSet)binding.dependencies().stream().map(x$0 -> ExternalBindingGraphConverter.fromSpiModel(x$0)).collect(DaggerStreams.toImmutableSet())), binding.bindingElement().map(DaggerElement::java), binding.contributingModule().map(DaggerTypeElement::java), binding.requiresModuleInstance(), binding.scope().map(x$0 -> ExternalBindingGraphConverter.fromSpiModel(x$0)), binding.isNullable(), binding.isProduction(), ExternalBindingGraphConverter.fromSpiModel(binding.kind()), binding);
        }

        abstract Binding spiDelegate();

        public final String toString() {
            return this.spiDelegate().toString();
        }
    }

    @AutoValue
    static abstract class ComponentNodeImpl
    implements BindingGraph.ComponentNode {
        ComponentNodeImpl() {
        }

        static BindingGraph.ComponentNode create(BindingGraph.ComponentNode componentNode) {
            return new AutoValue_ExternalBindingGraphConverter_ComponentNodeImpl(ExternalBindingGraphConverter.fromSpiModel(componentNode.componentPath()), componentNode.isSubcomponent(), componentNode.isRealComponent(), (ImmutableSet<DependencyRequest>)((ImmutableSet)componentNode.entryPoints().stream().map(x$0 -> ExternalBindingGraphConverter.fromSpiModel(x$0)).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<dagger.model.Scope>)((ImmutableSet)componentNode.scopes().stream().map(x$0 -> ExternalBindingGraphConverter.fromSpiModel(x$0)).collect(DaggerStreams.toImmutableSet())), componentNode);
        }

        abstract BindingGraph.ComponentNode spiDelegate();

        public final String toString() {
            return this.spiDelegate().toString();
        }
    }
}

