/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class InjectionAnnotations {
    private final XProcessingEnv processingEnv;
    private final KotlinMetadataUtil kotlinMetadataUtil;
    private final DaggerSuperficialValidation superficialValidation;
    private final CompilerOptions compilerOptions;

    @Inject
    InjectionAnnotations(XProcessingEnv processingEnv, KotlinMetadataUtil kotlinMetadataUtil, DaggerSuperficialValidation superficialValidation, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.kotlinMetadataUtil = kotlinMetadataUtil;
        this.superficialValidation = superficialValidation;
        this.compilerOptions = compilerOptions;
    }

    public Optional<Scope> getScope(XElement element) {
        return (Optional)this.getScopes(element).stream().collect(DaggerCollectors.toOptional());
    }

    public ImmutableSet<Scope> getScopes(XElement element) {
        this.superficialValidation.validateTypeOf(element);
        ImmutableSet scopes = this.getScopesFromScopeMetadata(element).orElseGet(() -> {
            this.superficialValidation.validateAnnotationTypesOf(element);
            return (ImmutableSet)element.getAllAnnotations().stream().filter(InjectionAnnotations::hasScopeAnnotation).map(DaggerAnnotation::from).map(Scope::scope).collect(DaggerStreams.toImmutableSet());
        });
        scopes.stream().map(scope -> scope.scopeAnnotation().xprocessing()).forEach(scope -> this.superficialValidation.validateAnnotationOf(element, (XAnnotation)scope));
        return scopes;
    }

    private Optional<ImmutableSet<Scope>> getScopesFromScopeMetadata(XElement element) {
        Optional<XAnnotation> scopeMetadata = this.getScopeMetadata(element);
        if (!scopeMetadata.isPresent()) {
            return Optional.empty();
        }
        String scopeName = scopeMetadata.get().getAsString("value");
        if (scopeName.isEmpty()) {
            return Optional.of(ImmutableSet.of());
        }
        XAnnotation scopeAnnotation = (XAnnotation)element.getAllAnnotations().stream().filter(annotation -> scopeName.contentEquals(annotation.getType().getTypeElement().getQualifiedName())).collect(DaggerCollectors.onlyElement());
        this.superficialValidation.validateAnnotationTypeOf(element, scopeAnnotation);
        if (this.compilerOptions.strictSuperficialValidation()) {
            return Optional.of(ImmutableSet.of((Object)Scope.scope((DaggerAnnotation)DaggerAnnotation.from((XAnnotation)scopeAnnotation))));
        }
        return Scope.isScope((DaggerAnnotation)DaggerAnnotation.from((XAnnotation)scopeAnnotation)) ? Optional.of(ImmutableSet.of((Object)Scope.scope((DaggerAnnotation)DaggerAnnotation.from((XAnnotation)scopeAnnotation)))) : Optional.empty();
    }

    private Optional<XAnnotation> getScopeMetadata(XElement element) {
        return this.getGeneratedNameForScopeMetadata(element).flatMap(factoryName -> Optional.ofNullable(this.processingEnv.findTypeElement((TypeName)factoryName))).flatMap(factory -> Optional.ofNullable(factory.getAnnotation(TypeNames.SCOPE_METADATA)));
    }

    private Optional<ClassName> getGeneratedNameForScopeMetadata(XElement element) {
        if (XElementKt.isTypeElement((XElement)element)) {
            return XElements.asTypeElement((XElement)element).getConstructors().stream().filter(InjectionAnnotations::hasInjectOrAssistedInjectAnnotation).findFirst().map(SourceFiles::factoryNameForElement);
        }
        if (XElementKt.isMethod((XElement)element) && element.hasAnnotation(TypeNames.PROVIDES)) {
            return Optional.of(SourceFiles.factoryNameForElement((XExecutableElement)XElements.asMethod((XElement)element)));
        }
        return Optional.empty();
    }

    public Optional<XAnnotation> getQualifier(XElement element) {
        Preconditions.checkNotNull((Object)element);
        ImmutableSet<XAnnotation> qualifierAnnotations = this.getQualifiers(element);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((XAnnotation)Iterables.getOnlyElement(qualifierAnnotations));
            }
        }
        throw new IllegalArgumentException(element + " was annotated with more than one @Qualifier annotation");
    }

    public ImmutableSet<XAnnotation> getQualifiers(XElement element) {
        XFieldElement field;
        this.superficialValidation.validateTypeOf(element);
        ImmutableSet qualifiers = this.getQualifiersFromQualifierMetadata(element).orElseGet(() -> {
            this.superficialValidation.validateAnnotationTypesOf(element);
            return (ImmutableSet)element.getAllAnnotations().stream().filter(InjectionAnnotations::hasQualifierAnnotation).collect(DaggerStreams.toImmutableSet());
        });
        if (XElementKt.isField((XElement)element) && !(field = XElements.asField((XElement)element)).isStatic() && XElementKt.isTypeElement((XElement)field.getEnclosingElement()) && InjectionAnnotations.hasInjectAnnotation((XElement)field) && this.kotlinMetadataUtil.hasMetadata((XElement)field)) {
            qualifiers = (ImmutableSet)Stream.concat(qualifiers.stream(), this.getQualifiersForKotlinProperty(field).stream()).map(DaggerAnnotation::from).distinct().map(DaggerAnnotation::xprocessing).collect(DaggerStreams.toImmutableSet());
        }
        qualifiers.forEach(qualifier -> this.superficialValidation.validateAnnotationOf(element, (XAnnotation)qualifier));
        return qualifiers;
    }

    private Optional<ImmutableSet<XAnnotation>> getQualifiersFromQualifierMetadata(XElement element) {
        Optional<XAnnotation> qualifierMetadata = this.getQualifierMetadata(element);
        if (!qualifierMetadata.isPresent()) {
            return Optional.empty();
        }
        ImmutableSet qualifierNames = ImmutableSet.copyOf((Collection)qualifierMetadata.get().getAsStringList("value"));
        if (qualifierNames.isEmpty()) {
            return Optional.of(ImmutableSet.of());
        }
        ImmutableSet qualifierAnnotations = (ImmutableSet)element.getAllAnnotations().stream().filter(annotation -> qualifierNames.contains((Object)annotation.getType().getTypeElement().getQualifiedName())).collect(DaggerStreams.toImmutableSet());
        if (qualifierAnnotations.isEmpty()) {
            return Optional.of(ImmutableSet.of());
        }
        XAnnotation qualifierAnnotation = (XAnnotation)Iterables.getOnlyElement((Iterable)qualifierAnnotations);
        this.superficialValidation.validateAnnotationTypeOf(element, qualifierAnnotation);
        if (this.compilerOptions.strictSuperficialValidation()) {
            return Optional.of(ImmutableSet.of((Object)qualifierAnnotation));
        }
        return InjectionAnnotations.hasQualifierAnnotation(qualifierAnnotation) ? Optional.of(ImmutableSet.of((Object)qualifierAnnotation)) : Optional.empty();
    }

    private Optional<XAnnotation> getQualifierMetadata(XElement element) {
        return this.getGeneratedNameForQualifierMetadata(element).flatMap(name -> Optional.ofNullable(this.processingEnv.findTypeElement((TypeName)name))).flatMap(type -> Optional.ofNullable(type.getAnnotation(TypeNames.QUALIFIER_METADATA)));
    }

    private Optional<ClassName> getGeneratedNameForQualifierMetadata(XElement element) {
        if (XElementKt.isField((XElement)element) && InjectionAnnotations.hasInjectAnnotation(element)) {
            return Optional.of(SourceFiles.membersInjectorNameForType(XElements.closestEnclosingTypeElement((XElement)element)));
        }
        if (XElementKt.isMethod((XElement)element) && element.hasAnnotation(TypeNames.PROVIDES)) {
            return Optional.of(SourceFiles.factoryNameForElement((XExecutableElement)XElements.asMethod((XElement)element)));
        }
        if (XElementKt.isMethodParameter((XElement)element)) {
            XExecutableElement executableElement = XElements.asMethodParameter((XElement)element).getEnclosingElement();
            if (XElementKt.isConstructor((XElement)executableElement) && InjectionAnnotations.hasInjectOrAssistedInjectAnnotation((XElement)executableElement)) {
                return Optional.of(SourceFiles.factoryNameForElement(executableElement));
            }
            if (XElementKt.isMethod((XElement)executableElement) && InjectionAnnotations.hasInjectAnnotation((XElement)executableElement)) {
                return Optional.of(SourceFiles.membersInjectorNameForType(XElements.closestEnclosingTypeElement((XElement)element)));
            }
            if (XElementKt.isMethod((XElement)executableElement) && executableElement.hasAnnotation(TypeNames.PROVIDES)) {
                return Optional.of(SourceFiles.factoryNameForElement(executableElement));
            }
        }
        return Optional.empty();
    }

    public static ImmutableSet<XConstructorElement> injectedConstructors(XTypeElement type) {
        return (ImmutableSet)type.getConstructors().stream().filter(InjectionAnnotations::hasInjectAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    private static boolean hasQualifierAnnotation(XAnnotation annotation) {
        return annotation.getType().getTypeElement().hasAnyAnnotation(new ClassName[]{TypeNames.QUALIFIER, TypeNames.QUALIFIER_JAVAX});
    }

    private static boolean hasScopeAnnotation(XAnnotation annotation) {
        return annotation.getType().getTypeElement().hasAnyAnnotation(new ClassName[]{TypeNames.SCOPE, TypeNames.SCOPE_JAVAX});
    }

    public static boolean hasInjectAnnotation(XElement element) {
        return element.hasAnyAnnotation(new ClassName[]{TypeNames.INJECT, TypeNames.INJECT_JAVAX});
    }

    public static boolean hasInjectOrAssistedInjectAnnotation(XElement element) {
        return element.hasAnyAnnotation(new ClassName[]{TypeNames.INJECT, TypeNames.INJECT_JAVAX, TypeNames.ASSISTED_INJECT});
    }

    private ImmutableSet<XAnnotation> getQualifiersForKotlinProperty(XFieldElement field) {
        if (this.kotlinMetadataUtil.isMissingSyntheticPropertyForAnnotations(field)) {
            XTypeElement membersInjector = this.processingEnv.findTypeElement((TypeName)SourceFiles.membersInjectorNameForType(XElements.asTypeElement((XElement)field.getEnclosingElement())));
            if (membersInjector != null) {
                String memberInjectedFieldSignature = SourceFiles.memberInjectedFieldSignatureForVariable(field);
                return ((Optional)membersInjector.getDeclaredMethods().stream().filter(method -> Optional.ofNullable(method.getAnnotation(TypeNames.INJECTED_FIELD_SIGNATURE)).map(annotation -> annotation.getAsString("value")).map(memberInjectedFieldSignature::equals).orElse(false)).collect(DaggerCollectors.toOptional())).map(this::getQualifiers).orElseThrow(() -> new IllegalStateException(String.format("No matching InjectedFieldSignature for %1$s. This likely means that %1$s was compiled with an older, incompatible version of Dagger. Please update all Dagger dependencies to the same version.", memberInjectedFieldSignature)));
            }
            throw new IllegalStateException("No MembersInjector found for " + field.getEnclosingElement());
        }
        return (ImmutableSet)Stream.concat(this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(field, TypeNames.QUALIFIER).stream(), this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(field, TypeNames.QUALIFIER_JAVAX).stream()).collect(DaggerStreams.toImmutableSet());
    }
}

