/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class DependencyRequestFactory {
    private final KeyFactory keyFactory;
    private final InjectionAnnotations injectionAnnotations;
    private static final ImmutableSet<RequestKind> WRAPPING_MAP_VALUE_FRAMEWORK_TYPES = ImmutableSet.of((Object)RequestKind.PROVIDER, (Object)RequestKind.PRODUCER);

    @Inject
    DependencyRequestFactory(KeyFactory keyFactory, InjectionAnnotations injectionAnnotations) {
        this.keyFactory = keyFactory;
        this.injectionAnnotations = injectionAnnotations;
    }

    ImmutableSet<DependencyRequest> forRequiredResolvedVariables(List<? extends XVariableElement> variables, List<XType> resolvedTypes) {
        Preconditions.checkState((resolvedTypes.size() == variables.size() ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < variables.size(); ++i) {
            builder.add((Object)this.forRequiredResolvedVariable(variables.get(i), resolvedTypes.get(i)));
        }
        return builder.build();
    }

    ImmutableSet<DependencyRequest> forMultibindingContributions(Key multibindingKey, Iterable<ContributionBinding> multibindingContributions) {
        ImmutableSet.Builder requests = ImmutableSet.builder();
        for (ContributionBinding multibindingContribution : multibindingContributions) {
            requests.add((Object)this.forMultibindingContribution(multibindingKey, multibindingContribution));
        }
        return requests.build();
    }

    private DependencyRequest forMultibindingContribution(Key multibindingKey, ContributionBinding multibindingContribution) {
        Preconditions.checkArgument((boolean)multibindingContribution.key().multibindingContributionIdentifier().isPresent(), (String)"multibindingContribution's key must have a multibinding contribution identifier: %s", (Object)multibindingContribution);
        return DependencyRequest.builder().kind(this.multibindingContributionRequestKind(multibindingKey, multibindingContribution)).key(multibindingContribution.key()).build();
    }

    private RequestKind multibindingContributionRequestKind(Key multibindingKey, ContributionBinding multibindingContribution) {
        switch (multibindingContribution.contributionType()) {
            case MAP: {
                MapType mapType = MapType.from(multibindingKey);
                for (RequestKind kind : WRAPPING_MAP_VALUE_FRAMEWORK_TYPES) {
                    if (!mapType.valuesAreTypeOf(RequestKinds.frameworkClassName(kind))) continue;
                    return kind;
                }
            }
            case SET: 
            case SET_VALUES: {
                return RequestKind.INSTANCE;
            }
            case UNIQUE: {
                throw new IllegalArgumentException("multibindingContribution must be a multibinding: " + multibindingContribution);
            }
        }
        throw new AssertionError((Object)multibindingContribution.toString());
    }

    DependencyRequest forRequiredResolvedVariable(XVariableElement variableElement, XType resolvedType) {
        Preconditions.checkNotNull((Object)variableElement);
        Preconditions.checkNotNull((Object)resolvedType);
        Preconditions.checkArgument((!AssistedInjectionAnnotations.isAssistedParameter(variableElement) ? 1 : 0) != 0);
        Optional<XAnnotation> qualifier = this.injectionAnnotations.getQualifier((XElement)variableElement);
        return this.newDependencyRequest((XElement)variableElement, resolvedType, qualifier);
    }

    public DependencyRequest forComponentProvisionMethod(XMethodElement provisionMethod, XMethodType provisionMethodType) {
        Preconditions.checkNotNull((Object)provisionMethod);
        Preconditions.checkNotNull((Object)provisionMethodType);
        Preconditions.checkArgument((boolean)provisionMethod.getParameters().isEmpty(), (String)"Component provision methods must be empty: %s", (Object)provisionMethod);
        Optional<XAnnotation> qualifier = this.injectionAnnotations.getQualifier((XElement)provisionMethod);
        return this.newDependencyRequest((XElement)provisionMethod, provisionMethodType.getReturnType(), qualifier);
    }

    public DependencyRequest forComponentProductionMethod(XMethodElement productionMethod, XMethodType productionMethodType) {
        Preconditions.checkNotNull((Object)productionMethod);
        Preconditions.checkNotNull((Object)productionMethodType);
        Preconditions.checkArgument((boolean)productionMethod.getParameters().isEmpty(), (String)"Component production methods must be empty: %s", (Object)productionMethod);
        XType type = productionMethodType.getReturnType();
        Optional<XAnnotation> qualifier = this.injectionAnnotations.getQualifier((XElement)productionMethod);
        if (XTypes.isTypeOf((XType)type, (ClassName)TypeNames.LISTENABLE_FUTURE)) {
            return DependencyRequest.builder().kind(RequestKind.FUTURE).key(this.keyFactory.forQualifiedType(qualifier, XTypes.unwrapType((XType)type))).requestElement(DaggerElement.from((XElement)productionMethod)).build();
        }
        return this.newDependencyRequest((XElement)productionMethod, type, qualifier);
    }

    DependencyRequest forComponentMembersInjectionMethod(XMethodElement membersInjectionMethod, XMethodType membersInjectionMethodType) {
        Preconditions.checkNotNull((Object)membersInjectionMethod);
        Preconditions.checkNotNull((Object)membersInjectionMethodType);
        Optional<XAnnotation> qualifier = this.injectionAnnotations.getQualifier((XElement)membersInjectionMethod);
        Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
        XType membersInjectedType = (XType)Iterables.getOnlyElement((Iterable)membersInjectionMethodType.getParameterTypes());
        return DependencyRequest.builder().kind(RequestKind.MEMBERS_INJECTION).key(this.keyFactory.forMembersInjectedType(membersInjectedType)).requestElement(DaggerElement.from((XElement)membersInjectionMethod)).build();
    }

    DependencyRequest forProductionImplementationExecutor() {
        return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(this.keyFactory.forProductionImplementationExecutor()).build();
    }

    DependencyRequest forProductionComponentMonitor() {
        return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(this.keyFactory.forProductionComponentMonitor()).build();
    }

    DependencyRequest forSyntheticPresentOptionalBinding(Key requestKey, RequestKind kind) {
        Optional<Key> key = this.keyFactory.unwrapOptional(requestKey);
        Preconditions.checkArgument((boolean)key.isPresent(), (String)"not a request for optional: %s", (Object)requestKey);
        return DependencyRequest.builder().kind(kind).key(key.get()).isNullable(this.allowsNull(RequestKinds.getRequestKind(OptionalType.from(requestKey).valueType()), Optional.empty())).build();
    }

    private DependencyRequest newDependencyRequest(XElement requestElement, XType type, Optional<XAnnotation> qualifier) {
        RequestKind requestKind = RequestKinds.getRequestKind(type);
        return DependencyRequest.builder().kind(requestKind).key(this.keyFactory.forQualifiedType(qualifier, RequestKinds.extractKeyType(type))).requestElement(DaggerElement.from((XElement)requestElement)).isNullable(this.allowsNull(requestKind, ConfigurationAnnotations.getNullableType(requestElement))).build();
    }

    private boolean allowsNull(RequestKind kind, Optional<XType> nullableType) {
        return nullableType.isPresent() || !kind.equals((Object)RequestKind.INSTANCE);
    }
}

