/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.AutoValue_ModuleAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

@AutoValue
public abstract class ModuleAnnotation {
    private static final ImmutableSet<ClassName> MODULE_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE);
    private XAnnotation annotation;

    public final XAnnotation annotation() {
        return this.annotation;
    }

    public abstract ClassName className();

    public String simpleName() {
        return this.className().simpleName();
    }

    @Memoized
    public ImmutableList<XTypeElement> includes() {
        return (ImmutableList)this.annotation.getAsTypeList("includes").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    @Memoized
    public ImmutableList<XTypeElement> subcomponents() {
        return (ImmutableList)this.annotation.getAsTypeList("subcomponents").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isModuleAnnotation(XAnnotation annotation) {
        return MODULE_ANNOTATIONS.contains((Object)XAnnotations.getClassName((XAnnotation)annotation));
    }

    public static ImmutableSet<ClassName> moduleAnnotations() {
        return MODULE_ANNOTATIONS;
    }

    private static ModuleAnnotation create(XAnnotation annotation) {
        Preconditions.checkArgument((boolean)ModuleAnnotation.isModuleAnnotation(annotation), (String)"%s is not a Module or ProducerModule annotation", (Object)annotation);
        AutoValue_ModuleAnnotation moduleAnnotation = new AutoValue_ModuleAnnotation(XAnnotations.getClassName((XAnnotation)annotation));
        moduleAnnotation.annotation = annotation;
        return moduleAnnotation;
    }

    public static Optional<ModuleAnnotation> moduleAnnotation(XElement element, DaggerSuperficialValidation superficialValidation) {
        return XElements.getAnyAnnotation((XAnnotated)element, (ClassName[])new ClassName[]{TypeNames.MODULE, TypeNames.PRODUCER_MODULE}).map(annotation -> {
            superficialValidation.validateAnnotationOf(element, (XAnnotation)annotation);
            return ModuleAnnotation.create(annotation);
        });
    }
}

