/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.SuperficialValidation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class EnclosingTypeElementValidator
implements ClearableCache {
    private final Map<TypeElement, Boolean> validatedTypeElements = new HashMap<TypeElement, Boolean>();

    @Inject
    EnclosingTypeElementValidator() {
    }

    public boolean validateEnclosingType(XElement element) {
        Element javaElement = XConverters.toJavac((XElement)element);
        return this.validatedTypeElements.computeIfAbsent(DaggerElements.closestEnclosingTypeElement(javaElement), SuperficialValidation::validateElement);
    }

    @Override
    public void clearCache() {
        this.validatedTypeElements.clear();
    }
}

