/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.DependencyRequestFormatter;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerElement;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public final class DiagnosticMessageGenerator {
    private final BindingGraph graph;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final ElementFormatter elementFormatter;
    private final java.util.function.Function<TypeElement, Iterable<TypeElement>> supertypes;
    private final Table<BindingGraph.MaybeBinding, BindingGraph.DependencyEdge, ImmutableList<BindingGraph.Node>> shortestPaths = HashBasedTable.create();
    private final Formatter<BindingGraph.DependencyEdge> entryPointFormatter = new Formatter<BindingGraph.DependencyEdge>(){

        @Override
        public String format(BindingGraph.DependencyEdge object) {
            Element requestElement = ((DaggerElement)object.dependencyRequest().requestElement().get()).java();
            StringBuilder element = new StringBuilder(ElementFormatter.elementToString(requestElement));
            ComponentPath componentPath = DiagnosticMessageGenerator.this.source((BindingGraph.Edge)object).componentPath();
            if (!componentPath.atRoot() || !requestElement.getEnclosingElement().equals(componentPath.rootComponent().java())) {
                element.append(String.format(" [%s]", componentPath));
            }
            return element.toString();
        }
    };

    private static <K, V> java.util.function.Function<K, V> memoize(java.util.function.Function<K, V> uncached) {
        Function uncachedAsBaseFunction = uncached::apply;
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)uncachedAsBaseFunction));
        java.util.function.Function<Object, Object> memoized = arg_0 -> ((LoadingCache)cache).apply(arg_0);
        return memoized;
    }

    private DiagnosticMessageGenerator(BindingGraph graph, DaggerTypes types, DependencyRequestFormatter dependencyRequestFormatter, ElementFormatter elementFormatter) {
        this.graph = graph;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.elementFormatter = elementFormatter;
        this.supertypes = DiagnosticMessageGenerator.memoize(component -> Iterables.transform(types.supertypes(component.asType()), MoreTypes::asTypeElement));
    }

    public String getMessage(BindingGraph.MaybeBinding binding) {
        ImmutableSet entryPoints = this.graph.entryPointEdgesDependingOnBinding(binding);
        ImmutableSet<BindingGraph.DependencyEdge> requests = this.requests(binding);
        ImmutableList<BindingGraph.DependencyEdge> dependencyTrace = this.dependencyTrace(binding, (ImmutableSet<BindingGraph.DependencyEdge>)entryPoints);
        return this.getMessageInternal(dependencyTrace, requests, (ImmutableSet<BindingGraph.DependencyEdge>)entryPoints);
    }

    public String getMessage(BindingGraph.DependencyEdge dependencyEdge) {
        ImmutableList dependencyTrace;
        ImmutableSet entryPoints;
        ImmutableSet requests = ImmutableSet.of((Object)dependencyEdge);
        if (dependencyEdge.isEntryPoint()) {
            entryPoints = ImmutableSet.of((Object)dependencyEdge);
            dependencyTrace = ImmutableList.of((Object)dependencyEdge);
        } else {
            Binding binding = (Binding)this.source((BindingGraph.Edge)dependencyEdge);
            entryPoints = this.graph.entryPointEdgesDependingOnBinding((BindingGraph.MaybeBinding)binding);
            dependencyTrace = ImmutableList.builder().add((Object)dependencyEdge).addAll(this.dependencyTrace((BindingGraph.MaybeBinding)binding, (ImmutableSet<BindingGraph.DependencyEdge>)entryPoints)).build();
        }
        return this.getMessageInternal((ImmutableList<BindingGraph.DependencyEdge>)dependencyTrace, (ImmutableSet<BindingGraph.DependencyEdge>)requests, (ImmutableSet<BindingGraph.DependencyEdge>)entryPoints);
    }

    private String getMessageInternal(ImmutableList<BindingGraph.DependencyEdge> dependencyTrace, ImmutableSet<BindingGraph.DependencyEdge> requests, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
        StringBuilder message;
        StringBuilder stringBuilder = message = this.graph.isFullBindingGraph() ? new StringBuilder() : new StringBuilder(dependencyTrace.size() * 100);
        if (!this.graph.isFullBindingGraph()) {
            dependencyTrace.forEach(edge -> this.dependencyRequestFormatter.appendFormatLine(message, edge.dependencyRequest()));
            if (!dependencyTrace.isEmpty()) {
                this.appendComponentPathUnlessAtRoot(message, this.source((BindingGraph.Edge)Iterables.getLast(dependencyTrace)));
            }
        }
        message.append(this.getRequestsNotInTrace(dependencyTrace, requests, entryPoints));
        return message.toString();
    }

    public String getRequestsNotInTrace(ImmutableList<BindingGraph.DependencyEdge> dependencyTrace, ImmutableSet<BindingGraph.DependencyEdge> requests, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
        StringBuilder message = new StringBuilder();
        ImmutableSet requestsToPrint = (ImmutableSet)requests.stream().filter(request -> this.graph.isFullBindingGraph() || !request.isEntryPoint() && !DiagnosticMessageGenerator.isTracedRequest(dependencyTrace, request)).map(request -> request.dependencyRequest().requestElement()).flatMap(DaggerStreams.presentValues()).map(DaggerElement::java).collect(DaggerStreams.toImmutableSet());
        if (!requestsToPrint.isEmpty()) {
            message.append("\nIt is").append(this.graph.isFullBindingGraph() ? " " : " also ").append("requested at:");
            this.elementFormatter.formatIndentedList(message, requestsToPrint, 1);
        }
        if (!this.graph.isFullBindingGraph() && entryPoints.size() > 1) {
            message.append("\nThe following other entry points also depend on it:");
            this.entryPointFormatter.formatIndentedList(message, (Iterable)entryPoints.stream().filter(entryPoint -> !entryPoint.equals(Iterables.getLast((Iterable)dependencyTrace))).sorted(this.rootComponentFirst().thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableList()), 1);
        }
        return message.toString();
    }

    public void appendComponentPathUnlessAtRoot(StringBuilder message, BindingGraph.Node node) {
        if (!node.componentPath().equals((Object)this.graph.rootComponentNode().componentPath())) {
            message.append(String.format(" [%s]", node.componentPath()));
        }
    }

    private static boolean isTracedRequest(ImmutableList<BindingGraph.DependencyEdge> dependencyTrace, BindingGraph.DependencyEdge request) {
        return !dependencyTrace.isEmpty() && request.equals(dependencyTrace.get(0));
    }

    public ImmutableList<BindingGraph.DependencyEdge> dependencyTrace(BindingGraph.MaybeBinding binding, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
        if (entryPoints.isEmpty()) {
            return ImmutableList.of();
        }
        BindingGraph.DependencyEdge entryPointForTrace = Collections.min(entryPoints, this.rootComponentFirst().thenComparing(this.shortestDependencyPathFirst(binding)).thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder()));
        ImmutableList<BindingGraph.Node> shortestBindingPath = this.shortestPathFromEntryPoint(entryPointForTrace, binding);
        Verify.verify((!shortestBindingPath.isEmpty() ? 1 : 0) != 0, (String)"no dependency path from %s to %s in %s", (Object)entryPointForTrace, (Object)binding, (Object)this.graph);
        ImmutableList.Builder dependencyTrace = ImmutableList.builder();
        dependencyTrace.add((Object)entryPointForTrace);
        for (int i = 0; i < shortestBindingPath.size() - 1; ++i) {
            Set dependenciesBetween = this.graph.network().edgesConnecting((Object)((BindingGraph.Node)shortestBindingPath.get(i)), (Object)((BindingGraph.Node)shortestBindingPath.get(i + 1)));
            dependencyTrace.add((Object)((BindingGraph.DependencyEdge)Iterables.get((Iterable)dependenciesBetween, (int)0)));
        }
        return dependencyTrace.build().reverse();
    }

    public ImmutableSet<BindingGraph.DependencyEdge> requests(BindingGraph.MaybeBinding binding) {
        return (ImmutableSet)this.graph.network().inEdges((Object)binding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> edge.dependencyRequest().requestElement().isPresent()).sorted(this.requestEnclosingTypeName().thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableSet());
    }

    Comparator<BindingGraph.DependencyEdge> rootComponentFirst() {
        return Comparator.comparingInt(entryPoint -> this.source((BindingGraph.Edge)entryPoint).componentPath().components().size());
    }

    Comparator<BindingGraph.DependencyEdge> shortestDependencyPathFirst(BindingGraph.MaybeBinding binding) {
        return Comparator.comparing(entryPoint -> this.shortestPathFromEntryPoint((BindingGraph.DependencyEdge)entryPoint, binding).size());
    }

    ImmutableList<BindingGraph.Node> shortestPathFromEntryPoint(BindingGraph.DependencyEdge entryPoint, BindingGraph.MaybeBinding binding) {
        return this.shortestPaths.row((Object)binding).computeIfAbsent(entryPoint, ep -> DaggerGraphs.shortestPath(node -> Iterables.filter((Iterable)this.graph.network().successors(node), BindingGraph.MaybeBinding.class::isInstance), (Object)((BindingGraph.Node)this.graph.network().incidentNodes(ep).target()), (Object)binding));
    }

    Comparator<BindingGraph.DependencyEdge> nearestComponentSupertypeFirst() {
        return Comparator.comparingInt(entryPoint -> Iterables.indexOf(this.supertypes.apply(this.componentContainingEntryPoint((BindingGraph.DependencyEdge)entryPoint)), (Predicate)Predicates.equalTo((Object)this.typeDeclaringEntryPoint((BindingGraph.DependencyEdge)entryPoint))));
    }

    TypeElement componentContainingEntryPoint(BindingGraph.DependencyEdge entryPoint) {
        return this.source((BindingGraph.Edge)entryPoint).componentPath().currentComponent().java();
    }

    TypeElement typeDeclaringEntryPoint(BindingGraph.DependencyEdge entryPoint) {
        return MoreElements.asType((Element)((DaggerElement)entryPoint.dependencyRequest().requestElement().get()).java().getEnclosingElement());
    }

    Comparator<BindingGraph.DependencyEdge> requestEnclosingTypeName() {
        return Comparator.comparing(edge -> DaggerElements.closestEnclosingTypeElement(((DaggerElement)edge.dependencyRequest().requestElement().get()).java()).getQualifiedName().toString());
    }

    Comparator<BindingGraph.DependencyEdge> requestElementDeclarationOrder() {
        return Comparator.comparing(edge -> ((DaggerElement)edge.dependencyRequest().requestElement().get()).java(), DaggerElements.DECLARATION_ORDER);
    }

    private BindingGraph.Node source(BindingGraph.Edge edge) {
        return (BindingGraph.Node)this.graph.network().incidentNodes((Object)edge).source();
    }

    public static final class Factory {
        private final DaggerTypes types;
        private final DependencyRequestFormatter dependencyRequestFormatter;
        private final ElementFormatter elementFormatter;

        @Inject
        Factory(DaggerTypes types, DependencyRequestFormatter dependencyRequestFormatter, ElementFormatter elementFormatter) {
            this.types = types;
            this.dependencyRequestFormatter = dependencyRequestFormatter;
            this.elementFormatter = elementFormatter;
        }

        public DiagnosticMessageGenerator create(BindingGraph graph) {
            return new DiagnosticMessageGenerator(graph, this.types, this.dependencyRequestFormatter, this.elementFormatter);
        }
    }
}

