/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.langmodel;

import com.google.common.base.Preconditions;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class Accessibility {
    public static boolean isTypePubliclyAccessible(TypeMirror type) {
        return type.accept(new TypeAccessibilityVisitor(Optional.empty()), null);
    }

    public static boolean isTypeAccessibleFrom(TypeMirror type, String packageName) {
        return type.accept(new TypeAccessibilityVisitor(Optional.of(packageName)), null);
    }

    public static boolean isElementPubliclyAccessible(Element element) {
        return element.accept(new ElementAccessibilityVisitor(Optional.empty()), null);
    }

    public static boolean isElementAccessibleFrom(XElement element, String packageName) {
        return Accessibility.isElementAccessibleFrom(XConverters.toJavac((XElement)element), packageName);
    }

    public static boolean isElementAccessibleFrom(Element element, String packageName) {
        return element.accept(new ElementAccessibilityVisitor(Optional.of(packageName)), null);
    }

    public static boolean isElementAccessibleFromOwnPackage(Element element) {
        return Accessibility.isElementAccessibleFrom(element, MoreElements.getPackage((Element)element).getQualifiedName().toString());
    }

    public static boolean isRawTypeAccessible(TypeMirror type, String requestingPackage) {
        return type.getKind() == TypeKind.DECLARED ? Accessibility.isElementAccessibleFrom(MoreTypes.asElement((TypeMirror)type), requestingPackage) : Accessibility.isTypeAccessibleFrom(type, requestingPackage);
    }

    public static boolean isRawTypePubliclyAccessible(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED ? Accessibility.isElementPubliclyAccessible(MoreTypes.asElement((TypeMirror)type)) : Accessibility.isTypePubliclyAccessible(type);
    }

    private Accessibility() {
    }

    private static final class ElementAccessibilityVisitor
    extends SimpleElementVisitor8<Boolean, Void> {
        private final Optional<String> packageName;

        ElementAccessibilityVisitor(Optional<String> packageName) {
            this.packageName = packageName;
        }

        @Override
        public Boolean visitPackage(PackageElement element, Void p) {
            return true;
        }

        @Override
        public Boolean visitType(TypeElement element, Void p) {
            switch (element.getNestingKind()) {
                case MEMBER: {
                    return this.accessibleMember(element);
                }
                case TOP_LEVEL: {
                    return this.accessibleModifiers(element);
                }
                case ANONYMOUS: 
                case LOCAL: {
                    return false;
                }
            }
            throw new AssertionError();
        }

        boolean accessibleMember(Element element) {
            return element.getEnclosingElement().accept(this, null) != false && this.accessibleModifiers(element);
        }

        boolean accessibleModifiers(Element element) {
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return true;
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return false;
            }
            return this.packageName.isPresent() && MoreElements.getPackage((Element)element).getQualifiedName().contentEquals(this.packageName.get());
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement element, Void p) {
            throw new IllegalArgumentException("It does not make sense to check the accessibility of a type parameter");
        }

        @Override
        public Boolean visitExecutable(ExecutableElement element, Void p) {
            return this.accessibleMember(element);
        }

        @Override
        public Boolean visitVariable(VariableElement element, Void p) {
            ElementKind kind = element.getKind();
            Preconditions.checkArgument((boolean)kind.isField(), (String)"checking a variable that isn't a field: %s", (Object)((Object)kind));
            return this.accessibleMember(element);
        }
    }

    private static final class TypeAccessibilityVisitor
    extends SimpleTypeVisitor8<Boolean, Void> {
        private final Optional<String> packageName;

        TypeAccessibilityVisitor(Optional<String> packageName) {
            this.packageName = packageName;
        }

        boolean isAccessible(TypeMirror type) {
            return type.accept(this, null);
        }

        @Override
        public Boolean visitNoType(NoType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void p) {
            if (!this.isAccessible(type.getEnclosingType())) {
                return false;
            }
            if (!type.asElement().accept(new ElementAccessibilityVisitor(this.packageName), null).booleanValue()) {
                return false;
            }
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                if (this.isAccessible(typeMirror)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType type, Void p) {
            return type.getComponentType().accept(this, null);
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitNull(NullType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable type, Void p) {
            return true;
        }

        @Override
        public Boolean visitWildcard(WildcardType type, Void p) {
            if (type.getExtendsBound() != null && !this.isAccessible(type.getExtendsBound())) {
                return false;
            }
            if (type.getSuperBound() != null && !this.isAccessible(type.getSuperBound())) {
                return false;
            }
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void p) {
            throw new IllegalArgumentException(String.format("%s of kind %s should not be checked for accessibility", new Object[]{type, type.getKind()}));
        }
    }
}

