/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;

@Singleton
public final class KotlinMetadataFactory
implements ClearableCache {
    private final Map<TypeElement, KotlinMetadata> metadataCache = new HashMap<TypeElement, KotlinMetadata>();

    @Inject
    KotlinMetadataFactory() {
    }

    public KotlinMetadata create(Element element) {
        TypeElement enclosingElement = DaggerElements.closestEnclosingTypeElement(element);
        if (!MoreElements.isAnnotationPresent((Element)enclosingElement, Metadata.class)) {
            throw new IllegalStateException("Missing @Metadata for: " + enclosingElement);
        }
        return this.metadataCache.computeIfAbsent(enclosingElement, KotlinMetadata::from);
    }

    @Override
    public void clearCache() {
        this.metadataCache.clear();
    }
}

