/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.componentgenerator.TopLevelImplementationComponent;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final XProcessingEnv processingEnv;
    private final TopLevelImplementationComponent.Factory topLevelImplementationComponentFactory;

    @Inject
    ComponentGenerator(XFiler filer, DaggerElements elements, SourceVersion sourceVersion, XProcessingEnv processingEnv, TopLevelImplementationComponent.Factory topLevelImplementationComponentFactory) {
        super(filer, elements, sourceVersion);
        this.processingEnv = processingEnv;
        this.topLevelImplementationComponentFactory = topLevelImplementationComponentFactory;
    }

    @Override
    public XElement originatingElement(BindingGraph input) {
        return XConverters.toXProcessing((TypeElement)input.componentTypeElement(), (XProcessingEnv)this.processingEnv);
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = this.topLevelImplementationComponentFactory.create(bindingGraph).currentImplementationSubcomponentBuilder().bindingGraph(bindingGraph).parentImplementation(Optional.empty()).parentRequestRepresentations(Optional.empty()).parentRequirementExpressions(Optional.empty()).build().componentImplementation();
        Verify.verify((boolean)componentImplementation.name().equals((Object)ComponentNames.getRootComponentClassName(bindingGraph.componentDescriptor())));
        return ImmutableList.of((Object)componentImplementation.generate().toBuilder());
    }
}

