/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.compileroption;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.FeatureStatus;
import dagger.internal.codegen.compileroption.ProcessingOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public final class ProcessingEnvironmentCompilerOptions
extends CompilerOptions {
    private static final String KEYS_PER_COMPONENT_SHARD = "dagger.keysPerComponentShard";
    private final XMessager messager;
    private final Map<String, String> options;
    private final DaggerElements elements;
    private final Map<EnumOption<?>, Object> enumOptions = new HashMap();
    private final Map<EnumOption<?>, ImmutableMap<String, ? extends Enum<?>>> allCommandLineOptions = new HashMap();

    @Inject
    ProcessingEnvironmentCompilerOptions(XMessager messager, @ProcessingOptions Map<String, String> options, DaggerElements elements) {
        this.messager = messager;
        this.options = options;
        this.elements = elements;
        this.checkValid();
    }

    @Override
    public boolean usesProducers() {
        return this.elements.getTypeElement(TypeNames.PRODUCES) != null;
    }

    @Override
    public boolean headerCompilation() {
        return this.isEnabled(KeyOnlyOption.HEADER_COMPILATION);
    }

    @Override
    public boolean experimentalMergedMode(TypeElement component) {
        boolean isExperimental = this.experimentalMergedModeInternal();
        if (isExperimental) {
            Preconditions.checkState((!this.fastInitInternal(component) ? 1 : 0) != 0, (Object)"Both fast init and experimental merged mode were turned on, please specify exactly one compilation mode.");
        }
        return isExperimental;
    }

    @Override
    public boolean fastInit(TypeElement component) {
        boolean isFastInit = this.fastInitInternal(component);
        if (isFastInit) {
            Preconditions.checkState((!this.experimentalMergedModeInternal() ? 1 : 0) != 0, (Object)"Both fast init and experimental merged mode were turned on, please specify exactly one compilation mode.");
        }
        return isFastInit;
    }

    private boolean fastInitInternal(TypeElement component) {
        return this.isEnabled(Feature.FAST_INIT);
    }

    private boolean experimentalMergedModeInternal() {
        return false;
    }

    @Override
    public boolean formatGeneratedSource() {
        return this.isEnabled(Feature.FORMAT_GENERATED_SOURCE);
    }

    @Override
    public boolean writeProducerNameInToken() {
        return this.isEnabled(Feature.WRITE_PRODUCER_NAME_IN_TOKEN);
    }

    @Override
    public Diagnostic.Kind nullableValidationKind() {
        return this.diagnosticKind(Validation.NULLABLE_VALIDATION);
    }

    @Override
    public Diagnostic.Kind privateMemberValidationKind() {
        return this.diagnosticKind(Validation.PRIVATE_MEMBER_VALIDATION);
    }

    @Override
    public Diagnostic.Kind staticMemberValidationKind() {
        return this.diagnosticKind(Validation.STATIC_MEMBER_VALIDATION);
    }

    @Override
    public boolean ignorePrivateAndStaticInjectionForComponent() {
        return this.isEnabled(Feature.IGNORE_PRIVATE_AND_STATIC_INJECTION_FOR_COMPONENT);
    }

    @Override
    public ValidationType scopeCycleValidationType() {
        return this.parseOption(Validation.DISABLE_INTER_COMPONENT_SCOPE_VALIDATION);
    }

    @Override
    public boolean validateTransitiveComponentDependencies() {
        return this.isEnabled(Feature.VALIDATE_TRANSITIVE_COMPONENT_DEPENDENCIES);
    }

    @Override
    public boolean warnIfInjectionFactoryNotGeneratedUpstream() {
        return this.isEnabled(Feature.WARN_IF_INJECTION_FACTORY_NOT_GENERATED_UPSTREAM);
    }

    @Override
    public ValidationType fullBindingGraphValidationType() {
        return this.parseOption(Validation.FULL_BINDING_GRAPH_VALIDATION);
    }

    @Override
    public boolean pluginsVisitFullBindingGraphs(TypeElement component) {
        return this.isEnabled(Feature.PLUGINS_VISIT_FULL_BINDING_GRAPHS);
    }

    @Override
    public Diagnostic.Kind moduleHasDifferentScopesDiagnosticKind() {
        return this.diagnosticKind(Validation.MODULE_HAS_DIFFERENT_SCOPES_VALIDATION);
    }

    @Override
    public ValidationType explicitBindingConflictsWithInjectValidationType() {
        return this.parseOption(Validation.EXPLICIT_BINDING_CONFLICTS_WITH_INJECT);
    }

    @Override
    public boolean experimentalDaggerErrorMessages() {
        return this.isEnabled(Feature.EXPERIMENTAL_DAGGER_ERROR_MESSAGES);
    }

    @Override
    public boolean strictMultibindingValidation() {
        return this.isEnabled(Feature.STRICT_MULTIBINDING_VALIDATION);
    }

    @Override
    public int keysPerComponentShard(TypeElement component) {
        if (this.options.containsKey(KEYS_PER_COMPONENT_SHARD)) {
            Preconditions.checkArgument((boolean)MoreElements.getPackage((Element)component).getQualifiedName().toString().startsWith("dagger."), (String)"Cannot set %s. It is only meant for internal testing.", (Object)KEYS_PER_COMPONENT_SHARD);
            return Integer.parseInt(this.options.get(KEYS_PER_COMPONENT_SHARD));
        }
        return super.keysPerComponentShard(component);
    }

    private boolean isEnabled(KeyOnlyOption keyOnlyOption) {
        return this.options.containsKey(keyOnlyOption.toString());
    }

    private boolean isEnabled(Feature feature) {
        return this.parseOption(feature).equals((Object)FeatureStatus.ENABLED);
    }

    private Diagnostic.Kind diagnosticKind(Validation validation) {
        return this.parseOption(validation).diagnosticKind().get();
    }

    private ProcessingEnvironmentCompilerOptions checkValid() {
        for (KeyOnlyOption keyOnlyOption : KeyOnlyOption.values()) {
            this.isEnabled(keyOnlyOption);
        }
        for (Enum enum_ : Feature.values()) {
            this.parseOption((EnumOption)((Object)enum_));
        }
        for (Enum enum_ : Validation.values()) {
            this.parseOption((EnumOption)((Object)enum_));
        }
        this.noLongerRecognized(Feature.EXPERIMENTAL_ANDROID_MODE);
        this.noLongerRecognized(Feature.FLOATING_BINDS_METHODS);
        this.noLongerRecognized(Feature.EXPERIMENTAL_AHEAD_OF_TIME_SUBCOMPONENTS);
        this.noLongerRecognized(KeyOnlyOption.USE_GRADLE_INCREMENTAL_PROCESSING);
        return this;
    }

    private void noLongerRecognized(CommandLineOption commandLineOption) {
        if (this.options.containsKey(commandLineOption.toString())) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, commandLineOption + " is no longer recognized by Dagger");
        }
    }

    private static String optionName(Enum<? extends EnumOption<?>> option) {
        return "dagger." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, option.name());
    }

    public static ImmutableSet<String> supportedOptions() {
        return ImmutableSet.builder().addAll((Iterable)Stream.of(KeyOnlyOption.values(), Feature.values(), Validation.values()).flatMap(Arrays::stream).flatMap(CommandLineOption::allNames).collect(DaggerStreams.toImmutableSet())).add((Object)KEYS_PER_COMPONENT_SHARD).build();
    }

    private <T extends Enum<T>> T parseOption(EnumOption<T> option) {
        Enum value = (Enum)this.enumOptions.computeIfAbsent(option, this::parseOptionUncached);
        return (T)value;
    }

    private boolean isSetOnCommandLine(Feature feature) {
        return this.getUsedNames(feature).count() > 0L;
    }

    private <T extends Enum<T>> T parseOptionUncached(EnumOption<T> option) {
        ImmutableMap<String, T> values = this.parseOptionWithAllNames(option);
        if (values.isEmpty()) {
            return option.defaultValue();
        }
        if (values.asMultimap().inverse().keySet().size() == 1) {
            if (values.size() > 1) {
                this.reportUseOfDifferentNamesForOption(Diagnostic.Kind.WARNING, option, (ImmutableSet<String>)values.keySet());
            }
            return (T)((Enum)values.values().asList().get(0));
        }
        this.reportUseOfDifferentNamesForOption(Diagnostic.Kind.ERROR, option, (ImmutableSet<String>)values.keySet());
        return option.defaultValue();
    }

    private void reportUseOfDifferentNamesForOption(Diagnostic.Kind diagnosticKind, EnumOption<?> option, ImmutableSet<String> usedNames) {
        this.messager.printMessage(diagnosticKind, String.format("Only one of the equivalent options (%s) should be used; prefer -A%s", usedNames.stream().map(name -> "-A" + name).collect(Collectors.joining(", ")), option));
    }

    private <T extends Enum<T>> ImmutableMap<String, T> parseOptionWithAllNames(EnumOption<T> option) {
        ImmutableMap aliasValues = this.allCommandLineOptions.computeIfAbsent(option, this::parseOptionWithAllNamesUncached);
        return aliasValues;
    }

    private <T extends Enum<T>> ImmutableMap<String, T> parseOptionWithAllNamesUncached(EnumOption<T> option) {
        ImmutableMap.Builder values = ImmutableMap.builder();
        this.getUsedNames(option).forEach(name -> this.parseOptionWithName(option, (String)name).ifPresent(value -> values.put(name, value)));
        return values.build();
    }

    private <T extends Enum<T>> Optional<T> parseOptionWithName(EnumOption<T> option, String key) {
        Preconditions.checkArgument((boolean)this.options.containsKey(key), (String)"key %s not found", (Object)key);
        String stringValue = this.options.get(key);
        if (stringValue == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Processor option -A" + key + " needs a value");
        } else {
            try {
                T value = Enum.valueOf(((Enum)option.defaultValue()).getDeclaringClass(), Ascii.toUpperCase((String)stringValue));
                if (option.validValues().contains(value)) {
                    return Optional.of(value);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Processor option -A%s may only have the values %s (case insensitive), found: %s", key, option.validValues(), stringValue));
        }
        return Optional.empty();
    }

    private Stream<String> getUsedNames(CommandLineOption option) {
        return option.allNames().filter(this.options::containsKey);
    }

    static enum Validation implements EnumOption<ValidationType>
    {
        DISABLE_INTER_COMPONENT_SCOPE_VALIDATION,
        NULLABLE_VALIDATION(ValidationType.ERROR, ValidationType.WARNING),
        PRIVATE_MEMBER_VALIDATION(ValidationType.ERROR, ValidationType.WARNING),
        STATIC_MEMBER_VALIDATION(ValidationType.ERROR, ValidationType.WARNING),
        FULL_BINDING_GRAPH_VALIDATION(ValidationType.NONE, new ValidationType[]{ValidationType.ERROR, ValidationType.WARNING}){

            @Override
            public ImmutableList<String> aliases() {
                return ImmutableList.of((Object)"dagger.moduleBindingValidation");
            }
        }
        ,
        MODULE_HAS_DIFFERENT_SCOPES_VALIDATION(ValidationType.ERROR, ValidationType.WARNING),
        EXPLICIT_BINDING_CONFLICTS_WITH_INJECT(ValidationType.WARNING, ValidationType.ERROR, ValidationType.NONE);

        final ValidationType defaultType;
        final ImmutableSet<ValidationType> validTypes;

        private Validation() {
            this(ValidationType.ERROR, ValidationType.WARNING, ValidationType.NONE);
        }

        private Validation(ValidationType defaultType, ValidationType ... moreValidTypes) {
            this.defaultType = defaultType;
            this.validTypes = Sets.immutableEnumSet((Enum)defaultType, (Enum[])moreValidTypes);
        }

        @Override
        public ValidationType defaultValue() {
            return this.defaultType;
        }

        @Override
        public Set<ValidationType> validValues() {
            return this.validTypes;
        }

        @Override
        public String toString() {
            return ProcessingEnvironmentCompilerOptions.optionName(this);
        }
    }

    static enum Feature implements EnumOption<FeatureStatus>
    {
        FAST_INIT,
        EXPERIMENTAL_ANDROID_MODE,
        FORMAT_GENERATED_SOURCE,
        WRITE_PRODUCER_NAME_IN_TOKEN,
        WARN_IF_INJECTION_FACTORY_NOT_GENERATED_UPSTREAM,
        IGNORE_PRIVATE_AND_STATIC_INJECTION_FOR_COMPONENT,
        EXPERIMENTAL_AHEAD_OF_TIME_SUBCOMPONENTS,
        FORCE_USE_SERIALIZED_COMPONENT_IMPLEMENTATIONS,
        EMIT_MODIFIABLE_METADATA_ANNOTATIONS(FeatureStatus.ENABLED),
        PLUGINS_VISIT_FULL_BINDING_GRAPHS,
        FLOATING_BINDS_METHODS,
        EXPERIMENTAL_DAGGER_ERROR_MESSAGES,
        STRICT_MULTIBINDING_VALIDATION,
        VALIDATE_TRANSITIVE_COMPONENT_DEPENDENCIES(FeatureStatus.ENABLED);

        final FeatureStatus defaultValue;

        private Feature() {
            this(FeatureStatus.DISABLED);
        }

        private Feature(FeatureStatus defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public FeatureStatus defaultValue() {
            return this.defaultValue;
        }

        @Override
        public Set<FeatureStatus> validValues() {
            return EnumSet.allOf(FeatureStatus.class);
        }

        @Override
        public String toString() {
            return ProcessingEnvironmentCompilerOptions.optionName(this);
        }
    }

    static enum KeyOnlyOption implements CommandLineOption
    {
        HEADER_COMPILATION{

            @Override
            public String toString() {
                return "experimental_turbine_hjar";
            }
        }
        ,
        USE_GRADLE_INCREMENTAL_PROCESSING{

            @Override
            public String toString() {
                return "dagger.gradle.incremental";
            }
        };

    }

    private static interface EnumOption<E extends Enum<E>>
    extends CommandLineOption {
        public E defaultValue();

        public Set<E> validValues();
    }

    private static interface CommandLineOption {
        public String toString();

        default public ImmutableList<String> aliases() {
            return ImmutableList.of();
        }

        default public Stream<String> allNames() {
            return Stream.concat(Stream.of(this.toString()), this.aliases().stream());
        }
    }
}

