/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingDeclarationFormatter;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.model.Key;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;

final class MapMultibindingValidator
implements BindingGraphPlugin {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;
    private final KeyFactory keyFactory;

    @Inject
    MapMultibindingValidator(BindingDeclarationFormatter bindingDeclarationFormatter, KeyFactory keyFactory) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        this.keyFactory = keyFactory;
    }

    public String pluginName() {
        return "Dagger/MapKeys";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        this.mapMultibindings(bindingGraph).forEach(binding -> {
            ImmutableSet<ContributionBinding> contributions = this.mapBindingContributions((Binding)binding, bindingGraph);
            this.checkForDuplicateMapKeys((Binding)binding, contributions, diagnosticReporter);
            this.checkForInconsistentMapKeyAnnotationTypes((Binding)binding, contributions, diagnosticReporter);
        });
    }

    private ImmutableSet<Binding> mapMultibindings(BindingGraph bindingGraph) {
        ImmutableSetMultimap mapMultibindings = (ImmutableSetMultimap)bindingGraph.bindings().stream().filter(node -> node.kind().equals((Object)BindingKind.MULTIBOUND_MAP)).collect(DaggerStreams.toImmutableSetMultimap(BindingGraph.MaybeBinding::key, node -> node));
        SetMultimap plainValueMapMultibindings = Multimaps.filterKeys((SetMultimap)mapMultibindings, key -> !MapType.from(key).valuesAreFrameworkType());
        SetMultimap providerValueMapMultibindings = Multimaps.filterKeys((SetMultimap)mapMultibindings, key -> MapType.from(key).valuesAreTypeOf(TypeNames.PROVIDER) && !plainValueMapMultibindings.containsKey((Object)this.keyFactory.unwrapMapValueType((Key)key)));
        SetMultimap producerValueMapMultibindings = Multimaps.filterKeys((SetMultimap)mapMultibindings, key -> MapType.from(key).valuesAreTypeOf(TypeNames.PRODUCER) && !plainValueMapMultibindings.containsKey((Object)this.keyFactory.unwrapMapValueType((Key)key)) && !providerValueMapMultibindings.containsKey((Object)this.keyFactory.rewrapMapKey((Key)key, TypeNames.PRODUCER, TypeNames.PROVIDER).get()));
        return new ImmutableSet.Builder().addAll((Iterable)plainValueMapMultibindings.values()).addAll((Iterable)providerValueMapMultibindings.values()).addAll((Iterable)producerValueMapMultibindings.values()).build();
    }

    private ImmutableSet<ContributionBinding> mapBindingContributions(Binding binding, BindingGraph bindingGraph) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP));
        return (ImmutableSet)bindingGraph.requestedBindings(binding).stream().map(b -> (BindingNode)b).map(b -> (ContributionBinding)b.delegate()).collect(DaggerStreams.toImmutableSet());
    }

    private void checkForDuplicateMapKeys(Binding multiboundMapBinding, ImmutableSet<ContributionBinding> contributions, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap contributionsByMapKey = ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(contributions, ContributionBinding::wrappedMapKeyAnnotation));
        for (Set contributionsForOneMapKey : Multimaps.asMap((SetMultimap)contributionsByMapKey).values()) {
            if (contributionsForOneMapKey.size() <= 1) continue;
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)multiboundMapBinding, this.duplicateMapKeyErrorMessage(contributionsForOneMapKey, multiboundMapBinding.key()));
        }
    }

    private void checkForInconsistentMapKeyAnnotationTypes(Binding multiboundMapBinding, ImmutableSet<ContributionBinding> contributions, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> contributionsByMapKeyAnnotationType = MapMultibindingValidator.indexByMapKeyAnnotationType(contributions);
        if (contributionsByMapKeyAnnotationType.keySet().size() > 1) {
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)multiboundMapBinding, this.inconsistentMapKeyAnnotationTypesErrorMessage(contributionsByMapKeyAnnotationType, multiboundMapBinding.key()));
        }
    }

    private static ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> indexByMapKeyAnnotationType(ImmutableSet<ContributionBinding> contributions) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(contributions, mapBinding -> MoreTypes.equivalence().wrap((Object)mapBinding.mapKeyAnnotation().get().getAnnotationType())));
    }

    private String inconsistentMapKeyAnnotationTypesErrorMessage(ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> contributionsByMapKeyAnnotationType, Key mapBindingKey) {
        StringBuilder message = new StringBuilder(mapBindingKey.toString()).append(" uses more than one @MapKey annotation type");
        Multimaps.asMap(contributionsByMapKeyAnnotationType).forEach((annotationType, contributions) -> {
            message.append('\n').append("    ").append(annotationType.get()).append(':');
            this.bindingDeclarationFormatter.formatIndentedList(message, contributions, 2);
        });
        return message.toString();
    }

    private String duplicateMapKeyErrorMessage(Set<ContributionBinding> contributionsForOneMapKey, Key mapBindingKey) {
        StringBuilder message = new StringBuilder("The same map key is bound more than once for ").append(mapBindingKey);
        this.bindingDeclarationFormatter.formatIndentedList(message, ImmutableList.sortedCopyOf(BindingDeclaration.COMPARATOR, contributionsForOneMapKey), 1);
        return message.toString();
    }
}

