/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.binding.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.binding.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

@AutoValue
public abstract class MembersInjectionBinding
extends Binding {
    static MembersInjectionBinding create(Key key, ImmutableSet<DependencyRequest> dependencies, Optional<MembersInjectionBinding> unresolved, ImmutableSortedSet<InjectionSite> injectionSites) {
        return new AutoValue_MembersInjectionBinding(key, dependencies, unresolved, injectionSites);
    }

    @Override
    public final Optional<XElement> bindingElement() {
        return Optional.of(this.membersInjectedType());
    }

    public final XTypeElement membersInjectedType() {
        return this.key().type().xprocessing().getTypeElement();
    }

    public abstract Optional<MembersInjectionBinding> unresolved();

    @Override
    public Optional<XTypeElement> contributingModule() {
        return Optional.empty();
    }

    public abstract ImmutableSortedSet<InjectionSite> injectionSites();

    @Override
    public BindingType bindingType() {
        return BindingType.MEMBERS_INJECTION;
    }

    @Override
    public BindingKind kind() {
        return BindingKind.MEMBERS_INJECTION;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    public boolean hasLocalInjectionSites() {
        return this.injectionSites().stream().anyMatch(injectionSite -> injectionSite.element().getEnclosingElement().equals(XConverters.toJavac((XTypeElement)this.membersInjectedType())));
    }

    @Override
    public boolean requiresModuleInstance() {
        return false;
    }

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue
    public static abstract class InjectionSite {
        public abstract Kind kind();

        public abstract Element element();

        public abstract ImmutableSet<DependencyRequest> dependencies();

        @Memoized
        public int indexAmongAtInjectMembersWithSameSimpleName() {
            return this.element().getEnclosingElement().getEnclosedElements().stream().filter(element -> MoreElements.isAnnotationPresent((Element)element, Inject.class)).filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE)).filter(element -> element.getSimpleName().equals(this.element().getSimpleName())).collect(Collectors.toList()).indexOf(this.element());
        }

        public static InjectionSite field(VariableElement element, DependencyRequest dependency) {
            return new AutoValue_MembersInjectionBinding_InjectionSite(Kind.FIELD, element, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)dependency));
        }

        public static InjectionSite method(ExecutableElement element, Iterable<DependencyRequest> dependencies) {
            return new AutoValue_MembersInjectionBinding_InjectionSite(Kind.METHOD, element, (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf(dependencies));
        }

        public static enum Kind {
            FIELD,
            METHOD;

        }
    }
}

