/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import dagger.internal.codegen.base.Formatter;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor8;

public final class ElementFormatter
extends Formatter<Element> {
    private static final ElementVisitor<String, Void> ELEMENT_TO_STRING = new ElementKindVisitor8<String, Void>(){

        @Override
        public String visitExecutable(ExecutableElement executableElement, Void aVoid) {
            return this.enclosingTypeAndMemberName(executableElement).append(executableElement.getParameters().stream().map(parameter -> parameter.asType().toString()).collect(Collectors.joining(", ", "(", ")"))).toString();
        }

        @Override
        public String visitVariableAsParameter(VariableElement parameter, Void aVoid) {
            ExecutableElement methodOrConstructor = MoreElements.asExecutable((Element)parameter.getEnclosingElement());
            return this.enclosingTypeAndMemberName(methodOrConstructor).append('(').append(Formatter.formatArgumentInList(methodOrConstructor.getParameters().indexOf(parameter), methodOrConstructor.getParameters().size(), parameter.getSimpleName())).append(')').toString();
        }

        @Override
        public String visitVariableAsField(VariableElement field, Void aVoid) {
            return this.enclosingTypeAndMemberName(field).toString();
        }

        @Override
        public String visitType(TypeElement type, Void aVoid) {
            return type.getQualifiedName().toString();
        }

        @Override
        protected String defaultAction(Element element, Void aVoid) {
            throw new UnsupportedOperationException("Can't determine string for " + (Object)((Object)element.getKind()) + " element " + element);
        }

        private StringBuilder enclosingTypeAndMemberName(Element element) {
            StringBuilder name = new StringBuilder(element.getEnclosingElement().accept(this, null));
            if (!element.getSimpleName().contentEquals("<init>")) {
                name.append('.').append(element.getSimpleName());
            }
            return name;
        }
    };

    @Inject
    ElementFormatter() {
    }

    @Override
    public String format(Element element) {
        return ElementFormatter.elementToString(element);
    }

    public static String elementToString(Element element) {
        return element.accept(ELEMENT_TO_STRING, null);
    }
}

