/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.ValidationReport;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ForReleasableReferencesValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;

    @Inject
    ForReleasableReferencesValidator(Messager messager) {
        this.messager = messager;
    }

    ValidationReport<Element> validateAnnotatedElement(Element annotatedElement) {
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(annotatedElement, ForReleasableReferences.class));
        ValidationReport.Builder<Element> report = ValidationReport.about(annotatedElement);
        AnnotationMirror annotation = DaggerElements.getAnnotationMirror(annotatedElement, ForReleasableReferences.class).get();
        TypeElement scopeType = MoreTypes.asTypeElement(MoreAnnotationMirrors.getTypeValue(annotation, "value"));
        if (!dagger.model.Scope.isScope((TypeElement)scopeType)) {
            report.addError(ForReleasableReferencesValidator.forReleasableReferencesValueNotAScope(scopeType), annotatedElement, annotation);
        } else if (!Scopes.scope(scopeType).canReleaseReferences()) {
            report.addError(ForReleasableReferencesValidator.forReleasableReferencesValueCannotReleaseReferences(scopeType), annotatedElement, annotation);
        }
        return report.build();
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(ForReleasableReferences.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        elementsByAnnotation.get(ForReleasableReferences.class).stream().map(this::validateAnnotatedElement).forEach(report -> report.printMessagesTo(this.messager));
        return ImmutableSet.of();
    }

    private static String forReleasableReferencesValueNotAScope(TypeElement scopeType) {
        return ForReleasableReferencesValidator.forReleasableReferencesValueNeedsAnnotation(scopeType, String.format("@%s and @%s", Scope.class.getCanonicalName(), CanReleaseReferences.class.getCanonicalName()));
    }

    private static String forReleasableReferencesValueCannotReleaseReferences(TypeElement scopeType) {
        return ForReleasableReferencesValidator.forReleasableReferencesValueNeedsAnnotation(scopeType, "@" + CanReleaseReferences.class.getCanonicalName());
    }

    private static String forReleasableReferencesValueNeedsAnnotation(TypeElement scopeType, String annotations) {
        return String.format("The value of @%s must be a reference-releasing scope. Did you mean to annotate %s with %s? Or did you mean to use a different class here?", ForReleasableReferences.class.getSimpleName(), scopeType.getQualifiedName(), annotations);
    }
}

