/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.GwtCompatibility;
import dagger.internal.codegen.InjectionMethods;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.model.BindingKind;
import dagger.model.Key;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final Types types;
    private final CompilerOptions compilerOptions;

    @Inject
    FactoryGenerator(Filer filer, Elements elements, SourceVersion sourceVersion, Types types, CompilerOptions compilerOptions) {
        super(filer, elements, sourceVersion);
        this.types = types;
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(ProvisionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProvisionBinding binding) {
        return binding.bindingElement();
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProvisionBinding binding) {
        com.google.common.base.Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        return binding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.DELEGATE) ? Optional.empty() : Optional.of(this.factoryBuilder(binding));
    }

    private TypeSpec.Builder factoryBuilder(ProvisionBinding binding) {
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)this.nameGeneratedType(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(FactoryGenerator.factoryTypeName(binding)).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding));
        this.addConstructorAndFields(binding, factoryBuilder);
        factoryBuilder.addMethod(this.getMethod(binding));
        factoryBuilder.addMethod(this.provideInstanceMethod(binding));
        this.addCreateMethod(binding, factoryBuilder);
        factoryBuilder.addMethod(InjectionMethods.ProvisionMethod.create(binding, this.compilerOptions));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        return factoryBuilder;
    }

    private void addConstructorAndFields(ProvisionBinding binding, TypeSpec.Builder factoryBuilder) {
        if (binding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.SINGLETON_INSTANCE)) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.constructorParams(binding).forEach(param -> {
            constructor.addParameter(param).addStatement("this.$1N = $1N", new Object[]{param});
            factoryBuilder.addField(FieldSpec.builder((TypeName)param.type, (String)param.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        });
        factoryBuilder.addMethod(constructor.build());
    }

    private ImmutableList<ParameterSpec> constructorParams(ProvisionBinding binding) {
        ImmutableList.Builder params = ImmutableList.builder();
        this.moduleParameter(binding).ifPresent(arg_0 -> ((ImmutableList.Builder)params).add(arg_0));
        this.frameworkFields(binding).values().forEach(field -> params.add((Object)FactoryGenerator.toParameter(field)));
        return params.build();
    }

    private Optional<ParameterSpec> moduleParameter(ProvisionBinding binding) {
        if (binding.requiresModuleInstance()) {
            TypeName type = TypeName.get((TypeMirror)binding.bindingTypeElement().get().asType());
            return Optional.of(ParameterSpec.builder((TypeName)type, (String)"module", (Modifier[])new Modifier[0]).build());
        }
        return Optional.empty();
    }

    private ImmutableMap<Key, FieldSpec> frameworkFields(ProvisionBinding binding) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        if (binding.requiresModuleInstance()) {
            uniqueFieldNames.claim("module");
        }
        ImmutableMap.Builder fields = ImmutableMap.builder();
        SourceFiles.generateBindingFieldsForDependencies(binding).forEach((key, frameworkField) -> {
            ParameterizedTypeName type = frameworkField.type();
            String name = uniqueFieldNames.getUniqueName(frameworkField.name());
            fields.put(key, (Object)FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        });
        return fields.build();
    }

    private void addCreateMethod(ProvisionBinding binding, TypeSpec.Builder factoryBuilder) {
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding));
        switch (binding.factoryCreationStrategy()) {
            case SINGLETON_INSTANCE: {
                FieldSpec.Builder instanceFieldBuilder = FieldSpec.builder((TypeName)this.nameGeneratedType(binding), (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.nameGeneratedType(binding)});
                if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
                    instanceFieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                    createMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
                }
                createMethodBuilder.addStatement("return INSTANCE", new Object[0]);
                factoryBuilder.addField(instanceFieldBuilder.build());
                break;
            }
            case CLASS_CONSTRUCTOR: {
                ImmutableList<ParameterSpec> params = this.constructorParams(binding);
                createMethodBuilder.addParameters(params);
                createMethodBuilder.addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(Lists.transform(params, input -> CodeBlock.of((String)"$N", (Object[])new Object[]{input})))});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        factoryBuilder.addMethod(createMethodBuilder.build());
    }

    private MethodSpec getMethod(ProvisionBinding binding) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(FactoryGenerator.providedTypeName(binding)).addStatement("return provideInstance($L)", new Object[]{this.constructorParams(binding).stream().map(parameter -> CodeBlock.of((String)"$N", (Object[])new Object[]{parameter})).collect(CodeBlocks.toParametersCodeBlock())});
        binding.nullableType().ifPresent(nullableType -> CodeBlocks.addAnnotation(methodBuilder, nullableType));
        return methodBuilder.build();
    }

    private MethodSpec provideInstanceMethod(ProvisionBinding binding) {
        TypeName providedTypeName = FactoryGenerator.providedTypeName(binding);
        MethodSpec.Builder provideInstanceMethod = MethodSpec.methodBuilder((String)"provideInstance").returns(providedTypeName).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding)).addParameters(this.constructorParams(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        ImmutableMap<Key, FieldSpec> frameworkFields = this.frameworkFields(binding);
        CodeBlock parametersCodeBlock = CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)SourceFiles.frameworkFieldUsages(binding.provisionDependencies(), frameworkFields).values());
        if (binding.kind().equals((Object)BindingKind.PROVISION)) {
            binding.nullableType().ifPresent(nullableType -> CodeBlocks.addAnnotation(provideInstanceMethod, nullableType));
            provideInstanceMethod.addStatement("return $L", new Object[]{InjectionMethods.ProvisionMethod.invoke(binding, request -> SourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{frameworkFields.get((Object)request.key())}), request.kind()), this.nameGeneratedType(binding), binding.requiresModuleInstance() ? Optional.of(CodeBlock.of((String)"module", (Object[])new Object[0])) : Optional.empty(), this.compilerOptions)});
        } else if (!binding.injectionSites().isEmpty()) {
            CodeBlock instance = CodeBlock.of((String)"instance", (Object[])new Object[0]);
            provideInstanceMethod.addStatement("$1T $2L = new $1T($3L)", new Object[]{providedTypeName, instance, parametersCodeBlock}).addCode(InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), this.nameGeneratedType(binding), instance, binding.key().type(), this.types, arg_0 -> SourceFiles.frameworkFieldUsages(binding.dependencies(), frameworkFields).get(arg_0))).addStatement("return $L", new Object[]{instance});
        } else {
            provideInstanceMethod.addStatement("return new $T($L)", new Object[]{providedTypeName, parametersCodeBlock});
        }
        return provideInstanceMethod.build();
    }

    private static TypeName providedTypeName(ProvisionBinding binding) {
        return TypeName.get((TypeMirror)binding.contributedType());
    }

    private static TypeName factoryTypeName(ProvisionBinding binding) {
        return TypeNames.factoryOf(FactoryGenerator.providedTypeName(binding));
    }

    private static ParameterSpec toParameter(FieldSpec field) {
        return ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build();
    }

    static CodeBlock checkNotNullProvidesMethod(CodeBlock providesMethodInvocation) {
        return CodeBlock.of((String)"$T.checkNotNull($L, $S)", (Object[])new Object[]{Preconditions.class, providesMethodInvocation, "Cannot return null from a non-@Nullable @Provides method"});
    }
}

