/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.AutoValue_DuplicateBindingsValidation_SourceAndRequest;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingNodeImpl;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.Optionals;
import dagger.model.BindingGraph;
import dagger.model.DependencyRequest;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DuplicateBindingsValidation
implements BindingGraphPlugin {
    private static final Comparator<BindingDeclaration> BINDING_DECLARATION_COMPARATOR = Comparator.comparing(declaration -> declaration.contributingModule().isPresent() ? declaration.contributingModule() : declaration.bindingTypeElement(), Optionals.emptiesLast(Comparator.comparing(type -> type.getQualifiedName().toString()))).thenComparing(declaration -> declaration.bindingElement(), Optionals.emptiesLast(Comparator.comparing(element -> element.getSimpleName().toString()).thenComparing(element -> element.asType().toString())));
    private final BindingDeclarationFormatter bindingDeclarationFormatter;

    @Inject
    DuplicateBindingsValidation(BindingDeclarationFormatter bindingDeclarationFormatter) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
    }

    public String pluginName() {
        return "Dagger/DuplicateBindings";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        Multimaps.asMap(SourceAndRequest.indexEdgesBySourceAndRequest(bindingGraph)).forEach((sourceAndRequest, dependencyEdges) -> {
            if (dependencyEdges.size() > 1) {
                this.reportDuplicateBindings(sourceAndRequest.request(), (Set<BindingGraph.DependencyEdge>)dependencyEdges, bindingGraph, diagnosticReporter);
            }
        });
    }

    private void reportDuplicateBindings(DependencyRequest dependencyRequest, Set<BindingGraph.DependencyEdge> duplicateDependencies, BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        ImmutableSet duplicateBindings = duplicateDependencies.stream().map(edge -> (BindingGraph.Node)bindingGraph.incidentNodes(edge).target()).flatMap(DaggerStreams.instancesOf(BindingGraph.BindingNode.class)).collect(DaggerStreams.toImmutableSet());
        diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, (BindingGraph.DependencyEdge)Iterables.get(duplicateDependencies, (int)0), Iterables.any(duplicateBindings, node -> node.binding().kind().isMultibinding()) ? this.incompatibleBindingsMessage(dependencyRequest, duplicateBindings, bindingGraph) : this.duplicateBindingMessage(dependencyRequest, duplicateBindings, bindingGraph));
    }

    private String duplicateBindingMessage(DependencyRequest dependencyRequest, ImmutableSet<BindingGraph.BindingNode> duplicateBindings, BindingGraph graph) {
        StringBuilder message = new StringBuilder().append(dependencyRequest.key()).append(" is bound multiple times:");
        this.formatDeclarations(message, 1, (Iterable<? extends BindingDeclaration>)this.declarations(graph, (Set<BindingGraph.BindingNode>)duplicateBindings));
        return message.toString();
    }

    private String incompatibleBindingsMessage(DependencyRequest dependencyRequest, ImmutableSet<BindingGraph.BindingNode> duplicateBindings, BindingGraph graph) {
        ImmutableSet multibindings = duplicateBindings.stream().filter(node -> node.binding().kind().isMultibinding()).collect(DaggerStreams.toImmutableSet());
        Verify.verify((multibindings.size() == 1 ? 1 : 0) != 0, (String)"expected only one multibinding for %s: %s", (Object)dependencyRequest, multibindings);
        StringBuilder message = new StringBuilder();
        Formatter messageFormatter = new Formatter(message);
        messageFormatter.format("%s has incompatible bindings or declarations:\n", dependencyRequest.key());
        message.append("    ");
        BindingGraph.BindingNode multibinding = (BindingGraph.BindingNode)Iterables.getOnlyElement(multibindings);
        messageFormatter.format("%s bindings and declarations:", this.multibindingTypeString(multibinding));
        this.formatDeclarations(message, 2, (Iterable<? extends BindingDeclaration>)this.declarations(graph, (Set<BindingGraph.BindingNode>)multibindings));
        Set uniqueBindings = Sets.filter(duplicateBindings, binding -> !binding.equals(multibinding));
        message.append("    ").append("Unique bindings and declarations:");
        this.formatDeclarations(message, 2, Sets.filter(this.declarations(graph, uniqueBindings), declaration -> !(declaration instanceof MultibindingDeclaration)));
        return message.toString();
    }

    private void formatDeclarations(StringBuilder builder, int indentLevel, Iterable<? extends BindingDeclaration> bindingDeclarations) {
        this.bindingDeclarationFormatter.formatIndentedList(builder, ImmutableList.copyOf(bindingDeclarations), indentLevel);
        builder.append('\n');
    }

    private ImmutableSet<BindingDeclaration> declarations(BindingGraph graph, Set<BindingGraph.BindingNode> bindings) {
        return bindings.stream().flatMap(node -> this.declarations(graph, (BindingGraph.BindingNode)node).stream()).distinct().sorted(BINDING_DECLARATION_COMPARATOR).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<BindingDeclaration> declarations(BindingGraph graph, BindingGraph.BindingNode node) {
        ImmutableSet.Builder declarations = ImmutableSet.builder();
        ((BindingNodeImpl)node).associatedDeclarations().forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        if (node.binding() instanceof BindingDeclaration) {
            BindingDeclaration declaration = (BindingDeclaration)node.binding();
            if (this.bindingDeclarationFormatter.canFormat(declaration)) {
                declarations.add((Object)declaration);
            } else {
                graph.successors((Object)node).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.BindingNode.class)).flatMap(dependency -> this.declarations(graph, (BindingGraph.BindingNode)dependency).stream()).forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
            }
        }
        return declarations.build();
    }

    private String multibindingTypeString(BindingGraph.BindingNode multibinding) {
        switch (multibinding.binding().kind()) {
            case MULTIBOUND_MAP: {
                return "Map";
            }
            case MULTIBOUND_SET: {
                return "Set";
            }
        }
        throw new AssertionError(multibinding);
    }

    @AutoValue
    static abstract class SourceAndRequest {
        SourceAndRequest() {
        }

        abstract BindingGraph.Node source();

        abstract DependencyRequest request();

        static ImmutableSetMultimap<SourceAndRequest, BindingGraph.DependencyEdge> indexEdgesBySourceAndRequest(BindingGraph bindingGraph) {
            return bindingGraph.dependencyEdges().stream().collect(DaggerStreams.toImmutableSetMultimap(edge -> SourceAndRequest.create((BindingGraph.Node)bindingGraph.incidentNodes(edge).source(), edge.dependencyRequest()), edge -> edge));
        }

        static SourceAndRequest create(BindingGraph.Node source, DependencyRequest request) {
            return new AutoValue_DuplicateBindingsValidation_SourceAndRequest(source, request);
        }
    }
}

