/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.KeyFactory;
import dagger.model.BindingGraph;
import dagger.model.Key;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DependsOnProductionExecutorValidator
implements BindingGraphPlugin {
    private final CompilerOptions compilerOptions;
    private final KeyFactory keyFactory;

    @Inject
    DependsOnProductionExecutorValidator(CompilerOptions compilerOptions, KeyFactory keyFactory) {
        this.compilerOptions = compilerOptions;
        this.keyFactory = keyFactory;
    }

    public String pluginName() {
        return "Dagger/DependsOnProductionExecutor";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (!this.compilerOptions.usesProducers()) {
            return;
        }
        Key productionImplementationExecutorKey = this.keyFactory.forProductionImplementationExecutor();
        Key productionExecutorKey = this.keyFactory.forProductionExecutor();
        bindingGraph.bindingNodes(productionExecutorKey).stream().flatMap(productionExecutorBinding -> bindingGraph.predecessors(productionExecutorBinding).stream()).flatMap(DaggerStreams.instancesOf(BindingGraph.BindingNode.class)).filter(binding -> !binding.binding().key().equals(productionImplementationExecutorKey)).forEach(binding -> this.reportError(diagnosticReporter, (BindingGraph.BindingNode)binding));
    }

    private void reportError(DiagnosticReporter diagnosticReporter, BindingGraph.BindingNode bindingNode) {
        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, bindingNode, "%s may not depend on the production executor", (Object)bindingNode.binding().key(), new Object[0]);
    }
}

