/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.Component;
import dagger.Subcomponent;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphConverter;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.BindingGraphPlugins;
import dagger.internal.codegen.BuilderValidator;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentDescriptorValidator;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.Validation;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ComponentProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final BuilderValidator builderValidator;
    private final ComponentDescriptorValidator componentDescriptorValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final ComponentGenerator componentGenerator;
    private final BindingGraphConverter bindingGraphConverter;
    private final BindingGraphPlugins validationPlugins;
    private final BindingGraphPlugins spiPlugins;
    private final CompilerOptions compilerOptions;

    @Inject
    ComponentProcessingStep(Messager messager, ComponentValidator componentValidator, BuilderValidator builderValidator, ComponentDescriptorValidator componentDescriptorValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, ComponentGenerator componentGenerator, BindingGraphConverter bindingGraphConverter, @Validation BindingGraphPlugins validationPlugins, BindingGraphPlugins spiPlugins, CompilerOptions compilerOptions) {
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.builderValidator = builderValidator;
        this.componentDescriptorValidator = componentDescriptorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
        this.bindingGraphConverter = bindingGraphConverter;
        this.validationPlugins = validationPlugins;
        this.spiPlugins = spiPlugins;
        this.compilerOptions = compilerOptions;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Component.class, Component.Builder.class, ProductionComponent.class, ProductionComponent.Builder.class, Subcomponent.class, Subcomponent.Builder.class, (Object[])new Class[]{ProductionSubcomponent.class, ProductionSubcomponent.Builder.class});
    }

    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder rejectedElements = ImmutableSet.builder();
        ImmutableSet<Element> componentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Component.class, ProductionComponent.class);
        ImmutableSet<Element> componentBuilderElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Component.Builder.class, ProductionComponent.Builder.class);
        ImmutableSet<Element> subcomponentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Subcomponent.class, ProductionSubcomponent.class);
        ImmutableSet<Element> subcomponentBuilderElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Subcomponent.Builder.class, ProductionSubcomponent.Builder.class);
        Map<Element, ValidationReport<TypeElement>> builderReportsByComponent = this.processBuilders((Set<? extends Element>)componentBuilderElements);
        Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent = this.processBuilders((Set<? extends Element>)subcomponentBuilderElements);
        Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent = this.processSubcomponents((Set<? extends Element>)subcomponentElements, (Set<? extends Element>)subcomponentBuilderElements);
        for (TypeElement componentTypeElement : ElementFilter.typesIn(componentElements)) {
            try {
                BindingGraph bindingGraph;
                ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(componentTypeElement, (Set<? extends Element>)subcomponentElements, (Set<? extends Element>)subcomponentBuilderElements);
                validationReport.report().printMessagesTo(this.messager);
                if (!this.isClean(validationReport, builderReportsByComponent, reportsBySubcomponent, builderReportsBySubcomponent)) continue;
                ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.forComponent(componentTypeElement);
                ValidationReport<TypeElement> componentDescriptorReport = this.componentDescriptorValidator.validate(componentDescriptor);
                componentDescriptorReport.printMessagesTo(this.messager);
                if (!componentDescriptorReport.isClean() || !this.isValid(bindingGraph = this.bindingGraphFactory.create(componentDescriptor))) continue;
                this.generateComponent(bindingGraph);
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)componentTypeElement);
            }
        }
        if (this.compilerOptions.aheadOfTimeSubcomponents()) {
            for (TypeElement subcomponentTypeElement : ElementFilter.typesIn(subcomponentElements)) {
                if (!this.subcomponentIsClean(subcomponentTypeElement, reportsBySubcomponent, builderReportsBySubcomponent)) continue;
                try {
                    ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.forComponent(subcomponentTypeElement);
                    BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor);
                    this.generateComponent(bindingGraph);
                }
                catch (TypeNotPresentException e) {
                    rejectedElements.add((Object)subcomponentTypeElement);
                }
            }
        }
        return rejectedElements.build();
    }

    private boolean isValid(BindingGraph bindingGraph) {
        dagger.model.BindingGraph modelGraph = this.bindingGraphConverter.convert(bindingGraph);
        return !this.validationPlugins.pluginsReportErrors(modelGraph) && !this.spiPlugins.pluginsReportErrors(modelGraph);
    }

    private void generateComponent(BindingGraph bindingGraph) {
        this.componentGenerator.generate(bindingGraph, this.messager);
    }

    static ImmutableSet<Element> getElementsFromAnnotations(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation, Class<? extends Annotation> ... annotations) {
        return ImmutableSet.copyOf((Collection)Multimaps.filterKeys(elementsByAnnotation, (Predicate)Predicates.in((Collection)ImmutableSet.copyOf((Object[])annotations))).values());
    }

    private Map<Element, ValidationReport<TypeElement>> processBuilders(Set<? extends Element> builderElements) {
        HashMap builderReportsByComponent = Maps.newHashMap();
        for (Element element : builderElements) {
            ValidationReport<TypeElement> report = this.builderValidator.validate(MoreElements.asType(element));
            report.printMessagesTo(this.messager);
            builderReportsByComponent.put(element.getEnclosingElement(), report);
        }
        return builderReportsByComponent;
    }

    private Map<Element, ValidationReport<TypeElement>> processSubcomponents(Set<? extends Element> subcomponentElements, Set<? extends Element> subcomponentBuilderElements) {
        HashMap reportsBySubcomponent = Maps.newHashMap();
        for (Element element : subcomponentElements) {
            ComponentValidator.ComponentValidationReport report = this.componentValidator.validate(MoreElements.asType(element), subcomponentElements, subcomponentBuilderElements);
            report.report().printMessagesTo(this.messager);
            reportsBySubcomponent.put(element, report.report());
        }
        return reportsBySubcomponent;
    }

    private boolean isClean(ComponentValidator.ComponentValidationReport report, Map<Element, ValidationReport<TypeElement>> builderReportsByComponent, Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent, Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent) {
        TypeElement component = report.report().subject();
        ValidationReport<TypeElement> componentReport = report.report();
        if (!componentReport.isClean()) {
            return false;
        }
        ValidationReport<TypeElement> builderReport = builderReportsByComponent.get(component);
        if (builderReport != null && !builderReport.isClean()) {
            return false;
        }
        for (Element element : report.referencedSubcomponents()) {
            if (this.subcomponentIsClean(element, reportsBySubcomponent, builderReportsBySubcomponent)) continue;
            return false;
        }
        return true;
    }

    private boolean subcomponentIsClean(Element subcomponentElement, Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent, Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent) {
        ValidationReport<TypeElement> subcomponentBuilderReport = builderReportsBySubcomponent.get(subcomponentElement);
        if (subcomponentBuilderReport != null && !subcomponentBuilderReport.isClean()) {
            return false;
        }
        ValidationReport<TypeElement> subcomponentReport = reportsBySubcomponent.get(subcomponentElement);
        return subcomponentReport == null || subcomponentReport.isClean();
    }
}

