/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.TypeName;
import dagger.Lazy;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.TypeNames;
import dagger.model.RequestKind;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;

final class RequestKinds {
    private static final ImmutableMap<RequestKind, Class<?>> FRAMEWORK_CLASSES = ImmutableMap.of((Object)RequestKind.PROVIDER, Provider.class, (Object)RequestKind.LAZY, Lazy.class, (Object)RequestKind.PRODUCER, Producer.class, (Object)RequestKind.PRODUCED, Produced.class);

    static TypeMirror requestType(RequestKind requestKind, TypeMirror type, DaggerTypes types) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return types.wrapType(RequestKinds.requestType(RequestKind.LAZY, type, types), Provider.class);
            }
            case FUTURE: {
                return types.wrapType(type, ListenableFuture.class);
            }
        }
        return types.wrapType(type, RequestKinds.frameworkClass(requestKind).get());
    }

    static TypeName requestTypeName(RequestKind requestKind, TypeName keyType) {
        switch (requestKind) {
            case INSTANCE: {
                return keyType;
            }
            case PROVIDER: {
                return TypeNames.providerOf(keyType);
            }
            case LAZY: {
                return TypeNames.lazyOf(keyType);
            }
            case PROVIDER_OF_LAZY: {
                return TypeNames.providerOf((TypeName)TypeNames.lazyOf(keyType));
            }
            case PRODUCER: {
                return TypeNames.producerOf(keyType);
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyType);
            }
            case FUTURE: {
                return TypeNames.listenableFutureOf(keyType);
            }
        }
        throw new AssertionError(requestKind);
    }

    static RequestKind getRequestKind(TypeMirror type) {
        DaggerTypes.checkTypePresent(type);
        for (RequestKind kind : RequestKind.values()) {
            if (!RequestKinds.matchesKind(kind, type)) continue;
            if (kind.equals((Object)RequestKind.PROVIDER) && RequestKinds.matchesKind(RequestKind.LAZY, RequestKinds.extractKeyType(kind, type))) {
                return RequestKind.PROVIDER_OF_LAZY;
            }
            return kind;
        }
        return RequestKind.INSTANCE;
    }

    private static boolean matchesKind(RequestKind kind, TypeMirror type) {
        Optional<Class<?>> frameworkClass = RequestKinds.frameworkClass(kind);
        return frameworkClass.isPresent() && MoreTypes.isType(type) && MoreTypes.isTypeOf(frameworkClass.get(), type) && !MoreTypes.asDeclared(type).getTypeArguments().isEmpty();
    }

    static TypeMirror extractKeyType(RequestKind requestKind, TypeMirror type) {
        DaggerTypes.checkTypePresent(type);
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return RequestKinds.extractKeyType(RequestKind.LAZY, RequestKinds.extractKeyType(RequestKind.PROVIDER, type));
            }
        }
        Preconditions.checkArgument((MoreTypes.isType(type) && MoreTypes.isTypeOf(RequestKinds.frameworkClass(requestKind).get(), type) ? 1 : 0) != 0);
        return (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(type).getTypeArguments());
    }

    static Optional<Class<?>> frameworkClass(RequestKind requestKind) {
        return Optional.ofNullable((Class)FRAMEWORK_CLASSES.get((Object)requestKind));
    }

    static boolean entryPointCanUseProduction(RequestKind requestKind) {
        switch (requestKind) {
            case INSTANCE: 
            case PROVIDER_OF_LAZY: 
            case PROVIDER: 
            case LAZY: 
            case MEMBERS_INJECTION: {
                return false;
            }
            case FUTURE: 
            case PRODUCER: 
            case PRODUCED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private RequestKinds() {
    }
}

