/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ReferenceReleasingManagerFields;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.TypeNames;
import dagger.model.Scope;
import dagger.releasablereferences.ReleasableReferenceManager;
import dagger.releasablereferences.TypedReleasableReferenceManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ReleasableReferenceManagerSetProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ContributionBinding binding;
    private final BindingGraph graph;
    private final GeneratedComponentModel generatedComponentModel;
    private final ReferenceReleasingManagerFields referenceReleasingManagerFields;

    ReleasableReferenceManagerSetProviderCreationExpression(ContributionBinding binding, GeneratedComponentModel generatedComponentModel, ReferenceReleasingManagerFields referenceReleasingManagerFields, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.referenceReleasingManagerFields = (ReferenceReleasingManagerFields)Preconditions.checkNotNull((Object)referenceReleasingManagerFields);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        TypeName keyType = TypeName.get((TypeMirror)this.binding.key().type());
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeNames.providerOf(keyType)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyType).addCode("return new $T($T.asList($L));", new Object[]{HashSet.class, Arrays.class, CodeBlocks.makeParametersCodeBlock(this.releasableReferenceManagerExpressions())}).build()).build()});
    }

    private ImmutableList<CodeBlock> releasableReferenceManagerExpressions() {
        SetType keyType = SetType.from(this.binding.key());
        ImmutableList.Builder managerExpressions = ImmutableList.builder();
        for (Scope scope : this.graph.scopesRequiringReleasableReferenceManagers()) {
            CodeBlock releasableReferenceManagerExpression = this.referenceReleasingManagerFields.getExpression(scope, this.generatedComponentModel.name());
            if (keyType.elementsAreTypeOf(ReleasableReferenceManager.class)) {
                managerExpressions.add((Object)releasableReferenceManagerExpression);
                continue;
            }
            if (keyType.elementsAreTypeOf(TypedReleasableReferenceManager.class)) {
                TypeMirror metadataType = keyType.unwrappedElementType(TypedReleasableReferenceManager.class);
                Optional metadata = scope.releasableReferencesMetadata(metadataType);
                if (!metadata.isPresent()) continue;
                managerExpressions.add((Object)ReferenceReleasingManagerFields.typedReleasableReferenceManagerDecoratorExpression(releasableReferenceManagerExpression, (AnnotationMirror)metadata.get()));
                continue;
            }
            throw new IllegalArgumentException("inappropriate key: " + this.binding);
        }
        return managerExpressions.build();
    }
}

